/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.util;

import com.togethersoft.selena.xmi.elements.XMIElementImpl;
import com.togethersoft.selena.xmi.elements.XMITransition;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.EntityNode;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.wizard.XMIWizardData;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.enum.ReferenceCollectionEnumeration;
import com.tssap.selena.model.enum.ReferenceEnumeration;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class InterchangeUtils {
    public static final String TEMPLATE_DELETED = "deleted";
    private static List internalConstants = Arrays.asList("Activity Diagram", "Use Case Diagram", "Class Diagram", "Sequence Diagram", "Collaboration Diagram", "State Diagram", "Component Diagram", "Deployment Diagram", "Package Diagram");
    private static List xmiConstants = Arrays.asList("ActivityDiagram", "UseCaseDiagram", "ClassDiagram", "SequenceDiagram", "CollaborationDiagram", "StateDiagram", "ModuleDiagram", "DeploymentDiagram", "PackageDiagram");
    private static Hashtable constantsConverter;
    private static XMIWizardData wizardData;
    private static EntityNode ourRootCutElement;

    public static void initConstantsConverter(boolean bl) throws XMIException {
        int n = internalConstants.size();
        if (n != xmiConstants.size()) {
            throw new XMIException("xmi.error.arrays");
        }
        constantsConverter = new Hashtable();
        int n2 = 0;
        while (n2 < n) {
            if (bl) {
                constantsConverter.put(internalConstants.get(n2), xmiConstants.get(n2));
            } else {
                constantsConverter.put(xmiConstants.get(n2), internalConstants.get(n2));
            }
            ++n2;
        }
    }

    public static String convertConstants(String string) {
        String string2 = string;
        if (constantsConverter.containsKey(string)) {
            string2 = (String)constantsConverter.get(string);
        }
        return string2;
    }

    public static XMIWizardData getWizardData() {
        return wizardData;
    }

    public static void setWizardData(XMIWizardData xMIWizardData) {
        wizardData = xMIWizardData;
    }

    public static Entity getContainingPackage(Entity entity) {
        Entity entity2 = entity.getParent();
        while (entity2 != null && !entity2.hasPropertyValue("$metaclass", "Package")) {
            entity2 = entity2.getParent();
        }
        return entity2;
    }

    public static Reference findReference(Entity entity, Entity entity2) {
        if (entity == null || entity2 == null) {
            return null;
        }
        ReferenceCollectionEnumeration referenceCollectionEnumeration = entity2.childReferenceCollections();
        while (referenceCollectionEnumeration.hasMoreElements()) {
            ReferenceEnumeration referenceEnumeration = referenceCollectionEnumeration.next().references();
            while (referenceEnumeration.hasMoreElements()) {
                Reference reference = referenceEnumeration.next();
                if (reference.getEntity() != entity) continue;
                return reference;
            }
        }
        return null;
    }

    public static Reference addReference(Entity entity, Entity entity2) {
        return null;
    }

    public static ReferenceEnumeration references(Entity entity) {
        if (entity == null) {
            return null;
        }
        return entity.childReferenceCollections().next().references();
    }

    public static void TreeCut(Entity entity, EntityNode entityNode) {
        entityNode = entityNode == null ? (ourRootCutElement = new EntityNode(entity)) : entityNode.addChild(entity);
        EntityEnumeration entityEnumeration = entity.childEntities();
        while (entityEnumeration.hasMoreElements()) {
            Entity entity2 = entityEnumeration.next();
            InterchangeUtils.TreeCut(entity2, entityNode);
        }
    }

    public static void TreePaste(Entity entity, EntityNode entityNode) {
        boolean bl = false;
        if (ourRootCutElement != null) {
            String string;
            if (entityNode == null) {
                entityNode = ourRootCutElement;
            }
            Entity entity2 = entityNode.getEntity();
            Enumeration enumeration = XMI11Import.storeProperties(entity2).elements();
            if (bl) {
                Diagnostic.print("PASTE1: " + entity2.getPropertyValue("$name"));
                XMIElementImpl.showProperties(entity2);
            }
            if (entity.canCreateChildEntity(string = entity2.getPropertyValue("$metaclass"), entity2)) {
                String string2 = entity2.getPropertyValue("$name");
                Entity entity3 = entity.createChildEntity(string, entity2);
                if (bl) {
                    Diagnostic.print("PASTE2: " + entity3.getPropertyValue("$name"));
                    XMIElementImpl.showProperties(entity3);
                }
                Property property = entity3.setPropertyValue("$name", string2);
                XMI11Import.updateProperties(entity3, enumeration, bl);
                if (bl) {
                    Diagnostic.print("PASTE3: " + entity3.getPropertyValue("$name") + " : " + entity3.isDeleted());
                    XMIElementImpl.showProperties(entity3);
                }
                XMI11Import.addElement(entityNode.getID(), entity3);
                InterchangeUtils.fixTablesWithThisElement(entity2, entity3);
                Enumeration enumeration2 = entityNode.getChilds();
                while (enumeration2.hasMoreElements()) {
                    EntityNode entityNode2 = (EntityNode)enumeration2.nextElement();
                    InterchangeUtils.TreePaste(entity3, entityNode2);
                }
            }
            entity2.setPropertyValue(TEMPLATE_DELETED, Boolean.TRUE.toString());
        }
    }

    private static void fixTablesWithThisElement(Entity entity, Entity entity2) {
        Enumeration enumeration = XMI11Import.getTransitions();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                XMITransition xMITransition = (XMITransition)enumeration.nextElement();
                Entity entity3 = xMITransition.getTransitionParent();
                if (entity3 == null || entity3 != entity) continue;
                xMITransition.setTransitionParent(entity2);
            }
        }
    }

    public static boolean isSupportedEncoding(String string) {
        boolean bl = false;
        try {
            String string2 = new String(new byte[0], string);
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    static {
        ourRootCutElement = null;
    }
}

