/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.util;

public class InfiniteProgressMonitorHelper {
    private static final int TOTAL_WORK_DEFAULT = 100;
    private static final int MIN_OFFSET = 1;
    private static final double ITERATION_OFFSET_DEFAULT = 20.0;
    private static int myTotalWork = 100;
    private static int myCurrentIteration = 0;
    private static double myIterationOffset = 20.0;

    public static void flush() {
        myCurrentIteration = 0;
    }

    public static int getTotalWork() {
        return myTotalWork;
    }

    public static void setTotalWork(int n) {
        myTotalWork = n;
    }

    public static void setIterationOffset(int n) {
        if (n > 0 && n < 100) {
            myIterationOffset = n;
        }
    }

    public static int getCurrentIteration() {
        return myCurrentIteration;
    }

    public static void increaseCurrentIteration() {
        ++myCurrentIteration;
    }

    public static int getNextOffset() {
        return InfiniteProgressMonitorHelper.getNextOffset(myCurrentIteration - 1);
    }

    public static int getNextOffset(int n) {
        int n2 = InfiniteProgressMonitorHelper.calculateNextOffset(myCurrentIteration, n);
        ++myCurrentIteration;
        return n2 < 1 ? 1 : n2;
    }

    private static int calculateNextOffset(int n, int n2) {
        double d = InfiniteProgressMonitorHelper.getAbsoluteOffset(n);
        double d2 = 0.0;
        if (n2 > 0) {
            d2 = InfiniteProgressMonitorHelper.getAbsoluteOffset(n2);
        }
        double d3 = d - d2;
        return (int)Math.round(d3 * (double)InfiniteProgressMonitorHelper.getTotalWork());
    }

    private static double getAbsoluteOffset(int n) {
        double d = 1.0 - myIterationOffset / 100.0;
        double d2 = Math.pow(d, n);
        return 1.0 - d2;
    }
}

