/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.util;

import com.togethersoft.selena.xmi.util.DefaultFilterDescriptor;
import com.togethersoft.selena.xmi.util.IFilterDescriptor;
import com.togethersoft.selena.xmi.wizard.XMIPlugin;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;

public class FilterRegistryReader {
    public static final String FILTER_TO_RATIONAL = "rationalFilter";
    static final String TAG_LIST = "list";
    static final String ATT_LISTNAME = "name";
    static final String ATT_LISTUID = "uid";
    static final String TAG_LISTENTRY = "list-entry";
    static final String ATT_FILETERED_TAG = "tag_name";
    private static FilterRegistryReader myInstance;
    private HashMap myLists = null;

    public static FilterRegistryReader getInstance() {
        if (myInstance == null) {
            myInstance = new FilterRegistryReader();
        }
        return myInstance;
    }

    public IFilterDescriptor getList(String string) {
        if (this.myLists == null) {
            this.myLists = new HashMap();
            this.readRegistry();
        }
        return (IFilterDescriptor)this.myLists.get(string);
    }

    private void readRegistry() {
        IPluginRegistry iPluginRegistry = Platform.getPluginRegistry();
        String string = XMIPlugin.getInstance().getDescriptor().getUniqueIdentifier();
        String string2 = "filter-list";
        IExtensionPoint iExtensionPoint = iPluginRegistry.getExtensionPoint(string, string2);
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        IConfigurationElement[] iConfigurationElementArray = null;
        int n = 0;
        while (n < iExtensionArray.length) {
            iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                this.readElement(iConfigurationElementArray[n2]);
                ++n2;
            }
            ++n;
        }
    }

    private void readElement(IConfigurationElement iConfigurationElement) {
        if (TAG_LIST.equals(iConfigurationElement.getName())) {
            IFilterDescriptor iFilterDescriptor = this.registerList(iConfigurationElement);
            IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                this.readEntry(iConfigurationElementArray[n], iFilterDescriptor);
                ++n;
            }
        }
    }

    private void readEntry(IConfigurationElement iConfigurationElement, IFilterDescriptor iFilterDescriptor) {
        if (TAG_LISTENTRY.equals(iConfigurationElement.getName())) {
            this.registerListEntry(iConfigurationElement, iFilterDescriptor);
        }
    }

    private IFilterDescriptor registerList(IConfigurationElement iConfigurationElement) {
        IFilterDescriptor iFilterDescriptor = null;
        String string = iConfigurationElement.getAttribute(ATT_LISTNAME);
        String string2 = iConfigurationElement.getAttribute(ATT_LISTUID);
        if (string != null && string2 != null && (iFilterDescriptor = (IFilterDescriptor)this.myLists.get(string2)) == null) {
            iFilterDescriptor = new DefaultFilterDescriptor(string, string2);
            this.myLists.put(string2, iFilterDescriptor);
        }
        return iFilterDescriptor;
    }

    private void registerListEntry(IConfigurationElement iConfigurationElement, IFilterDescriptor iFilterDescriptor) {
        String string = iConfigurationElement.getAttribute(ATT_FILETERED_TAG);
        if (string != null) {
            iFilterDescriptor.addFilter(string);
        }
    }
}

