/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.util;

import com.togethersoft.selena.xmi.elements.XMIAbstractElement;
import com.togethersoft.selena.xmi.elements.XMIActionState;
import com.togethersoft.selena.xmi.elements.XMIAssociation;
import com.togethersoft.selena.xmi.elements.XMIAttribute;
import com.togethersoft.selena.xmi.elements.XMIClass;
import com.togethersoft.selena.xmi.elements.XMIClassifierRole;
import com.togethersoft.selena.xmi.elements.XMIComment;
import com.togethersoft.selena.xmi.elements.XMIComponent;
import com.togethersoft.selena.xmi.elements.XMIDependency;
import com.togethersoft.selena.xmi.elements.XMIDiagram;
import com.togethersoft.selena.xmi.elements.XMIElement;
import com.togethersoft.selena.xmi.elements.XMIExtensionPoint;
import com.togethersoft.selena.xmi.elements.XMIGeneralization;
import com.togethersoft.selena.xmi.elements.XMINode;
import com.togethersoft.selena.xmi.elements.XMIOperation;
import com.togethersoft.selena.xmi.elements.XMIPackage;
import com.togethersoft.selena.xmi.elements.XMIPartition;
import com.togethersoft.selena.xmi.elements.XMIState;
import com.togethersoft.selena.xmi.elements.XMISubsystem;
import com.togethersoft.selena.xmi.elements.XMISystemBoundary;
import com.togethersoft.selena.xmi.elements.XMITransition;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.DiagramFactory;
import com.togethersoft.selena.xmi.util.XMI11Export;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.enum.PropertyEnumeration;

public abstract class ElementWriter {
    public static XMIElement writeElement(XMLWriter xMLWriter, Entity entity, XMIDiagram xMIDiagram) throws Exception {
        return ElementWriter.writeElement(xMLWriter, entity, xMIDiagram, true);
    }

    public static XMIElement writeElement(XMLWriter xMLWriter, Entity entity, XMIDiagram xMIDiagram, boolean bl) throws Exception {
        if (entity == null) {
            return null;
        }
        if (entity.isDeleted()) {
            return null;
        }
        String string = entity.getPropertyValue("$metaclass");
        Diagnostic.print("Processing Entity " + string + "; name : " + entity.getPropertyValue("$name") + "; class : " + entity.getClass().getName());
        PropertyEnumeration propertyEnumeration = entity.properties("$metaclass");
        while (propertyEnumeration.hasMoreElements()) {
            Diagnostic.print("\tMetaclass : " + propertyEnumeration.next().getValue());
        }
        XMIAbstractElement xMIAbstractElement = null;
        if ("Package".equals(string)) {
            xMIAbstractElement = new XMIPackage(xMLWriter, entity, xMIDiagram);
        } else if (string.endsWith("Diagram")) {
            xMIAbstractElement = DiagramFactory.createDiagram(xMLWriter, entity);
        } else if ("Class".equals(string) || "Actor".equals(string) || "Use Case".equals(string)) {
            xMIAbstractElement = new XMIClass(xMLWriter, entity, xMIDiagram);
        } else if ("Object".equals(string)) {
            xMIAbstractElement = new XMIClassifierRole(xMLWriter, entity, xMIDiagram);
            XMI11Export.addClassifierRole((XMIClassifierRole)xMIAbstractElement);
            bl = false;
        } else if ("Component".equals(string)) {
            xMIAbstractElement = new XMIComponent(xMLWriter, entity, xMIDiagram);
        } else if ("Subsystem".equals(string)) {
            xMIAbstractElement = new XMISubsystem(xMLWriter, entity, xMIDiagram);
        } else if ("Node".equals(string)) {
            xMIAbstractElement = new XMINode(xMLWriter, entity, xMIDiagram);
        } else if ("Swimlane".equals(string)) {
            xMIAbstractElement = new XMIPartition(xMLWriter, entity, xMIDiagram);
        } else if ("Note".equals(string)) {
            xMIAbstractElement = new XMIComment(xMLWriter, entity, xMIDiagram);
        } else if ("Activity".equals(string)) {
            xMIAbstractElement = new XMIActionState(xMLWriter, entity, xMIDiagram);
            XMI11Export.addState((XMIState)xMIAbstractElement);
            bl = false;
        } else if ("Signal Receipt".equals(string) || "Signal Sending".equals(string)) {
            if (!XMI11Export.isTCCSpecificExport()) {
                XMI11Export.addIncompatibleElement(entity, null);
            } else {
                xMIAbstractElement = new XMIActionState(xMLWriter, entity, xMIDiagram);
                XMI11Export.addState((XMIState)xMIAbstractElement);
                bl = false;
            }
        } else if ("State".equals(string) || "Start State".equals(string) || "End State".equals(string) || "Decision".equals(string) || "Synchronization Bar".equals(string)) {
            xMIAbstractElement = new XMIState(xMLWriter, entity, xMIDiagram);
            XMI11Export.addState((XMIState)xMIAbstractElement);
            bl = false;
        } else if ("Operation".equals(string)) {
            xMIAbstractElement = new XMIOperation(xMLWriter, entity);
        } else if ("Attribute".equals(string)) {
            xMIAbstractElement = new XMIAttribute(xMLWriter, entity);
        } else if ("Generalization Link".equals(string) || "Implementation Link".equals(string)) {
            xMIAbstractElement = new XMIGeneralization(xMLWriter, entity);
        } else if ("Transition".equals(string)) {
            xMIAbstractElement = new XMITransition(xMLWriter, entity, xMIDiagram);
        } else if ("Dependency Link".equals(string)) {
            xMIAbstractElement = new XMIDependency(xMLWriter, entity, xMIDiagram);
        } else if ("Association Link".equals(string) || "Includes Link".equals(string) || "Extends Link".equals(string)) {
            xMIAbstractElement = new XMIAssociation(xMLWriter, entity, xMIDiagram);
        } else if ("Extension Point".equals(string)) {
            xMIAbstractElement = new XMIExtensionPoint(xMLWriter, entity);
        } else if ("System Boundary".equals(string)) {
            xMIAbstractElement = new XMISystemBoundary(xMLWriter, entity, xMIDiagram);
        }
        if (xMIAbstractElement != null && bl) {
            xMIAbstractElement.writeXMI11Element();
        }
        return xMIAbstractElement;
    }
}

