/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.util;

import com.togethersoft.selena.xmi.elements.XMIDiagram;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.ElementCollector;
import com.togethersoft.selena.xmi.util.ElementWriter;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.model.elements.Entity;
import java.util.Vector;

public class ElementCollectorImpl
implements ElementCollector {
    protected Vector myElements = new Vector();
    protected boolean myUnique;
    protected XMIDiagram myDiagram;

    public ElementCollectorImpl(XMIDiagram xMIDiagram) {
        this.myDiagram = xMIDiagram;
        this.myUnique = false;
    }

    public ElementCollectorImpl(XMIDiagram xMIDiagram, boolean bl) {
        this.myDiagram = xMIDiagram;
        this.myUnique = bl;
    }

    public ElementCollectorImpl(boolean bl) {
        this.myUnique = bl;
    }

    public void addElement(Entity entity) {
        if (entity == null) {
            return;
        }
        if (this.myUnique && this.myElements.contains(entity)) {
            return;
        }
        this.myElements.add(entity);
    }

    public boolean getUnique() {
        return this.myUnique;
    }

    public void write(XMLWriter xMLWriter) throws Exception {
        int n = 0;
        while (n < this.myElements.size()) {
            Diagnostic.print("Collector, element " + n);
            ElementWriter.writeElement(xMLWriter, (Entity)this.myElements.elementAt(n), this.myDiagram);
            ++n;
        }
    }

    public boolean isEmpty() {
        return this.myElements.isEmpty();
    }

    public int getCount() {
        return this.myElements.size();
    }
}

