/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.util;

import com.togethersoft.selena.xmi.elements.XMIDiagram;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.XMI11Export;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.model.elements.Entity;

public class DiagramFactory {
    public static XMIDiagram createDiagram(XMLWriter xMLWriter, Entity entity) {
        if (entity == null) {
            return null;
        }
        String string = entity.getPropertyValue("$metaclass");
        XMIDiagram xMIDiagram = null;
        if ("Class Diagram".equals(string)) {
            Diagnostic.print("Writing class diagram");
            xMIDiagram = new XMIDiagram(xMLWriter, entity, "");
            xMIDiagram.setId(XMI11Export.getElementID(entity));
        }
        if ("Package Diagram".equals(string) && XMI11Export.isTCCSpecificExport()) {
            Diagnostic.print("Writing package diagram");
            xMIDiagram = new XMIDiagram(xMLWriter, entity, "");
            xMIDiagram.setId(XMI11Export.getElementID(entity));
        }
        if ("Use Case Diagram".equals(string)) {
            Diagnostic.print("Writing usecase diagram");
            xMIDiagram = new XMIDiagram(xMLWriter, entity, "");
        }
        if ("Collaboration Diagram".equals(string)) {
            Diagnostic.print("Writing collaboration diagram");
            xMIDiagram = new XMIDiagram(xMLWriter, entity, "CollaborationDiagram");
            Diagnostic.print("Writing collaboration diagram done");
        }
        if ("Sequence Diagram".equals(string)) {
            Diagnostic.print("Writing sequence diagram");
            xMIDiagram = new XMIDiagram(xMLWriter, entity, "SequenceDiagram");
            Diagnostic.print("Writing sequence diagram done");
        }
        if ("State Diagram".equals(string) || "Activity Diagram".equals(string)) {
            Diagnostic.print("Writing statechart or activity diagram");
            xMIDiagram = new XMIDiagram(xMLWriter, entity, "");
            Diagnostic.print("Writing statechart diagram done");
        }
        if ("Component Diagram".equals(string)) {
            Diagnostic.print("Writing Component diagram");
            xMIDiagram = new XMIDiagram(xMLWriter, entity, "ModuleDiagram");
            Diagnostic.print("Writing Component diagram done.");
        }
        if ("Deployment Diagram".equals(string)) {
            Diagnostic.print("Writing Deployment diagram");
            xMIDiagram = new XMIDiagram(xMLWriter, entity, "");
            Diagnostic.print("Writing Deployment diagram done.");
        }
        if (xMIDiagram != null) {
            Diagnostic.print("Diagram " + xMIDiagram.getClass().getName() + " created");
        } else {
            Diagnostic.print("Failed to create diagram");
        }
        return xMIDiagram;
    }
}

