/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.util;

import com.togethersoft.selena.xmi.util.XMI11Export;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.wizard.XMIPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.ModelUinSupport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class Diagnostic {
    private static final String developerFlagFile = "c:\\test\\yuretc.debug";
    private static final String timeFlagFile = "c:\\test\\yuretc.time";
    private static PrintStream ourOut;
    private static OutputStream ourStream;
    private static PrintStream ourTimeOut;
    private static OutputStream ourTimeStream;

    public static boolean isDeveloperEnvironment() {
        boolean bl = false;
        File file = new File(developerFlagFile);
        if (file != null && file.exists()) {
            bl = true;
        }
        return bl;
    }

    public static boolean isTimeCounting() {
        boolean bl = false;
        File file = new File(timeFlagFile);
        if (file != null && file.exists()) {
            bl = true;
        }
        return bl;
    }

    public static void init(OutputStream outputStream) {
        if (Diagnostic.isDeveloperEnvironment()) {
            try {
                ourStream = outputStream;
                ourOut = new PrintStream(ourStream);
            }
            catch (Exception exception) {
                ourOut = null;
            }
        } else {
            ourOut = null;
        }
        if (Diagnostic.isTimeCounting()) {
            try {
                ourTimeStream = new FileOutputStream(timeFlagFile, true);
                ourTimeOut = new PrintStream(ourTimeStream);
            }
            catch (Exception exception) {
                ourTimeOut = null;
            }
        } else {
            ourTimeOut = null;
        }
    }

    public static void print(String string) {
        if (ourOut != null) {
            ourOut.println(string);
        }
    }

    public static void printTimeLog(String string) {
        if (ourTimeOut != null) {
            ourTimeOut.println(string);
        }
    }

    public static void printError(Throwable throwable) {
        if (throwable instanceof XMIException) {
            Diagnostic.printError(throwable.getMessage(), null, null);
        } else {
            XMIPlugin.getInstance().logException(throwable);
        }
    }

    public static void printError(String string, UniqueName uniqueName, UniqueName uniqueName2) {
        String string2;
        IWorkspaceRoot iWorkspaceRoot;
        IProject iProject;
        Element element;
        Model model;
        if (string == null || string.length() == 0) {
            return;
        }
        IWorkspaceRoot iWorkspaceRoot2 = null;
        if (uniqueName != null && uniqueName2 != null && (model = ModelAccess.getModel((UniqueName)uniqueName)) != null && (element = model.findElement(uniqueName2)) != null && (iProject = (iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot()).getProject(ModelUinSupport.getProjectId((UniqueName)uniqueName))) != null && (string2 = element.getPropertyValue("$file")) != null && string2.length() != 0 && !(iWorkspaceRoot2 = iProject.getFile(string2)).exists() && !(iWorkspaceRoot2 = iProject.getFolder(string2)).exists()) {
            System.out.println("resource " + iWorkspaceRoot2.toString());
            iWorkspaceRoot2 = null;
        }
        if (iWorkspaceRoot2 == null) {
            iWorkspaceRoot2 = ResourcesPlugin.getWorkspace().getRoot();
        }
        try {
            model = iWorkspaceRoot2.createMarker("com.togethersoft.selena.xmi.exportErrorMarker");
            if (model.exists()) {
                model.setAttribute("message", (Object)string);
                if (uniqueName2 != null && uniqueName != null) {
                    model.setAttribute("uniqueName", (Object)uniqueName2.toString());
                    model.setAttribute("modelUin", (Object)uniqueName.toString());
                    XMI11Export.setWarningGenerated();
                }
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    public static void finish() {
        if (ourOut != null) {
            try {
                if (ourStream != null) {
                    ourStream.close();
                }
                ourOut = null;
            }
            catch (Exception exception) {
                ourOut = null;
            }
        }
        if (ourTimeOut != null) {
            try {
                if (ourTimeStream != null) {
                    ourTimeStream.close();
                }
                ourTimeOut = null;
            }
            catch (Exception exception) {
                ourTimeOut = null;
            }
        }
    }
}

