/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.handlers;

import com.togethersoft.selena.xmi.handlers.XMLParser$1;
import com.togethersoft.selena.xmi.handlers.XMLParserError;
import com.togethersoft.selena.xmi.handlers.XMLParserErrorHandler;
import com.togethersoft.selena.xmi.handlers.XMLParserHandler;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.InfiniteProgressMonitorHelper;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.util.XMIInterchangeMessages;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser
extends DefaultHandler {
    public static final int OK = 0;
    public static final int ERROR = 1;
    public static final int IOEXCEPTION = 2;
    private static StringBuffer ourStubBuffer = new StringBuffer();
    private static XMLParserHandler ourStubHandler = new XMLParser$1();
    private XMLReader myParser;
    private XMLParserHandler myHandler;
    private Stack myHandlerStack;
    private Stack myBufferStack;
    private XMLParserErrorHandler myErrorHandler;
    private String myErrorMessage;
    private StringBuffer myBuffer;
    private IOException myIOException;
    private boolean myTrim;

    public XMLParser() {
        this.setTrim(true);
    }

    public int parse(InputStream inputStream, XMLParserHandler xMLParserHandler) throws InterruptedException {
        int n = 0;
        try {
            this.myErrorMessage = null;
            this.myIOException = null;
            this.myHandler = xMLParserHandler;
            if (this.myHandler != null) {
                this.myHandlerStack = new Stack();
                this.myBufferStack = new Stack();
                this.myBuffer = ourStubBuffer;
                this.myParser = new SAXParser();
                this.myParser.setContentHandler(this);
                this.myParser.setErrorHandler(this);
                this.myParser.parse(new InputSource(inputStream));
            }
        }
        catch (SAXException sAXException) {
            this.myErrorMessage = sAXException.getLocalizedMessage();
            if ("canceled".equals(this.myErrorMessage)) {
                throw new InterruptedException();
            }
            Diagnostic.printError(new XMIException("SAXException", this.myErrorMessage));
            throw new InterruptedException(XMIInterchangeMessages.getString("CancelMessage"));
        }
        catch (IOException iOException) {
            this.myIOException = iOException;
            this.myErrorMessage = this.myIOException.getMessage();
            n = 2;
        }
        if (this.myHandlerStack != null) {
            this.myHandlerStack.clear();
        }
        if (this.myBufferStack != null) {
            this.myBufferStack.clear();
        }
        this.myHandlerStack = null;
        this.myBufferStack = null;
        this.myBuffer = null;
        this.myParser = null;
        return n;
    }

    public void setTrim(boolean bl) {
        this.myTrim = bl;
    }

    public String getErrorMessage() {
        return this.myErrorMessage;
    }

    public IOException getIOException() {
        return this.myIOException;
    }

    public void setErrorHandler(XMLParserErrorHandler xMLParserErrorHandler) {
        this.myErrorHandler = xMLParserErrorHandler;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (XMI11Import.getProgressMonitor().isCanceled()) {
            throw new SAXException("canceled");
        }
        int n = InfiniteProgressMonitorHelper.getCurrentIteration();
        if (n / 10 * 10 == n) {
            XMI11Import.getProgressMonitor().worked(InfiniteProgressMonitorHelper.getNextOffset(n - 10));
        } else {
            InfiniteProgressMonitorHelper.increaseCurrentIteration();
        }
        Diagnostic.print("Processing element " + string3);
        if (!this.isValidBuffer()) {
            this.myBuffer = ourStubBuffer;
        }
        this.myBufferStack.push(this.myBuffer);
        this.myBuffer = ourStubBuffer;
        this.myHandlerStack.push(this.myHandler);
        this.myHandler = this.myHandler.startElement(string, string2, string3);
        if (this.myHandler == null) {
            this.myHandler = ourStubHandler;
        }
        if (this.myHandler != ourStubHandler) {
            int n2 = attributes.getLength();
            StringBuffer stringBuffer = new StringBuffer("\tAttributes : ");
            int n3 = 0;
            while (n3 < n2) {
                stringBuffer.append(attributes.getLocalName(n3) + " = '" + attributes.getValue(n3) + "' ");
                ++n3;
            }
            Diagnostic.print(stringBuffer.toString());
            int n4 = 0;
            while (n4 < n2) {
                this.myHandler.setAttribute(attributes.getURI(n4), attributes.getLocalName(n4), attributes.getValue(n4));
                ++n4;
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.myBuffer == ourStubBuffer) {
            this.myBuffer = new StringBuffer();
        }
        this.myBuffer.append(cArray, n, n2);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.myBuffer != ourStubBuffer) {
            if (this.myTrim) {
                char c;
                int n = 0;
                int n2 = this.myBuffer.length() - 1;
                while (n <= n2) {
                    c = this.myBuffer.charAt(n);
                    if (c != '\n' && c != '\r' && c != ' ') break;
                    ++n;
                }
                while (n2 > n) {
                    c = this.myBuffer.charAt(n2);
                    if (c != '\n' && c != '\r' && c != ' ') break;
                    --n2;
                }
                if (n < n2) {
                    this.myHandler.setValue(this.myBuffer.substring(n, n2 + 1));
                }
            } else {
                this.myHandler.setValue(this.myBuffer.toString());
            }
        }
        this.myHandler = this.myHandlerStack.empty() ? ourStubHandler : (XMLParserHandler)this.myHandlerStack.pop();
        this.myBuffer = this.myBufferStack.empty() ? ourStubBuffer : (StringBuffer)this.myBufferStack.pop();
        this.myHandler.endElement(string, string2, string3);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.checkError(1, sAXParseException);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.checkError(2, sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.checkError(3, sAXParseException);
    }

    /*
     * Unable to fully structure code
     */
    public void collapseParsing() throws Exception {
        Diagnostic.print("Collapsing parsing");
        if (this.myHandlerStack != null) ** GOTO lbl6
        return;
lbl-1000:
        // 1 sources

        {
            var1_1 = this.myHandlerStack.pop();
            var1_1 = null;
lbl6:
            // 2 sources

            ** while (!this.myHandlerStack.empty())
        }
lbl7:
        // 1 sources

        this.myHandlerStack = null;
        this.myBufferStack = null;
        this.myBuffer = null;
        this.myParser = null;
        Diagnostic.print("Collapsing parsing done");
    }

    private boolean isValidBuffer() {
        if (this.myTrim) {
            int n = this.myBuffer.length();
            int n2 = 0;
            while (n2 < n) {
                char c = this.myBuffer.charAt(n2);
                if (c != '\n' && c != '\r' && c != ' ') {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void checkError(int n, SAXParseException sAXParseException) throws SAXException {
        if (this.myErrorHandler != null && this.myErrorHandler.isCritical(new XMLParserError(n, sAXParseException.getMessage(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber()))) {
            throw sAXParseException;
        }
    }
}

