/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.handlers;

import com.togethersoft.selena.xmi.elements.XMIAbstractElement;
import com.togethersoft.selena.xmi.elements.XMIElement;
import com.togethersoft.selena.xmi.handlers.XMIErrorHandler;
import com.togethersoft.selena.xmi.handlers.XMLParserErrorHandler;
import com.togethersoft.selena.xmi.handlers.XMLParserHandler;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIException;
import com.tssap.selena.model.elements.Entity;

public class XMIHandler
implements XMLParserHandler {
    protected Entity myRwiElement;
    protected XMIElement myXMIElement;
    protected XMIErrorHandler myErrorHandler;
    protected String myNamespaceUml;
    protected String myCurrentElement;

    public XMIHandler() {
        this.myRwiElement = null;
        this.myNamespaceUml = XMI11Import.getUMLNamespace();
    }

    public XMIHandler(Entity entity) {
        this.myRwiElement = entity;
        this.myNamespaceUml = XMI11Import.getUMLNamespace();
    }

    public XMLParserHandler startElement(String string, String string2, String string3) {
        this.myCurrentElement = string2;
        return this;
    }

    public void endElement(String string, String string2, String string3) {
    }

    public void setValue(String string) {
        if (string != null) {
            string = string.trim();
        }
        if (this.myXMIElement != null) {
            this.myXMIElement.setValue(string);
        }
    }

    public void setAttribute(String string, String string2, String string3) {
        try {
            if (this.myXMIElement != null) {
                Entity entity = this.myRwiElement;
                Entity entity2 = this.myXMIElement.setProperty(string2, string3);
                if (entity2 != null) {
                    this.myRwiElement = entity2;
                }
            } else if (this.myRwiElement != null) {
                XMIAbstractElement.setParentProperty(this.myRwiElement, string2, string3);
            }
        }
        catch (XMIException xMIException) {
            Diagnostic.printError(xMIException);
            this.error(xMIException);
        }
        catch (Exception exception) {
            Diagnostic.printError(exception);
        }
    }

    public void setErrorHandler(XMIErrorHandler xMIErrorHandler) {
        this.myErrorHandler = xMIErrorHandler;
    }

    public XMLParserErrorHandler getErrorHandler() {
        return this.myErrorHandler;
    }

    public void error(XMIException xMIException) {
        if (this.myErrorHandler != null) {
            this.myErrorHandler.error(xMIException);
        } else {
            Diagnostic.print("Cannot show Error message: myErrorHandler null");
        }
    }

    public void warning(XMIException xMIException) {
        if (this.myErrorHandler != null) {
            this.myErrorHandler.warning(xMIException);
        }
    }

    public XMIElement getXMIElement() {
        return this.myXMIElement;
    }
}

