/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.elements;

import com.togethersoft.selena.xmi.elements.XMIAction;
import com.togethersoft.selena.xmi.elements.XMIActionSequence;
import com.togethersoft.selena.xmi.elements.XMIDiagram;
import com.togethersoft.selena.xmi.elements.XMIElement;
import com.togethersoft.selena.xmi.elements.XMIElementImpl;
import com.togethersoft.selena.xmi.elements.XMIEvent;
import com.togethersoft.selena.xmi.elements.XMIGuard;
import com.togethersoft.selena.xmi.elements.XMISendAction;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.XMI11Export;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.enum.ElementEnumeration;
import java.util.Vector;

public class XMITransition
extends XMIElementImpl {
    public static final String TRANSITION = "Transition";
    public static final String OBJECTFLOW = "ObjectFlow";
    public static final String TRANSITION_SOURCE = "Transition.source";
    public static final String TRANSITION_TARGET = "Transition.target";
    public static final String TRANSITION_TRIGGER = "Transition.trigger";
    public static final String TRANSITION_GUARD = "Transition.guard";
    public static final String TRANSITION_EFFECT = "Transition.effect";
    public static final int ROLE_SOURCE = 1;
    public static final int ROLE_TARGET = 2;
    public static final int ROLE_TRIGGER = 3;
    private String mySourceID;
    private String myTargetID;
    private String myTriggerID;
    private String myLabel;
    private XMIGuard myXMIGuard;
    private Vector myActions;
    private XMIActionSequence myXMIActionSequence;
    private String myTransitionType;
    private Entity myTransitionParent;
    private String mySendClause;

    public XMITransition(Entity entity, String string) {
        this.myLabel = null;
        this.myVisibility = null;
        this.mySendClause = null;
        this.myTransitionType = string;
        this.myTransitionParent = TRANSITION.equals(this.myTransitionType) || "Object Flow".equals(this.myTransitionType) ? null : entity;
    }

    public XMITransition(XMLWriter xMLWriter, Entity entity, XMIDiagram xMIDiagram) {
        super(xMLWriter, entity, xMIDiagram);
        Object object;
        String string;
        this.myName = TRANSITION;
        String string2 = entity.getPropertyValue("$metaclass");
        if ("Object Flow".equals(string2)) {
            this.myName = OBJECTFLOW;
        }
        this.myID = XMI11Export.getModelID(this.myElement);
        this.myXMIActionSequence = new XMIActionSequence(xMLWriter);
        String string3 = this.myElement.getPropertyValue("$guard_condition");
        if (string3 != null && string3.length() != 0) {
            this.myXMIGuard = new XMIGuard(xMLWriter, string3);
        }
        if ((string = this.myElement.getPropertyValue("$action_expression")) != null && string.length() != 0) {
            object = new XMIAction(this.myWriter, "UninterpretedAction");
            ((XMIAction)object).setName(string);
            this.myXMIActionSequence.addAction((XMIAction)object);
        }
        if ((object = this.myElement.getPropertyValue("$send_clause")) != null && ((String)object).length() != 0) {
            XMISendAction xMISendAction = new XMISendAction(this.myWriter, (String)object);
            xMISendAction.setTarget((String)object);
            this.myXMIActionSequence.addAction(xMISendAction);
        }
        this.writeTaggedValues();
    }

    public void writeXMI11Element() throws Exception {
        super.writeXMI11Element();
        if (!(this.myElement instanceof Entity)) {
            return;
        }
        if (XMI11Export.isExported(this.myElement)) {
            return;
        }
        XMI11Export.addExportedElement(this.myElement, this.myID);
        Entity entity = this.myElement;
        String string = this.myElement.getPropertyValue("$name");
        Diagnostic.print("Writing out " + this.myName + ", name = " + string + ", id = " + this.myID);
        ElementEnumeration elementEnumeration = entity.participants("Client");
        ElementEnumeration elementEnumeration2 = entity.participants("Supplier");
        this.mySourceID = XMI11Export.getModelID(elementEnumeration.hasMoreElements() ? elementEnumeration.next() : null);
        this.myTargetID = XMI11Export.getModelID(elementEnumeration2.hasMoreElements() ? elementEnumeration2.next() : null);
        this.writeElementComments(elementEnumeration.hasMoreElements() ? (Entity)elementEnumeration.next() : null, elementEnumeration2.hasMoreElements() ? (Entity)elementEnumeration2.next() : null);
        this.myWriter.writeStartTag("UML", this.myName);
        this.myWriter.writeAttribute("xmi.id", this.myID);
        this.myWriter.writeAttribute("name", string, true);
        this.myWriter.writeAttribute("visibility", this.visibilityValue());
        this.myWriter.writeAttribute("isSpecification", this.isSpecificationValue());
        if (!XMI11Export.isUnisysExport()) {
            this.myWriter.writeAttribute("source", this.mySourceID);
            this.myWriter.writeAttribute("target", this.myTargetID);
        }
        this.writeStereotype();
        this.myWriter.writeCloseBrasket();
        Diagnostic.print(this.myName + " CLASS = " + this.myElement.getClass().getName());
        Diagnostic.print("Writing out " + this.myName + " source and target");
        String string2 = this.myElement.getPropertyValue("$event_name");
        String string3 = this.myElement.getPropertyValue("$event_arguments");
        if (string2 == null || string2.length() == 0) {
            string2 = "";
        }
        XMIEvent xMIEvent = new XMIEvent(this.myWriter, "SignalEvent", string2, string3);
        this.myWriter.writeStartTag("UML", TRANSITION_TRIGGER, true);
        if (XMI11Export.isUnisysExport()) {
            this.myWriter.writeStartTag("Behavioral_Elements.State_Machines.Event");
            this.myWriter.writeAttribute("xmi.idref", XMI11Export.getModelID(xMIEvent));
            this.myWriter.writeCloseBrasket(true);
        } else {
            this.myWriter.writeStartTag("UML", "Event");
            this.myWriter.writeAttribute("xmi.idref", XMI11Export.getModelID(xMIEvent));
            this.myWriter.writeCloseBrasket(true);
        }
        this.myWriter.writeEndTag("UML", TRANSITION_TRIGGER);
        if (XMI11Export.isUnisysExport()) {
            this.myWriter.writeStartTag("UML", TRANSITION_SOURCE, true);
            this.myWriter.writeStartTag("Behavioral_Elements.State_Machines.StateVertex");
            this.myWriter.writeAttribute("xmi.idref", this.mySourceID);
            this.myWriter.writeCloseBrasket(true);
            this.myWriter.writeEndTag("UML", TRANSITION_SOURCE);
            this.myWriter.writeStartTag("UML", TRANSITION_TARGET, true);
            this.myWriter.writeStartTag("Behavioral_Elements.State_Machines.StateVertex");
            this.myWriter.writeAttribute("xmi.idref", this.myTargetID);
            this.myWriter.writeCloseBrasket(true);
            this.myWriter.writeEndTag("UML", TRANSITION_TARGET);
        }
        if (this.myXMIGuard != null) {
            this.myWriter.writeStartTag("UML", TRANSITION_GUARD, true);
            this.myXMIGuard.writeXMI11Element();
            this.myWriter.writeEndTag("UML", TRANSITION_GUARD);
        }
        if (this.myXMIActionSequence != null) {
            this.myWriter.writeStartTag("UML", TRANSITION_EFFECT, true);
            this.myXMIActionSequence.writeXMI11Element();
            this.myWriter.writeEndTag("UML", TRANSITION_EFFECT);
        }
        this.myWriter.writeEndTag("UML", this.myName);
    }

    public void setReference(int n, String string) throws XMIException {
        Diagnostic.print("Setting reference " + string + " role = " + n);
        if (string == null || string.length() == 0) {
            return;
        }
        if (n == 1) {
            this.mySourceID = string;
        } else if (n == 2) {
            this.myTargetID = string;
        } else if (n == 3) {
            this.myTriggerID = string;
        } else {
            throw new XMIException("xmi.import.error.unknown.in", "UML:Transition");
        }
    }

    public Entity createRwiElement() throws XMIException {
        Object object;
        Object object2;
        String string;
        Object object3;
        if (this.myID == null) {
            this.myID = "";
        }
        if (this.myTransitionParent != null) {
            if (!this.myTransitionParent.canCreateChildEntity(this.myTransitionType, null)) {
                throw new XMIException("xmi.import.error.cannot.create", "internal transition or deferred event");
            }
            this.myElement = this.myTransitionParent.createChildEntity(this.myTransitionType, null);
            if (this.myElement == null) {
                throw new XMIException("xmi.import.error.cannot.create.link2", new String[]{this.myTransitionType, this.myID, "", "", "", ""});
            }
        } else {
            object3 = XMI11Import.getElement(this.mySourceID);
            if (object3 == null) {
                throw new XMIException("xmi.import.error.cannot.find.transition.source", this.mySourceID, this.myLabel);
            }
            string = object3.getPropertyValue("$name");
            object2 = object3.getPropertyValue("$metaclass");
            Diagnostic.print("Transition source " + this.mySourceID + " " + object3.getPropertyValue("$metaclass") + " " + object3.getPropertyValue("$name"));
            object = XMI11Import.getElement(this.myTargetID);
            if (object == null) {
                throw new XMIException("xmi.import.error.cannot.find.transition.target", this.myTargetID, this.myLabel);
            }
            String string2 = object.getPropertyValue("$name");
            String string3 = object.getPropertyValue("$metaclass");
            Diagnostic.print("Transition target " + this.myTargetID + " " + object.getPropertyValue("$metaclass") + " " + object.getPropertyValue("$name"));
            if (!object3.canCreateChildEntity(this.myTransitionType, null)) {
                throw new XMIException("xmi.import.error.cannot.create.link2", new String[]{TRANSITION, this.myID, object2, string, string3, string2});
            }
            this.myElement = object3.createChildEntity(this.myTransitionType, null);
            this.myElement.setParticipant("Supplier", null, (Element)object);
            if (this.myElement == null) {
                throw new XMIException("xmi.import.error.cannot.create.link2", new String[]{TRANSITION, this.myID, object2, string, string3, string2});
            }
        }
        if (this.myLabel != null) {
            this.myElement.setPropertyValue("$name", this.myLabel);
        }
        if ((object3 = XMI11Import.getEvent(this.myTriggerID)) != null) {
            string = ((XMIEvent)object3).getName();
            if (this.myElement.canSetPropertyValue("$event_name", string)) {
                this.myElement.setPropertyValue("$event_name", string);
            } else {
                Diagnostic.print("Event Name canot be Set");
            }
            object2 = ((XMIEvent)object3).getArgument();
            Diagnostic.print("Event arg = " + (String)object2);
            if (this.myElement.canSetPropertyValue("$event_arguments", (String)object2)) {
                this.myElement.setPropertyValue("$event_arguments", (String)object2);
            } else {
                Diagnostic.print("Event Arguments canot be Set");
            }
        } else {
            Diagnostic.print("Event Null");
        }
        if (this.myXMIGuard != null) {
            Diagnostic.print("Guard not null");
            string = this.myXMIGuard.getCondition();
            Diagnostic.print("Guard Condition = " + string);
            if (this.myElement.canSetPropertyValue("$guard_condition", string)) {
                this.myElement.setPropertyValue("$guard_condition", string);
            }
        } else {
            Diagnostic.print("Guard Null");
        }
        if (this.myActions != null) {
            int n = 0;
            while (n < this.myActions.size()) {
                object2 = (XMIElement)this.myActions.get(n);
                if (object2 instanceof XMISendAction) {
                    object = ((XMISendAction)object2).getTarget();
                    if (this.myElement.canSetPropertyValue("$send_clause", (String)object)) {
                        this.myElement.setPropertyValue("$send_clause", (String)object);
                    }
                } else if (object2 instanceof XMIAction && this.myElement.canSetPropertyValue("$action_expression", (String)(object = ((XMIAction)object2).getName()))) {
                    this.myElement.setPropertyValue("$action_expression", (String)object);
                }
                ++n;
            }
        }
        if (this.mySendClause != null && this.myElement.canSetPropertyValue("$send_clause", this.mySendClause)) {
            this.myElement.setPropertyValue("$send_clause", this.mySendClause);
            Diagnostic.print("SEND CLAUSE from TCC");
        }
        if (this.myElement != null) {
            Diagnostic.print(this.myElement.getPropertyValue("$metaclass") + " '" + this.myElement.getPropertyValue("$name") + "' created successfully");
        } else {
            Diagnostic.print("Failed to create RwiElement");
        }
        return this.myElement;
    }

    public Entity setProperty(String string, String string2) throws XMIException {
        if (string == null || string.length() == 0 || string2 == null) {
            throw new XMIException("xmi.import.error.cannot.set.property", string);
        }
        if ("xmi.id".equals(string)) {
            if (string2.length() == 0) {
                return this.myElement;
            }
            this.myID = string2;
            XMI11Import.addTransition(this.myID, this);
        }
        if ("name".equals(string)) {
            this.myLabel = string2;
        } else if ("visibility".equals(string)) {
            this.myVisibility = string2;
        } else if ("source".equals(string)) {
            this.mySourceID = string2;
        } else if ("target".equals(string)) {
            this.myTargetID = string2;
        }
        return this.myElement;
    }

    public void setGuard(XMIGuard xMIGuard) {
        Diagnostic.print("Transition: Setting guard");
        if (xMIGuard != null) {
            Diagnostic.print("Guard not null");
        } else {
            Diagnostic.print("Guard null");
        }
        this.myXMIGuard = xMIGuard;
    }

    public void setSendClause(String string) {
        this.mySendClause = string;
    }

    public void addAction(XMIElement xMIElement) {
        if (this.myActions == null) {
            this.myActions = new Vector();
        }
        this.myActions.add(xMIElement);
    }

    public Entity getTransitionParent() {
        return this.myTransitionParent;
    }

    public void setTransitionParent(Entity entity) {
        this.myTransitionParent = entity;
    }
}

