/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.elements;

import com.togethersoft.selena.xmi.elements.XMIAbstractElement;
import com.togethersoft.selena.xmi.elements.XMIElementImpl;
import com.togethersoft.selena.xmi.elements.XMIMessage;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.FilterRegistryReader;
import com.togethersoft.selena.xmi.util.IFilterDescriptor;
import com.togethersoft.selena.xmi.util.IMapDescriptor;
import com.togethersoft.selena.xmi.util.MapsRegistryReader;
import com.togethersoft.selena.xmi.util.TextUtil;
import com.togethersoft.selena.xmi.util.XMI11Export;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.impl.model.elements.EntityTemplateImpl;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.enum.ElementEnumeration;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;

public class XMITaggedValue
extends XMIAbstractElement {
    public static final String TAGGEDVALUE = "TaggedValue";
    public static final String TAGGEDVALUE_MODELELEMENT = "TaggedValue.modelElement";
    public static final String TAGGEDVALUE_DATAVALUE = "TaggedValue.dataValue";
    public static final String TAGGEDVALUE_VALUE = "TaggedValue.value";
    private static List modelProperties = Arrays.asList("$synchronized", "$persistence", "$volatile", "$native", "$throws", "$comment", "@preconditions", "@postconditions", "@alias", "namespace", "@invariants", "@input", "@output", "@time", "@author", "@number", "$description", "@document", "@priority", "@difficulty", "@testcase", "@type", "$constraint", "$send_time", "$receive_time", "$condition", "@url", "$alternate_flow", "$explanation", "$normal_flow", "@postconditions", "@preconditions", "$rank", "normalizedIndex", "@clientRole", "@label", "@supplierRole", "arguments", "condition", "iteration", "return", "destruction", "creation", "return", "branchingAnchorUid", "@deprecated", "@see", "@since", "@version", "@persistent", "@associates", "sendingInstant", "processingDuration", "minProcessingDuration", "deliveryTime", "$state", "$multiple_instance", "$concurrent", "$active", "@clientQualifier", "@supplierQualifier", "@associationAsClass", "@labelDirection", "@clientCardinality", "@supplierCardinality", "text_only");
    private static List xmiTags = Arrays.asList("synchronized", "persistence", "volatile", "native", "throws", "documentation", "RationalRose:Preconditions", "RationalRose:Postconditions", "alias", "namespace", "invariants", "input", "output", "time", "author", "number", "description", "document", "priority", "difficulty", "testcase", "type", "constraint", "sendTime", "receiveTime", "linkcondition", "hyperlink", "alternateflow", "explanation", "normalflow", "postcondition", "precondition", "rank", "normalizedIndex", "clientRole", "label", "supplierRole", "arguments", "condition", "iteration", "return", "destructionMessage", "creationMessage", "return", "branchingAnchorUid", "deprecated", "see", "since", "version", "persistent", "associates", "sendingInstant", "processingDuration", "minProcessingDuration", "transmissionDuration", "state", "multipleInstance", "concurrent", "active", "clientQualifier", "supplierQualifier", "associationAsClass", "labelDirection", "clientCardinality", "supplierCardinality", "textOnly");
    private static Hashtable myPropertyToTag;
    private static Hashtable myTagToProperty;
    private static Hashtable myTWSEToRational;
    private static Hashtable myRationalToTWSE;
    private static HashSet myTagsFilter;
    private String myTag;
    private String myValue;
    private String myReferencedElementID;
    private boolean myReferenceAllowed;

    public XMITaggedValue() {
        this.myReferenceAllowed = false;
    }

    public XMITaggedValue(XMLWriter xMLWriter, String string, String string2, String string3) {
        super(xMLWriter);
        this.myID = XMI11Export.getDiagramElementID(this);
        this.myReferencedElementID = string;
        this.myTag = (String)myPropertyToTag.get(string2);
        if (this.myTag == null) {
            this.myTag = string2;
        }
        this.myValue = string3;
    }

    public void writeXMI11Element() throws Exception {
        this.myWriter.writeStartTag("UML", TAGGEDVALUE);
        this.myWriter.writeAttribute("xmi.id", this.myID);
        if (XMI11Export.isUnisysExport()) {
            this.myWriter.writeAttribute("tag", this.myTag, true);
            this.myWriter.writeAttribute("value", this.myValue);
        } else {
            this.myWriter.writeAttribute("name", this.myTag, true);
            this.myWriter.writeAttribute("modelElement", this.myReferencedElementID, true);
        }
        this.myWriter.writeCloseBrasket();
        if (XMI11Export.isUnisysExport()) {
            this.myWriter.writeStartTag("UML", TAGGEDVALUE_MODELELEMENT, true);
            this.myWriter.writeStartTag("Foundation.Core.ModelElement");
            this.myWriter.writeAttribute("xmi.idref", this.myReferencedElementID);
            this.myWriter.writeCloseBrasket(true);
            this.myWriter.writeEndTag("UML", TAGGEDVALUE_MODELELEMENT);
        } else {
            this.myWriter.writeStartTag("UML", TAGGEDVALUE_DATAVALUE, true);
            this.myWriter.writeCDATA(this.myValue);
            this.myWriter.writeEndTag("UML", TAGGEDVALUE_DATAVALUE);
        }
        this.myWriter.writeEndTag("UML", TAGGEDVALUE);
    }

    public Entity setProperty(String string, String string2) throws XMIException {
        Diagnostic.print("XMITaggedValue, setting Attribute " + string + " = '" + string2 + "'");
        if (string == null || string.length() == 0 || string2 == null) {
            throw new XMIException("xmi.import.error.cannot.set.property", string);
        }
        if ("xmi.id".equals(string) && string2.length() != 0) {
            this.myID = string2;
            Diagnostic.print("Adding tagget Value " + this.myID);
            XMI11Import.addTaggedValue(this.myID, this);
        }
        if ("tag".equals(string) || "name".equals(string)) {
            this.myTag = string2;
        } else if ("value".equals(string)) {
            this.myValue = string2;
        } else if ("modelElement".equals(string)) {
            this.myReferencedElementID = string2;
        }
        return null;
    }

    public void setReference(String string) {
        if (this.myReferenceAllowed) {
            this.myReferencedElementID = string;
        }
    }

    public String getReference() {
        return this.myReferencedElementID;
    }

    public void allowReference(boolean bl) {
        this.myReferenceAllowed = bl;
    }

    public void setTag(String string) {
        this.myTag = string;
    }

    public String getTag() {
        return this.myTag;
    }

    public void setValue(String string) {
        this.myValue = string;
    }

    private String tagToProperty() {
        String string = (String)myTagToProperty.get(this.myTag);
        if (string == null) {
            String string2 = (String)myRationalToTWSE.get(this.myTag);
            if (string2 != null) {
                string = string2;
            } else {
                string = this.myTag.replace(' ', '_');
                string = string.replace('$', '_');
            }
            if (!XMIElementImpl.knownProperties().contains(string)) {
                string = '@' + string;
            }
        }
        Diagnostic.print("    new name: " + string);
        return string;
    }

    private boolean isSyncBarOrientation(Element element, String string) {
        if ("vertical".equals(string)) {
            element.setPropertyValue("$orientation", "vertical");
            return true;
        }
        return false;
    }

    private boolean isBranchingMessage(Element element, String string) {
        if ("branchingAnchorUid".equals(string)) {
            String string2;
            Entity entity;
            Entity entity2;
            XMIMessage xMIMessage = XMI11Import.getMessage(this.myValue);
            if (xMIMessage != null && (entity2 = XMI11Import.realEntity(xMIMessage.getRwiElement())) != null && !(entity2 instanceof EntityTemplateImpl) && (entity = (Entity)element.getModel().findElement(entity2.getUniqueName())) != null && element.canSetPropertyValue("branchingAnchorUid", string2 = entity.getUniqueName().toString())) {
                element.setPropertyValue("branchingAnchorUid", string2);
            }
            return true;
        }
        return false;
    }

    private boolean isReturnLink(Element element, String string) {
        if ("showReturnArrow".equals(string)) {
            Entity entity;
            String string2 = element.getPropertyValue("activationUid");
            if (string2 != null && (entity = (Entity)element.getModel().findElement(ModelAccess.createUniqueName((String)string2))) != null) {
                if (entity.canCreateChildEntity("Return Link", null)) {
                    Entity entity2 = entity.createChildEntity("Return Link", null);
                    if (entity2 != null) {
                        ElementEnumeration elementEnumeration = ((Entity)element).participants("Supplier");
                        if (elementEnumeration.hasMoreElements()) {
                            Entity entity3 = (Entity)elementEnumeration.next();
                            entity2.setParticipant("Supplier", null, (Element)entity3);
                            Diagnostic.print("Return link created");
                            this.myValue = "1.0";
                            if (entity2.canSetPropertyValue("normalizedIndex", this.myValue)) {
                                entity2.setPropertyValue("normalizedIndex", this.myValue);
                            } else {
                                Diagnostic.print("Can't set index to return link **");
                            }
                        }
                    } else {
                        Diagnostic.print("Can't create return link **");
                    }
                } else {
                    Diagnostic.print("Can't create return link *");
                }
            }
            return true;
        }
        return false;
    }

    private boolean isDeliveryTime(Element element, String string) {
        if ("deliveryTime".equals(string)) {
            if (element instanceof Reference) {
                Entity entity;
                Reference reference = (Reference)element;
                if (reference.canSetPropertyValue("deliveryTime", this.myValue)) {
                    reference.setPropertyValue("deliveryTime", this.myValue);
                }
                if ((entity = reference.getEntity()).canSetPropertyValue("hasDeliveryTime", Boolean.TRUE.toString())) {
                    entity.setPropertyValue("hasDeliveryTime", Boolean.TRUE.toString());
                }
            }
            return true;
        }
        return false;
    }

    private boolean isComponentNodeType(Element element, String string) {
        if ("component_type".equals(string) || "node_type".equals(string)) {
            if (element.canSetPropertyValue("$type", this.myValue)) {
                element.setPropertyValue("$type", this.myValue);
            }
            return true;
        }
        return false;
    }

    private boolean isInstanceForm(Element element, String string) {
        return "instanceForm".equals(string);
    }

    private boolean isTextOnly(Element element, String string) {
        if ("text_only".equals(string)) {
            if (element.canSetPropertyValue("text_only", "true")) {
                element.setPropertyValue("text_only", "true");
            }
            return true;
        }
        return false;
    }

    public void setTaggedValue(Element element) throws XMIException {
        Diagnostic.print("Setting tagged value " + this.myTag + " = " + this.myValue + " for " + element);
        if (element == null) {
            return;
        }
        String string = this.tagToProperty();
        if (string == null) {
            return;
        }
        if (this.isSyncBarOrientation(element, string)) {
            return;
        }
        if (this.isBranchingMessage(element, string)) {
            return;
        }
        if (this.isReturnLink(element, string)) {
            return;
        }
        if (this.isDeliveryTime(element, string)) {
            return;
        }
        if (this.isComponentNodeType(element, string)) {
            return;
        }
        if (this.isInstanceForm(element, string)) {
            return;
        }
        if (this.isTextOnly(element, string)) {
            return;
        }
        if (element.hasProperty(string) && string != "@author") {
            if (!element.hasPropertyValue(string, this.myValue)) {
                if (element.canAddProperty(string, this.myValue)) {
                    element.addProperty(string, this.myValue);
                } else {
                    Diagnostic.print("can not add property");
                }
            }
        } else if (element.canSetPropertyValue(string, this.myValue)) {
            element.setPropertyValue(string, this.myValue);
        } else {
            if (this.myTag.lastIndexOf(":") > -1) {
                int n = this.myTag.lastIndexOf(":");
                string = this.myTag.substring(n);
            }
            string = TextUtil.replace(string, " ", "_");
            if (element.canSetPropertyValue(string = TextUtil.replace(string, ".", "_"), this.myValue)) {
                element.setPropertyValue(string, this.myValue);
            }
            throw new XMIException("xmi.import.error.cannot.set.taggedvalue", this.myTag, this.myValue);
        }
    }

    private static void initFilterTable() {
        myTagsFilter = new HashSet();
        IFilterDescriptor iFilterDescriptor = FilterRegistryReader.getInstance().getList("rationalFilter");
        if (iFilterDescriptor != null) {
            List list = iFilterDescriptor.getList();
            int n = 0;
            while (n < list.size()) {
                String string = (String)list.get(n);
                myTagsFilter.add(string);
                ++n;
            }
        }
    }

    private static void initMapTables() {
        myTWSEToRational = new Hashtable();
        myRationalToTWSE = new Hashtable();
        IMapDescriptor iMapDescriptor = MapsRegistryReader.getInstance().getMap("rationalMap");
        if (iMapDescriptor != null) {
            Hashtable hashtable = iMapDescriptor.getMap();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable.get(string);
                myTWSEToRational.put(string, string2);
                myRationalToTWSE.put(string2, string);
            }
        }
    }

    public static void initTables() throws XMIException {
        int n = modelProperties.size();
        if (n != xmiTags.size()) {
            throw new XMIException("xmi.error.arrays");
        }
        myPropertyToTag = new Hashtable();
        myTagToProperty = new Hashtable();
        int n2 = 0;
        while (n2 < n) {
            myPropertyToTag.put(modelProperties.get(n2), xmiTags.get(n2));
            myTagToProperty.put(xmiTags.get(n2), modelProperties.get(n2));
            ++n2;
        }
        XMITaggedValue.initMapTables();
        XMITaggedValue.initFilterTable();
    }

    public static String mapFromTWSEToRose(String string) {
        String string2 = (String)myTWSEToRational.get(string);
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public static boolean isTagFiltered(String string) {
        boolean bl = false;
        if (string != null) {
            bl = myTagsFilter.contains(string);
        }
        return bl;
    }
}

