/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.elements;

import com.togethersoft.selena.xmi.elements.XMIAbstractElement;
import com.togethersoft.selena.xmi.elements.XMIDiagram;
import com.togethersoft.selena.xmi.elements.XMIElementImpl;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.ElementWriter;
import com.togethersoft.selena.xmi.util.XMI11Export;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.model.elements.Entity;

public class XMISystemBoundary
extends XMIElementImpl {
    public static final String BOUNDARY = "Boundary";
    private boolean myWriteBoundaryTag;

    public XMISystemBoundary() {
    }

    public XMISystemBoundary(XMLWriter xMLWriter, Entity entity, XMIDiagram xMIDiagram) {
        super(xMLWriter, entity, xMIDiagram);
        this.myName = BOUNDARY;
        this.myWriteBoundaryTag = false;
        if (!XMI11Export.isTCCSpecificExport()) {
            XMI11Export.addIncompatibleElement(entity, null);
        } else if (XMI11Export.isRoseSpecificExport()) {
            XMI11Export.addIncompatibleElement(entity, null);
        } else {
            this.myWriteBoundaryTag = true;
        }
        if (this.myWriteBoundaryTag) {
            this.myID = XMI11Export.getElementID(this.myElement);
            this.writeTaggedValues();
        }
    }

    public void writeXMI11Element() throws Exception {
        Object object;
        Object object2;
        super.writeXMI11Element();
        if (this.myWriteBoundaryTag) {
            Diagnostic.print("Writing boundary " + this.myElement.getPropertyValue("$name"));
            if (XMI11Export.isExported(this.myElement)) {
                return;
            }
            XMI11Export.addExportedElement(this.myElement, this.myID);
            object2 = this.myElement.getPropertyValue("$name");
            this.myWriter.writeStartTag("UML", this.myName);
            this.myWriter.writeAttribute("xmi.id", this.myID);
            this.myWriter.writeAttribute("name", (String)object2, true);
            this.myWriter.writeAttribute("visibility", this.visibilityValue());
            this.myWriter.writeAttribute("isSpecification", this.isSpecificationValue());
            this.myWriter.writeAttribute("isAbstract", this.isAbstractValue(), true);
            this.writeStereotype();
            this.myWriter.writeCloseBrasket();
            if (XMI11Export.isUnisysExport()) {
                this.myWriter.writeStartTag("UML", "ModelElement.namespace", true);
                this.myWriter.writeStartTag("Foundation.Core.Namespace");
                object = "";
                object = XMI11Export.hasModelID(this.myElement) ? XMI11Export.getModelID(this.myElement) : XMI11Export.getElementID(this.myElement);
                this.myWriter.writeAttribute("xmi.idref", (String)object);
                this.myWriter.writeCloseBrasket(true);
                this.myWriter.writeEndTag("UML", "ModelElement.namespace");
            }
            this.myWriter.writeStartTag("UML", "Namespace.ownedElement", true);
        }
        if ((object2 = this.myElement) != null) {
            object = object2.childEntities();
            while (object.hasMoreElements()) {
                Entity entity = object.next();
                ElementWriter.writeElement(this.myWriter, entity, this.myDiagram);
            }
        }
        if (this.myWriteBoundaryTag) {
            this.myWriter.writeEndTag("UML", "Namespace.ownedElement");
            this.myWriter.writeEndTag("UML", this.myName);
        }
    }

    public Entity createRwiElement(Entity entity) throws XMIException {
        if (!entity.canCreateChildEntity("System Boundary", null)) {
            throw new XMIException("xmi.import.error.cannot.create", BOUNDARY);
        }
        this.myElement = entity.createChildEntity("System Boundary", null);
        if (this.myElement != null) {
            Diagnostic.print(this.myElement.getPropertyValue("$metaclass") + " '" + this.myElement.getPropertyValue("$name") + "' created successfully");
        } else {
            Diagnostic.print("Failed to create Boundary");
        }
        return this.myElement;
    }

    public Entity setProperty(String string, String string2) throws XMIException {
        if (string == null || string.length() == 0 || string2 == null) {
            throw new XMIException("xmi.import.error.cannot.set.property", string);
        }
        if ("xmi.id".equals(string) && string2.length() != 0) {
            this.myID = string2;
            XMI11Import.addElement(string2, this.myElement);
        }
        if ("name".equals(string)) {
            Entity entity = this.myElement;
            this.myElement = XMIAbstractElement.setRwiName(this.myElement, string2);
            XMI11Import.replaceElement(entity, this.myElement);
        }
        return this.myElement;
    }
}

