/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.elements;

import com.togethersoft.selena.xmi.elements.XMIAbstractElement;
import com.togethersoft.selena.xmi.elements.XMIComponent;
import com.togethersoft.selena.xmi.elements.XMIDiagram;
import com.togethersoft.selena.xmi.elements.XMIElementImpl;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.ElementWriter;
import com.togethersoft.selena.xmi.util.InterchangeUtils;
import com.togethersoft.selena.xmi.util.XMI11Export;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.enum.ReferenceEnumeration;
import java.util.Vector;

public class XMISubsystem
extends XMIElementImpl {
    public static final String SUBSYSTEM = "Subsystem";
    public static final String COMPONENT_VIEW = "Component View";
    private Vector myDependencies;

    public XMISubsystem() {
        this.myName = SUBSYSTEM;
    }

    public XMISubsystem(XMLWriter xMLWriter, Entity entity, XMIDiagram xMIDiagram) {
        super(xMLWriter, entity, xMIDiagram);
        this.myName = SUBSYSTEM;
        this.myID = XMI11Export.getElementID(this.myElement);
        this.writeTaggedValues();
        this.myDependencies = new Vector();
    }

    public void writeXMI11Element() throws Exception {
        super.writeXMI11Element();
        if (XMI11Export.isExported(this.myElement)) {
            return;
        }
        XMI11Export.addExportedElement(this.myElement, this.myID);
        String string = this.myElement.getPropertyValue("$name");
        Diagnostic.print("Writing out " + this.myName + ", name = " + string + ", id = " + this.myID);
        this.myWriter.writeStartTag("UML", this.myName);
        this.myWriter.writeAttribute("xmi.id", this.myID);
        this.myWriter.writeAttribute("name", string, true);
        this.myWriter.writeAttribute("visibility", this.visibilityValue());
        this.myWriter.writeAttribute("isSpecification", this.isSpecificationValue());
        this.writeStereotype();
        this.myWriter.writeCloseBrasket();
        this.writeXMI11Content();
        this.myWriter.writeEndTag("UML", this.myName);
        int n = 0;
        while (n < this.myDependencies.size()) {
            ElementWriter.writeElement(this.myWriter, (Entity)this.myDependencies.elementAt(n), this.myDiagram);
            ++n;
        }
    }

    public Entity createRwiElement(Entity entity) throws XMIException {
        if (entity == null) {
            throw new XMIException("xmi.import.error.cannot.create", SUBSYSTEM);
        }
        if (!entity.canCreateChildEntity(SUBSYSTEM, null)) {
            throw new XMIException("xmi.import.error.cannot.create", this.myName);
        }
        this.myElement = entity.createChildEntity(SUBSYSTEM, null);
        if (this.myElement != null) {
            Diagnostic.print(this.myElement.getPropertyValue("$metaclass") + " '" + this.myElement.getPropertyValue("$name") + "' created successfully");
        } else {
            Diagnostic.print("Failed to create RwiElement");
        }
        return this.myElement;
    }

    public Entity setProperty(String string, String string2) throws XMIException {
        if (string == null || string.length() == 0 || string2 == null) {
            throw new XMIException("xmi.import.error.cannot.set.property", string);
        }
        if ("xmi.id".equals(string) && string2.length() != 0) {
            this.myID = string2;
            XMI11Import.addElement(string2, this.myElement);
        }
        if ("name".equals(string)) {
            Entity entity = this.myElement;
            this.myElement = XMIAbstractElement.setRwiName(this.myElement, string2);
            XMI11Import.replaceElement(entity, this.myElement);
        }
        return this.myElement;
    }

    protected void writeXMI11Content() throws Exception {
        this.myWriter.writeStartTag("UML", "Namespace.ownedElement", true);
        if (this.myElement.hasPropertyValue("$metaclass", "DesignDiagram")) {
            Entity entity = this.myElement;
            ReferenceEnumeration referenceEnumeration = InterchangeUtils.references(entity);
            while (referenceEnumeration.hasMoreElements()) {
                Entity entity2 = referenceEnumeration.next().getEntity();
                this.writeChild(entity2);
            }
        } else if (SUBSYSTEM.equals(this.myElement.getPropertyValue("$metaclass"))) {
            EntityEnumeration entityEnumeration = this.myElement.childEntities();
            while (entityEnumeration.hasMoreElements()) {
                Entity entity = entityEnumeration.next();
                this.writeChild(entity);
            }
        }
        this.myWriter.writeEndTag("UML", "Namespace.ownedElement");
    }

    protected void writeChild(Entity entity) throws Exception {
        if (entity == null) {
            return;
        }
        if (entity.isDeleted()) {
            return;
        }
        String string = entity.getPropertyValue("$metaclass");
        if ("Component".equals(string) || "Class".equals(string) && entity.hasProperty("$interface")) {
            new XMIComponent(this.myWriter, entity, this.myDiagram).writeXMI11Element();
        } else if (SUBSYSTEM.equals(string)) {
            new XMISubsystem(this.myWriter, entity, this.myDiagram).writeXMI11Element();
        } else if ("Dependency Link".equals(string)) {
            this.myDependencies.add(entity);
        }
    }
}

