/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.elements;

import com.togethersoft.selena.xmi.elements.XMIAbstractElement;
import com.togethersoft.selena.xmi.util.XMI11Export;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.model.elements.Entity;
import java.util.StringTokenizer;

public class XMIStereotype
extends XMIAbstractElement {
    public static final String STEREOTYPE = "Stereotype";
    public static final String STEREOTYPE_EXTENDEDELEMENT = "Stereotype.extendedElement";
    public static final String STEREOTYPE_BASECLASS = "Stereotype.baseClass";
    public static final String STEREOTYPE_INCLUDE = "include";
    public static final String STEREOTYPE_EXTEND = "extend";
    public static final String STEREOTYPE_ENUM = "enum";
    public static final String STEREOTYPE_STRUCT = "structure";
    public static final String STEREOTYPE_UNION = "union";
    public static final String STEREOTYPE_CONSTRUCTOR = "constructor";
    public static final String STEREOTYPE_EXCEPTION = "exception";
    public static final String STEREOTYPE_VALUETYPE = "valuetype";
    private String myTypeName;
    private String myBaseClass;
    private String myIdref;
    private String myIcon;
    private boolean myReferenceAllowed;
    private boolean mySpecification;

    public XMIStereotype() {
        this.myReferenceAllowed = false;
    }

    public XMIStereotype(XMLWriter xMLWriter, String string, String string2, String string3) {
        super(xMLWriter);
        this.myIdref = string3;
        this.myTypeName = string;
        this.myBaseClass = string2;
        this.myName = STEREOTYPE;
        this.myID = XMI11Export.getDiagramElementID(this);
    }

    public void writeXMI11Element() throws Exception {
        if ("Association Link".equals(this.myTypeName)) {
            return;
        }
        this.myWriter.writeComments("==================== " + this.myTypeName + " [Stereotype] ====================");
        this.myWriter.writeStartTag("UML", this.myName);
        this.myWriter.writeAttribute("xmi.id", this.myID);
        if (XMI11Export.isTCCSpecificExport() && "INTERFACE".equals(this.myTypeName.toUpperCase())) {
            this.myWriter.writeAttribute("name", "Interface", true);
        } else {
            this.myWriter.writeAttribute("name", this.myTypeName, true);
        }
        this.myWriter.writeAttribute("visibility", "public");
        this.myWriter.writeAttribute("isSpecification", "false");
        this.myWriter.writeAttribute("icon", "");
        if (XMI11Export.isUnisysExport()) {
            this.myWriter.writeAttribute("baseClass", this.myBaseClass);
            this.myWriter.writeCloseBrasket();
            this.myWriter.writeStartTag("UML", STEREOTYPE_EXTENDEDELEMENT, true);
            this.myWriter.writeStartTag("Foundation.Core.ModelElement");
            this.myWriter.writeAttribute("xmi.idref", this.myIdref);
            this.myWriter.writeCloseBrasket(true);
            this.myWriter.writeEndTag("UML", STEREOTYPE_EXTENDEDELEMENT);
            this.myWriter.writeEndTag("UML", this.myName);
        } else if (this.myBaseClass != null && this.myBaseClass.length() != 0) {
            this.myWriter.writeCloseBrasket();
            this.myWriter.writeStartTag("UML", STEREOTYPE_BASECLASS, true);
            this.myWriter.writeCDATA(this.myBaseClass);
            this.myWriter.writeEndTag("UML", STEREOTYPE_BASECLASS);
            this.myWriter.writeEndTag("UML", this.myName);
        } else {
            this.myWriter.writeCloseBrasket(true);
        }
    }

    public String getName() {
        return this.myTypeName;
    }

    public String getReference() {
        return this.myIdref;
    }

    public String getBaseClass() {
        return this.myBaseClass;
    }

    public void setReference(String string) throws XMIException {
        this.myIdref = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ", false);
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (string2 != null && string2.length() != 0) {
                XMI11Import.addStereotype(string2, this);
                continue;
            }
            throw new XMIException("xmi.import.error.cannot.set.stereotype", this.myTypeName);
        }
    }

    public void allowReference(boolean bl) {
        this.myReferenceAllowed = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Entity setProperty(String string, String string2) throws XMIException {
        if ("xmi.id".equals(string) && string2 != null && string2.length() != 0) {
            this.myID = string2;
            XMI11Import.addStereotypeById(this.myID, this);
            return null;
        } else if ("name".equals(string) && string2 != null) {
            this.myTypeName = string2;
            return null;
        } else if ("visibility".equals(string)) {
            if (!"public".equals(string2) && !"private".equals(string2) && !"protected".equals(string2) && !"package".equals(string2)) throw new XMIException("xmi.import.error.incorrect.attribute.value", string, string2);
            this.myVisibility = string2;
            return null;
        } else if ("isSpecification".equals(string)) {
            if ("true".equals(string2)) {
                this.mySpecification = true;
                return null;
            } else {
                if (!"false".equals(string2)) throw new XMIException("xmi.import.error.incorrect.attribute.value", string, string2);
                this.mySpecification = false;
            }
            return null;
        } else if ("icon".equals(string)) {
            this.myIcon = string2;
            return null;
        } else if ("baseClass".equals(string)) {
            this.myBaseClass = string2;
            return null;
        } else {
            if (!"extendedElement".equals(string)) return null;
            this.setReference(string2);
        }
        return null;
    }

    public void setStereotype(Entity entity) throws XMIException {
        if (entity != null) {
            String string = this.getName() + ";";
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = stringTokenizer.nextToken();
                this.setStereotypeInternal(entity, string2);
            }
        } else {
            throw new XMIException("xmi.import.error.cannot.set.property2", "@stereotype", this.getName());
        }
    }

    private void setStereotypeInternal(Entity entity, String string) throws XMIException {
        if ("INTERFACE".equals(string.toUpperCase())) {
            string = "interface";
        }
        if (entity.hasProperty("@stereotype")) {
            if (!entity.hasPropertyValue("@stereotype", string) && entity.canAddProperty("@stereotype", string)) {
                entity.addProperty("@stereotype", string);
            }
        } else if (entity.canSetPropertyValue("@stereotype", string)) {
            entity.setPropertyValue("@stereotype", string);
        } else {
            throw new XMIException("xmi.import.error.cannot.set.property2", "@stereotype", string);
        }
    }
}

