/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.elements;

import com.togethersoft.selena.xmi.elements.XMIAbstractElement;
import com.togethersoft.selena.xmi.elements.XMIClassifierRole;
import com.togethersoft.selena.xmi.elements.XMIElementImpl;
import com.togethersoft.selena.xmi.elements.XMIPartition;
import com.togethersoft.selena.xmi.elements.XMIState;
import com.togethersoft.selena.xmi.elements.XMITransition;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.XMI11Export;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIElementCollector;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.model.elements.Entity;
import java.util.Vector;

public class XMIStateMachine
extends XMIAbstractElement {
    public static final String STATEMACHINE = "StateMachine";
    public static final String STATEMACHINE_CONTEXT = "StateMachine.context";
    public static final String STATEMACHINE_TOP = "StateMachine.top";
    public static final String STATEMACHINE_TRANSITIONS = "StateMachine.transitions";
    public static final String ACTIVITYGRAPH = "ActivityGraph";
    public static final String ACTIVITYGRAPH_PARTITION = "ActivityGraph.partition";
    private Vector myElements;
    private Vector myPartitions;
    private Vector myNames;
    private String myContextID;
    private XMIElementCollector myTransitionCollector;
    private XMIElementCollector myPartitionCollector;
    private XMIElementCollector myStateCollector;
    private XMIElementCollector myObjectCollector;

    public XMIStateMachine(Entity entity) {
        this.myParent = entity;
    }

    public XMIStateMachine(XMLWriter xMLWriter, String string) {
        super(xMLWriter);
        this.myName = STATEMACHINE;
        this.myID = XMI11Export.getElementID(this);
        this.myContextID = string;
        this.myTransitionCollector = new XMIElementCollector(true);
        this.myPartitionCollector = new XMIElementCollector(true);
        this.myStateCollector = new XMIElementCollector(true);
        this.myObjectCollector = new XMIElementCollector(true);
        this.myPartitions = new Vector();
        this.myElements = new Vector();
        this.myNames = new Vector();
    }

    public void writeXMI11Element() throws Exception {
        if (this.isEmpty()) {
            return;
        }
        this.myWriter.writeStartTag("UML", this.myName);
        this.myWriter.writeAttribute("xmi.id", this.myID);
        String string = "State/Activity Model";
        this.myWriter.writeAttribute("name", string, true);
        this.myWriter.writeAttribute("visibility", "public");
        this.myWriter.writeAttribute("isSpecification", "true");
        this.myWriter.writeCloseBrasket();
        if (XMI11Export.isUnisysExport()) {
            this.myWriter.writeStartTag("UML", STATEMACHINE_CONTEXT, true);
            this.myWriter.writeStartTag("Foundation.Core.ModelElement");
            this.myWriter.writeAttribute("xmi.idref", this.myContextID);
            this.myWriter.writeCloseBrasket(true);
            this.myWriter.writeEndTag("UML", STATEMACHINE_CONTEXT);
        }
        this.writeXMI11Content();
        this.myWriter.writeEndTag("UML", this.myName);
    }

    public Entity setProperty(String string, String string2) throws XMIException {
        if (string == null || string.length() == 0 || string2 == null) {
            throw new XMIException("xmi.import.error.cannot.set.property2", string, string2);
        }
        if ("xmi.id".equals(string) && string2.length() != 0) {
            this.myID = string2;
            XMI11Import.addXMIElement(string2, this);
        }
        return null;
    }

    public void addTransition(XMITransition xMITransition) {
        if (this.isAlreadyAdded(xMITransition)) {
            return;
        }
        this.myTransitionCollector.addXMIElement(xMITransition);
    }

    public void addPartition(XMIPartition xMIPartition) {
        if (this.isAlreadyAdded(xMIPartition)) {
            return;
        }
        this.myPartitionCollector.addXMIElement(xMIPartition);
        this.myPartitions.add(xMIPartition);
        this.myName = ACTIVITYGRAPH;
    }

    public void addState(XMIState xMIState) {
        if (this.isAlreadyAdded(xMIState)) {
            return;
        }
        if (xMIState != null && "ActionState".equals(xMIState.getName())) {
            this.myName = ACTIVITYGRAPH;
        }
        this.myStateCollector.addXMIElement(xMIState);
    }

    public void addObject(XMIClassifierRole xMIClassifierRole) {
        if (this.isAlreadyAdded(xMIClassifierRole)) {
            return;
        }
        this.myObjectCollector.addXMIElement(xMIClassifierRole);
    }

    protected void writeXMI11Content() throws Exception {
        this.myWriter.writeStartTag("UML", STATEMACHINE_TOP, true);
        this.myWriter.writeStartTag("UML", "CompositeState");
        this.myWriter.writeAttribute("xmi.id", XMI11Export.getDiagramElementID(this));
        this.myWriter.writeAttribute("name", "{top}", true);
        this.myWriter.writeAttribute("visibility", "public");
        this.myWriter.writeAttribute("isSpecification", "false");
        this.myWriter.writeCloseBrasket();
        this.myWriter.writeStartTag("UML", "CompositeState.subvertex", true);
        int n = 0;
        while (n < this.myPartitions.size()) {
            if (this.myPartitions.elementAt(n) instanceof XMIPartition) {
                ((XMIPartition)this.myPartitions.elementAt(n)).writeXMI11Content();
            }
            ++n;
        }
        if (this.myStateCollector != null && !this.myStateCollector.isEmpty()) {
            this.myStateCollector.write(this.myWriter);
        }
        this.myWriter.writeEndTag("UML", "CompositeState.subvertex");
        this.myWriter.writeEndTag("UML", "CompositeState");
        this.myWriter.writeEndTag("UML", STATEMACHINE_TOP);
        if (!this.myObjectCollector.isEmpty()) {
            this.myWriter.writeStartTag("UML", "Namespace.ownedElement", true);
            this.myObjectCollector.write(this.myWriter);
            this.myWriter.writeEndTag("UML", "Namespace.ownedElement");
        }
        if (this.myPartitionCollector != null && !this.myPartitionCollector.isEmpty()) {
            this.myWriter.writeStartTag("UML", ACTIVITYGRAPH_PARTITION, true);
            this.myPartitionCollector.write(this.myWriter);
            this.myWriter.writeEndTag("UML", ACTIVITYGRAPH_PARTITION);
        }
        if (this.myTransitionCollector != null && !this.myTransitionCollector.isEmpty()) {
            this.myWriter.writeStartTag("UML", STATEMACHINE_TRANSITIONS, true);
            this.myTransitionCollector.write(this.myWriter);
            this.myWriter.writeEndTag("UML", STATEMACHINE_TRANSITIONS);
        } else {
            Diagnostic.print("TransitionCollector is Empty!");
        }
    }

    private boolean isEmpty() {
        return this.myStateCollector.isEmpty() && this.myObjectCollector.isEmpty() && this.myTransitionCollector.isEmpty() && this.myPartitionCollector.isEmpty();
    }

    private boolean isAlreadyAdded(XMIElementImpl xMIElementImpl) {
        Entity entity = xMIElementImpl.getRwiElement();
        if (this.myElements.contains(entity)) {
            return true;
        }
        this.myElements.add(entity);
        if (xMIElementImpl instanceof XMIState) {
            String string = ((XMIState)xMIElementImpl).getStateName();
            if (this.myNames.contains(string)) {
                StringBuffer stringBuffer = null;
                stringBuffer = string != null ? new StringBuffer(string) : new StringBuffer();
                int n = 0;
                while (n < 1000) {
                    if (!this.myNames.contains(stringBuffer.toString())) {
                        ((XMIState)xMIElementImpl).setStateName(stringBuffer.toString());
                        this.myNames.add(stringBuffer.toString());
                        break;
                    }
                    stringBuffer = string != null ? new StringBuffer(string) : new StringBuffer();
                    stringBuffer.append(n);
                    ++n;
                }
            } else {
                this.myNames.add(string);
            }
        }
        return false;
    }
}

