/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.elements;

import com.togethersoft.selena.xmi.elements.BooleanUtil;
import com.togethersoft.selena.xmi.elements.XMIActionState;
import com.togethersoft.selena.xmi.elements.XMIClassifierRole;
import com.togethersoft.selena.xmi.elements.XMIDiagram;
import com.togethersoft.selena.xmi.elements.XMIElementImpl;
import com.togethersoft.selena.xmi.elements.XMIPartition;
import com.togethersoft.selena.xmi.elements.XMITaggedValue;
import com.togethersoft.selena.xmi.elements.XMITransition;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.InterchangeUtils;
import com.togethersoft.selena.xmi.util.XMI11Export;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIElementCollector;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Reference;
import java.util.Vector;

public class XMIState
extends XMIElementImpl {
    public static final String STATE = "State";
    public static final String STATE_ENTRY = "State.entry";
    public static final String STATE_EXIT = "State.exit";
    public static final String STATE_DEFERRABLEEVENT = "State.deferrableEvent";
    public static final String STATE_INTERNALTRANSITION = "State.internalTransition";
    public static final String STATE_DOACTIVITY = "State.doActivity";
    public static final String STATE_STATEMACHINE = "State.stateMachine";
    public static final String STATEVERTEX_INCOMING = "StateVertex.incoming";
    public static final String STATEVERTEX_OUTGOING = "StateVertex.outgoing";
    public static final String SIMPLESTATE = "SimpleState";
    public static final String PSEUDOSTATE = "Pseudostate";
    public static final String FINALSTATE = "FinalState";
    public static final String COMPOSITESTATE = "CompositeState";
    public static final String SUBMACHINESTATE = "SubmachineState";
    public static final String SUBACTIVITYSTATE = "SubactivityState";
    public static final String OBJECTFLOWSTATE = "ObjectFlowState";
    public static final String CALLSTATE = "CallState";
    public static final String STUBSTATE = "StubState";
    public static final String SYNCHSTATE = "SynchState";
    public static final String STATEVERTEX = "StateVertex";
    public static final String COMPOSITESTATE_SUBVERTEX = "CompositeState.subvertex";
    public static final String KIND = "kind";
    public static final String KIND_INITIAL = "initial";
    public static final String KIND_JOIN = "join";
    public static final String KIND_FORK = "fork";
    public static final String KIND_BRANCH = "branch";
    public static final String KIND_CHOICE = "choice";
    public static final String KIND_SHALLOWHISTORY = "shallowHistory";
    public static final String KIND_DEEPHISTORY = "deepHistory";
    public static final String KIND_JUNCTION = "junction";
    public static final String TYPE_STATE = "State";
    private Vector myOutgoingTransitions;
    private XMIElementCollector myInternalTransitionCollector;
    private XMIElementCollector myDeferredEventCollector;
    private XMIElementCollector myInnerStates;
    private XMIElementCollector myInnerObjects;
    private Vector myPartitions;
    private String myNameAtt;
    private String myKind;
    private boolean myIsComposite;
    private boolean myIsDiagram;
    private String myViewStyle;
    protected boolean needWrite = true;

    public XMIState(String string) {
        this.myName = string;
    }

    public XMIState(XMLWriter xMLWriter, Entity entity, XMIDiagram xMIDiagram) {
        super(xMLWriter, entity, xMIDiagram);
        this.init();
    }

    public void writeXMI11Element() throws Exception {
        super.writeXMI11Element();
        if (!this.needWrite) {
            return;
        }
        if (!this.isRoseCompatible()) {
            return;
        }
        XMI11Export.addExportedElement(this.myElement, this.myID);
        Diagnostic.print("Writing out XMIState " + this.myElement.getPropertyValue("$name"));
        this.myWriter.writeStartTag("UML", this.myName);
        this.myWriter.writeAttribute("xmi.id", this.myID);
        this.myWriter.writeAttribute("name", this.myNameAtt, true);
        this.myWriter.writeAttribute("visibility", this.visibilityValue());
        this.myWriter.writeAttribute("isSpecification", this.isSpecificationValue());
        if (PSEUDOSTATE.equals(this.myName)) {
            this.myWriter.writeAttribute(KIND, this.myKind);
        }
        this.writeStereotype();
        this.myWriter.writeCloseBrasket();
        this.writeXMI11Content();
        this.myWriter.writeEndTag("UML", this.myName);
        String string = this.myElement.getPropertyValue("$orientation");
        if (string != null && "vertical".equals(string)) {
            XMITaggedValue xMITaggedValue = new XMITaggedValue(this.myWriter, this.myID, "vertical", "");
            XMI11Export.addTaggedValue(xMITaggedValue);
        }
    }

    public void setName(String string) {
        this.myNameAtt = string;
    }

    public Entity createRwiElement(Entity entity) throws XMIException {
        String string = null;
        if (SIMPLESTATE.equals(this.myName) || COMPOSITESTATE.equals(this.myName) || "State".equals(this.myName)) {
            string = "State";
        } else if (PSEUDOSTATE.equals(this.myName)) {
            string = "Start State";
        } else if (FINALSTATE.equals(this.myName)) {
            string = "End State";
        }
        if (string == null) {
            throw new XMIException("xmi.import.error.cannot.create", this.myName);
        }
        if (!entity.canCreateChildEntity(string, null)) {
            throw new XMIException("xmi.import.error.cannot.create", this.myName);
        }
        this.myElement = entity.createChildEntity(string, null);
        if (this.myElement != null) {
            Diagnostic.print(this.myElement.getPropertyValue("$metaclass") + " '" + this.myElement.getPropertyValue("$name") + "' created successfully");
        } else {
            Diagnostic.print("Failed to create RwiElement");
        }
        return this.myElement;
    }

    public Entity setProperty(String string, String string2) throws XMIException {
        super.setProperty(string, string2);
        if (KIND.equals(string)) {
            Diagnostic.print("XMIState, setting kind " + string2);
            if (this.myElement != null) {
                Diagnostic.print("XMIState, setting kind, " + string2 + " element!=null");
                if (PSEUDOSTATE.equals(this.myName)) {
                    if (KIND_JOIN.equals(string2) || KIND_FORK.equals(string2)) {
                        Diagnostic.print("XMIState, setting shapeType Synchronization Bar");
                        XMI11Import.changeMetaclass(this.myElement, "Synchronization Bar");
                        this.myElement.setPropertyValue("$orientation", "horizontal");
                        Diagnostic.print("New shapeType = " + this.myElement.getPropertyValue("$metaclass"));
                    }
                    if (KIND_INITIAL.equals(string2)) {
                        Diagnostic.print("XMIState, setting shapeType Start State");
                        Diagnostic.print("New shapeType = " + this.myElement.getPropertyValue("$metaclass"));
                    }
                    if (KIND_BRANCH.equals(string2) || KIND_CHOICE.equals(string2) || KIND_JUNCTION.equals(string2)) {
                        Diagnostic.print("XMIState, setting shapeType Decision");
                        XMI11Import.changeMetaclass(this.myElement, "Decision");
                        Diagnostic.print("New shapeType = " + this.myElement.getPropertyValue("$metaclass"));
                    }
                    if (KIND_SHALLOWHISTORY.equals(string2)) {
                        Diagnostic.print("XMIState, setting shapeType History");
                        XMI11Import.changeMetaclass(this.myElement, "History");
                        Diagnostic.print("New shapeType = " + this.myElement.getPropertyValue("$metaclass"));
                    }
                    if (KIND_DEEPHISTORY.equals(string2)) {
                        Diagnostic.print("XMIState, setting shapeType History");
                        XMI11Import.changeMetaclass(this.myElement, "History");
                        this.myElement.setPropertyValue("$deep", BooleanUtil.toString(true));
                        Diagnostic.print("New shapeType = " + this.myElement.getPropertyValue("$metaclass"));
                    }
                }
            }
        }
        return this.myElement;
    }

    public String getStateName() {
        return this.myNameAtt;
    }

    public void setStateName(String string) {
        this.myNameAtt = string;
    }

    protected void writeXMI11Content() throws Exception {
        int n;
        if (this.myIsComposite) {
            Diagnostic.print("STATE: is Composite State, name = " + this.myName);
            this.myWriter.writeStartTag("UML", COMPOSITESTATE_SUBVERTEX, true);
            this.myInnerStates.write(this.myWriter);
            n = 0;
            while (n < this.myPartitions.size()) {
                if (this.myPartitions.elementAt(n) instanceof XMIPartition) {
                    ((XMIPartition)this.myPartitions.elementAt(n)).writeXMI11Content();
                }
                ++n;
            }
            this.myWriter.writeEndTag("UML", COMPOSITESTATE_SUBVERTEX);
            if (!this.myInnerObjects.isEmpty()) {
                this.myWriter.writeStartTag("UML", "ModelElement.namespace", true);
                this.myWriter.writeStartTag("UML", "Namespace");
                this.myWriter.writeAttribute("xmi.id", XMI11Export.getDiagramElementID(this.myInnerObjects));
                this.myWriter.writeAttribute("name", "");
                this.myWriter.writeCloseBrasket();
                this.myWriter.writeStartTag("UML", "Namespace.ownedElement", true);
                this.myInnerObjects.write(this.myWriter);
                this.myWriter.writeEndTag("UML", "Namespace.ownedElement");
                this.myWriter.writeEndTag("UML", "Namespace");
                this.myWriter.writeEndTag("UML", "ModelElement.namespace");
            }
        } else {
            Diagnostic.print("STATE: is NOT Composite State, name = " + this.myName);
        }
        if (!this.myOutgoingTransitions.isEmpty()) {
            this.myWriter.writeStartTag("UML", STATEVERTEX_OUTGOING, true);
            n = 0;
            while (n < this.myOutgoingTransitions.size()) {
                if (XMI11Export.isUnisysExport()) {
                    this.myWriter.writeStartTag("Behavioral_Elements.State_Machines.Transition");
                    this.myWriter.writeAttribute("xmi.idref", XMI11Export.getModelID(this.myOutgoingTransitions.elementAt(n)));
                    this.myWriter.writeCloseBrasket(true);
                } else {
                    this.myWriter.writeStartTag("UML", "Transition");
                    this.myWriter.writeAttribute("xmi.idref", XMI11Export.getModelID(this.myOutgoingTransitions.elementAt(n)));
                    this.myWriter.writeCloseBrasket(true);
                }
                ++n;
            }
            this.myWriter.writeEndTag("UML", STATEVERTEX_OUTGOING);
        }
        if (!this.myDeferredEventCollector.isEmpty()) {
            this.myWriter.writeStartTag("UML", STATE_DEFERRABLEEVENT, true);
            this.myDeferredEventCollector.write(this.myWriter);
            this.myWriter.writeEndTag("UML", STATE_DEFERRABLEEVENT);
        }
        if (!this.myInternalTransitionCollector.isEmpty()) {
            this.myWriter.writeStartTag("UML", STATE_INTERNALTRANSITION, true);
            this.myInternalTransitionCollector.write(this.myWriter);
            this.myWriter.writeEndTag("UML", STATE_INTERNALTRANSITION);
        }
    }

    protected void collectElements() {
        Diagnostic.print("STATE " + this.myNameAtt + ": collecting Elements");
        this.myOutgoingTransitions = new Vector();
        this.myInternalTransitionCollector = new XMIElementCollector(true);
        this.myDeferredEventCollector = new XMIElementCollector(true);
        this.myInnerStates = new XMIElementCollector(true);
        this.myInnerObjects = new XMIElementCollector(true);
        this.myPartitions = new Vector();
        Object object = this.myElement.hasPropertyValue("$metaclass", "DesignDiagram") ? InterchangeUtils.references(this.myElement) : this.myElement.childEntities();
        while (object.hasMoreElements()) {
            Object e = object.nextElement();
            Entity entity = e instanceof Reference ? ((Reference)e).getEntity() : (Entity)e;
            String string = entity.getPropertyValue("$metaclass");
            Diagnostic.print("STATE " + this.myNameAtt + ": collecting Elements, next Entity " + string);
            if ("State".equals(string) || "Start State".equals(string) || "End State".equals(string) || "Decision".equals(string) || "Synchronization Bar".equals(string) || "History".equals(string)) {
                Diagnostic.print("STATE " + this.myNameAtt + ": collecting Elements, inner State found " + entity.getPropertyValue("$name"));
                this.myInnerStates.addXMIElement(new XMIState(this.myWriter, entity, this.myDiagram));
                continue;
            }
            if ("Activity".equals(string)) {
                Diagnostic.print("STATE " + this.myNameAtt + ": collecting Elements, inner Action State found " + entity.getPropertyValue("$name"));
                this.myInnerStates.addXMIElement(new XMIActionState(this.myWriter, entity, this.myDiagram));
                continue;
            }
            if ("Signal Receipt".equals(string) || "Signal Sending".equals(string)) {
                if (!XMI11Export.isTCCSpecificExport()) {
                    XMI11Export.addIncompatibleElement(entity, this.myElement);
                    continue;
                }
                Diagnostic.print("STATE " + this.myNameAtt + ": collecting Elements, inner Action State found " + entity.getPropertyValue("$name"));
                this.myInnerStates.addXMIElement(new XMIActionState(this.myWriter, entity, this.myDiagram));
                continue;
            }
            if ("Swimlane".equals(string)) {
                this.myPartitions.add(new XMIPartition(this.myWriter, entity, this.myDiagram));
                continue;
            }
            if ("Object".equals(string)) {
                Diagnostic.print("STATE " + this.myNameAtt + ": collecting Elements, inner Object found " + entity.getPropertyValue("$name"));
                this.myInnerObjects.addXMIElement(new XMIClassifierRole(this.myWriter, entity, this.myDiagram));
                continue;
            }
            if ("Transition".equals(string)) {
                Diagnostic.print("STATE " + this.myNameAtt + ": collecting Elements, Transition found " + entity.getPropertyValue("$name"));
                XMI11Export.addTransition(new XMITransition(this.myWriter, entity, this.myDiagram));
                this.myOutgoingTransitions.addElement(entity);
                continue;
            }
            if ("Object Flow".equals(string)) {
                if (!XMI11Export.isTCCSpecificExport()) {
                    XMI11Export.addIncompatibleElement(entity, this.myElement);
                    continue;
                }
                Diagnostic.print("STATE " + this.myNameAtt + ": collecting Elements, Transition found " + entity.getPropertyValue("$name"));
                XMI11Export.addTransition(new XMITransition(this.myWriter, entity, this.myDiagram));
                this.myOutgoingTransitions.addElement(entity);
                continue;
            }
            if ("Internal Transition".equals(string)) {
                Diagnostic.print("STATE " + this.myNameAtt + ": collecting Elements, internal transition found " + entity.getPropertyValue("$name"));
                this.myInternalTransitionCollector.addXMIElement(new XMITransition(this.myWriter, entity, this.myDiagram));
                continue;
            }
            if ("Deferred Event".equals(string)) {
                Diagnostic.print("STATE " + this.myNameAtt + ": collecting Elements, deferred event found " + entity.getPropertyValue("$name"));
                this.myDeferredEventCollector.addXMIElement(new XMITransition(this.myWriter, entity, this.myDiagram));
                continue;
            }
            Diagnostic.print("STATE " + this.myNameAtt + ": collecting Elements, UNKNOWN found " + entity.getPropertyValue("$name"));
        }
    }

    private void init() {
        String string = this.myElement.getPropertyValue("$metaclass");
        this.myIsComposite = false;
        this.myIsDiagram = false;
        this.myNameAtt = this.myElement.getPropertyValue("$name");
        this.collectElements();
        Diagnostic.print("STATE " + this.myNameAtt + ": type " + string);
        if (this.myElement.hasPropertyValue("$metaclass", "DesignDiagram")) {
            Diagnostic.print("STATE " + this.myNameAtt + ":.hasPropertyValue (Property.METACLASS, \"DesignDiagram\" )");
            this.myName = COMPOSITESTATE;
            this.myIsComposite = true;
            this.myIsDiagram = true;
        } else if ("State".equals(string)) {
            Diagnostic.print("STATE " + this.myNameAtt + ": type State ");
            if (!this.myInnerStates.isEmpty() || !this.myInnerObjects.isEmpty()) {
                Diagnostic.print("STATE " + this.myNameAtt + ": has inner States of Objects ");
                this.myName = COMPOSITESTATE;
                this.myIsComposite = true;
            } else {
                this.myName = SIMPLESTATE;
            }
        } else if ("Start State".equals(string)) {
            this.myName = PSEUDOSTATE;
            this.myKind = KIND_INITIAL;
        } else if ("Decision".equals(string)) {
            this.myName = PSEUDOSTATE;
            this.myKind = KIND_BRANCH;
        } else if ("History".equals(string)) {
            this.myName = PSEUDOSTATE;
            this.myKind = this.myElement.hasProperty("$deep") ? KIND_DEEPHISTORY : KIND_SHALLOWHISTORY;
        } else if ("End State".equals(string)) {
            this.myName = FINALSTATE;
        } else if ("Synchronization Bar".equals(string)) {
            this.myName = PSEUDOSTATE;
            this.myKind = KIND_JOIN;
            this.myViewStyle = this.myElement.hasProperty("vertical") ? "SyncItem, Horizontal=0," : "SyncItem, Horizontal=1,";
        } else {
            this.myName = "State";
        }
        this.myID = this.myIsComposite ? XMI11Export.getModelID(this.myElement) : XMI11Export.getModelID(this.myElement);
        this.writeTaggedValues();
        Diagnostic.print("STATE: name " + this.myName);
    }
}

