/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.elements;

import com.togethersoft.selena.xmi.elements.XMIAbstractElement;
import com.togethersoft.selena.xmi.elements.XMIDiagram;
import com.togethersoft.selena.xmi.elements.XMITransition;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.XMI11Export;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.model.elements.Entity;

public class XMISignal
extends XMIAbstractElement {
    public static final String SIGNAL = "Signal";
    private String mySignalName;

    public XMISignal() {
        Diagnostic.print("New XMISignal");
        this.myName = SIGNAL;
        this.mySignalName = "";
    }

    public XMISignal(XMLWriter xMLWriter, XMIDiagram xMIDiagram, String string) {
        super(xMLWriter);
        this.myName = SIGNAL;
        this.myDiagram = xMIDiagram;
        this.mySignalName = string;
        this.myID = XMI11Export.getModelID(this);
        if (XMI11Export.isUnisysExport()) {
            XMI11Export.addSignal(this);
        }
    }

    public XMISignal(XMLWriter xMLWriter, String string) {
        super(xMLWriter);
        this.myName = SIGNAL;
        this.mySignalName = string;
        this.myID = XMI11Export.getModelID(this);
        if (XMI11Export.isUnisysExport()) {
            XMI11Export.addSignal(this);
        }
    }

    public void writeXMI11Element() throws Exception {
        Diagnostic.print("Writing out " + this.myName + ", name = " + this.mySignalName + ", id = " + this.myID);
        this.myWriter.writeStartTag("UML", this.myName);
        this.myWriter.writeAttribute("xmi.id", this.myID);
        this.myWriter.writeAttribute("name", this.mySignalName, true);
        this.myWriter.writeAttribute("visibility", "public");
        this.myWriter.writeAttribute("isSpecification", "false");
        this.myWriter.writeCloseBrasket(true);
    }

    public Entity setProperty(String string, String string2) throws XMIException {
        super.setProperty(string, string2);
        if ("name".equals(string)) {
            this.mySignalName = string2;
            XMITransition xMITransition = XMI11Import.getCurrentTransition();
            if (xMITransition != null) {
                xMITransition.setSendClause(this.mySignalName);
            }
        }
        if ("xmi.id".equals(string) && string2.length() != 0) {
            this.myID = string2;
        }
        return null;
    }
}

