/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.elements;

import com.togethersoft.selena.xmi.elements.XMIClassifierRole;
import com.togethersoft.selena.xmi.elements.XMIDiagram;
import com.togethersoft.selena.xmi.elements.XMIElementImpl;
import com.togethersoft.selena.xmi.util.ElementWriter;
import com.togethersoft.selena.xmi.util.InterchangeUtils;
import com.togethersoft.selena.xmi.util.XMI11Export;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.model.elements.Container;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.enum.EntityEnumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class XMIPartition
extends XMIElementImpl {
    public static final String PARTITION = "Partition";
    public static final String PARTITION_CONTENTS = "Partition.contents";
    public static final String CONTENTS = "contents";
    public static final String STYLE_SWIMLANE = "Swimlane";
    private Vector myChildReferences;

    public XMIPartition() {
        this.myChildReferences = new Vector();
    }

    public XMIPartition(XMLWriter xMLWriter, Entity entity, XMIDiagram xMIDiagram) {
        super(xMLWriter, entity, xMIDiagram);
        this.myName = PARTITION;
        this.myID = XMI11Export.getModelID(this.myElement);
        XMI11Export.addPartition(this);
        this.writeTaggedValues();
    }

    public void writeXMI11Element() throws Exception {
        String string;
        Entity entity;
        EntityEnumeration entityEnumeration;
        super.writeXMI11Element();
        this.myWriter.writeStartTag("UML", this.myName);
        this.myWriter.writeAttribute("xmi.id", this.myID);
        String string2 = this.myElement.getPropertyValue("$name");
        this.myWriter.writeAttribute("name", string2);
        this.myWriter.writeAttribute("visibility", "public");
        this.myWriter.writeAttribute("isSpecification", "false");
        this.writeStereotype();
        if (XMI11Export.isRoseSpecificExport() && this.myElement != null) {
            entityEnumeration = this.myElement.childEntities();
            entity = null;
            string = "";
            while (entityEnumeration.hasMoreElements()) {
                entity = entityEnumeration.next();
                string = string + XMI11Export.getModelID(entity);
                if (!entityEnumeration.hasMoreElements()) continue;
                string = string + " ";
            }
            this.myWriter.writeAttribute(CONTENTS, string);
        }
        this.myWriter.writeCloseBrasket();
        if (!XMI11Export.isRoseSpecificExport()) {
            this.myWriter.writeStartTag("UML", PARTITION_CONTENTS, true);
            if (this.myElement != null) {
                entityEnumeration = this.myElement.childEntities();
                entity = null;
                while (entityEnumeration.hasMoreElements()) {
                    entity = entityEnumeration.next();
                    string = XMI11Export.getModelID(entity);
                    if (XMI11Export.isUnisysExport()) {
                        this.myWriter.writeStartTag("Foundation.Core.ModelElement");
                        this.myWriter.writeAttribute("xmi.idref", string);
                        this.myWriter.writeCloseBrasket(true);
                        continue;
                    }
                    this.myWriter.writeStartTag("UML", "ModelElement");
                    this.myWriter.writeAttribute("xmi.idref", string);
                    this.myWriter.writeCloseBrasket(true);
                }
            }
            this.myWriter.writeEndTag("UML", PARTITION_CONTENTS);
        }
        this.myWriter.writeEndTag("UML", this.myName);
    }

    public void writeXMI11Content() throws Exception {
        if (this.myElement != null) {
            EntityEnumeration entityEnumeration = this.myElement.childEntities();
            while (entityEnumeration.hasMoreElements()) {
                Entity entity = entityEnumeration.next();
                String string = entity.getPropertyValue("$metaclass");
                if ("Object".equals(string)) {
                    XMI11Export.addStateObject(new XMIClassifierRole(this.myWriter, entity, this.myDiagram));
                    continue;
                }
                ElementWriter.writeElement(this.myWriter, entity, this.myDiagram);
            }
        }
    }

    public Entity createRwiElement(Entity entity) throws XMIException {
        if (entity == null) {
            throw new XMIException("xmi.import.error.cannot.create", STYLE_SWIMLANE);
        }
        if (!entity.canCreateChildEntity(STYLE_SWIMLANE, null)) {
            throw new XMIException("xmi.import.error.cannot.create", STYLE_SWIMLANE);
        }
        this.myElement = entity.createChildEntity(STYLE_SWIMLANE, null);
        if (this.myElement == null) {
            throw new XMIException("xmi.import.error.cannot.create", STYLE_SWIMLANE);
        }
        return this.myElement;
    }

    public Entity setProperty(String string, String string2) throws XMIException {
        super.setProperty(string, string2);
        if ("xmi.id".equals(string)) {
            XMI11Import.addPartition(string2, this);
        }
        if (CONTENTS.equals(string)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            while (stringTokenizer.hasMoreElements()) {
                this.setReference(stringTokenizer.nextToken());
            }
        }
        return this.myElement;
    }

    public void setReference(String string) throws XMIException {
        if (this.myChildReferences == null) {
            this.myChildReferences = new Vector();
        }
        this.myChildReferences.add(string);
    }

    public void assignChildren() throws XMIException {
        if (this.myChildReferences == null) {
            throw new XMIException("xmi.import.error.unknown.in", "UML:" + this.myName);
        }
        String string = null;
        Entity entity = null;
        Object var3_3 = null;
        Object var4_4 = null;
        int n = 0;
        while (n < this.myChildReferences.size()) {
            string = (String)this.myChildReferences.elementAt(n);
            entity = XMI11Import.getElement(string);
            if (entity == null) {
                throw new XMIException("xmi.import.error.cannot.find.element", string);
            }
            if (this.myElement != null && this.myElement instanceof Container) {
                InterchangeUtils.TreeCut(entity, null);
                InterchangeUtils.TreePaste(this.myElement, null);
            }
            ++n;
        }
    }
}

