/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.elements;

import com.togethersoft.selena.xmi.elements.XMIElementImpl;
import com.togethersoft.selena.xmi.elements.XMIExpression;
import com.togethersoft.selena.xmi.elements.XMIOperation;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.XMI11Export;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.model.elements.Entity;

public class XMIParameter
extends XMIElementImpl {
    public static final String PARAMETER = "Parameter";
    public static final String KIND = "kind";
    public static final String KIND_IN = "in";
    public static final String KIND_INOUT = "inout";
    public static final String KIND_OUT = "out";
    public static final String KIND_RETURN = "return";
    public static final String PARAMETER_DEFAULTVALUE = "Parameter.defaultValue";
    public static final String PARAMETER_TYPE = "Parameter.type";
    private String myParamName;
    private String myDirectionKind;
    private String myDefaultValue;
    private String myType;
    private String myTypeID;
    private boolean myTypeAllowed;
    private Entity myParent;
    private XMIOperation myXMIOperation;

    public XMIParameter(XMIOperation xMIOperation) {
        this.myTypeAllowed = false;
        this.myType = "int";
        this.myXMIOperation = xMIOperation;
        this.myParent = xMIOperation.getRwiElement();
    }

    public XMIParameter(Entity entity) {
        this.myTypeAllowed = false;
        this.myType = "int";
        this.myParent = entity;
    }

    public XMIParameter(XMLWriter xMLWriter, String string, Entity entity) {
        super(xMLWriter, entity);
        this.init(string, entity.getPropertyValue("$name"), KIND_INOUT, null);
    }

    public XMIParameter(XMLWriter xMLWriter, String string, String string2) {
        super(xMLWriter, (Entity)null);
        this.init(string, string2, KIND_INOUT, null);
    }

    public XMIParameter(XMLWriter xMLWriter, String string, Entity entity, String string2) {
        super(xMLWriter, entity);
        this.init(string, entity.getPropertyValue("$name"), string2, null);
    }

    public XMIParameter(XMLWriter xMLWriter, String string, String string2, String string3) {
        super(xMLWriter, (Entity)null);
        this.init(string, string2, string3, null);
    }

    public XMIParameter(XMLWriter xMLWriter, String string, Entity entity, String string2, String string3) {
        super(xMLWriter, entity);
        this.init(string, entity.getPropertyValue("$name"), string2, string3);
    }

    public XMIParameter(XMLWriter xMLWriter, String string, String string2, String string3, String string4) {
        super(xMLWriter, (Entity)null);
        this.init(string, string2, string3, string4);
    }

    public void writeXMI11Element() throws Exception {
        super.writeXMI11Element();
        String string = this.myElement != null ? XMI11Export.addDataType(this.myElement) : XMI11Export.addDataType(this.myType);
        this.myWriter.writeStartTag("UML", this.myName);
        this.myWriter.writeAttribute("xmi.id", this.myID);
        this.myWriter.writeAttribute("name", this.myParamName);
        this.myWriter.writeAttribute("isSpecification", "false");
        this.myWriter.writeAttribute(KIND, this.myDirectionKind);
        if (!XMI11Export.isUnisysExport()) {
            this.myWriter.writeAttribute("type", string);
        }
        this.writeStereotype();
        this.myWriter.writeCloseBrasket();
        if (this.myDefaultValue != null) {
            this.myWriter.writeStartTag("UML", PARAMETER_DEFAULTVALUE, true);
            XMIExpression xMIExpression = new XMIExpression(this.myWriter, this.myDefaultValue);
            xMIExpression.writeXMI11Element();
            this.myWriter.writeEndTag("UML", PARAMETER_DEFAULTVALUE);
        }
        if (XMI11Export.isUnisysExport()) {
            this.myWriter.writeStartTag("UML", PARAMETER_TYPE, true);
            this.myWriter.writeStartTag("Foundation.Core.Classifier");
            this.myWriter.writeAttribute("xmi.idref", string);
            this.myWriter.writeCloseBrasket(true);
            this.myWriter.writeEndTag("UML", PARAMETER_TYPE);
        }
        this.myWriter.writeEndTag("UML", this.myName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Entity setProperty(String string, String string2) throws XMIException {
        if ("xmi.id".equals(string)) {
            this.myID = string2;
            return this.myElement;
        } else if ("name".equals(string)) {
            this.myParamName = string2;
            return this.myElement;
        } else if ("xmi.idref".equals(string) && this.myTypeAllowed) {
            this.myTypeID = string2;
            return this.myElement;
        } else if (KIND.equals(string)) {
            if (!KIND_IN.equals(string2) && !KIND_OUT.equals(string2) && !KIND_INOUT.equals(string2) && !KIND_RETURN.equals(string2)) throw new XMIException("xmi.import.error.incorrect.attribute.value", KIND, string2);
            this.myDirectionKind = string2;
            this.addParameter();
            return this.myElement;
        } else {
            if (!"type".equals(string)) return this.myElement;
            this.myTypeID = string2;
        }
        return this.myElement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addParameter() throws XMIException {
        Diagnostic.print("Adding parameter " + this.myParamName + " " + this.myType);
        if (this.myXMIOperation == null) {
            throw new XMIException("xmi.import.error.cannot.create.null", "Parameter " + this.myParamName);
        }
        this.myParent = this.myXMIOperation.getRwiElement();
        if (this.myParent == null) {
            throw new XMIException("xmi.import.error.unknown.in", "UML:Parameter");
        }
        if (this.myDirectionKind == null || this.myDirectionKind.length() == 0) {
            throw new XMIException("xmi.import.error.unknown.in", "UML:Parameter");
        }
        if (this.myType == null) {
            this.myType = "int";
        }
        if (KIND_RETURN.equals(this.myDirectionKind)) {
            if (!this.myParent.canSetPropertyValue("$returnType", this.myType)) throw new XMIException("xmi.import.error.cannot.set.type.return.for", this.myType, this.myParent.getPropertyValue("$name"));
            this.myParent.setPropertyValue("$returnType", this.myType);
            return;
        } else {
            this.myXMIOperation.addParameter(this.myParamName, this.myType);
        }
    }

    public void setValue(String string) {
        this.myDefaultValue = string;
    }

    public void setType(String string) {
        if (this.myTypeAllowed) {
            this.myType = string;
        }
    }

    public void setTypeID(String string) {
        Diagnostic.print("XMIParameter: Setting type ID " + string);
        if (this.myTypeAllowed) {
            Diagnostic.print("XMIParameter: Type ID set");
            this.myTypeID = string;
        }
    }

    public void setAllowType(boolean bl) {
        this.myTypeAllowed = bl;
    }

    /*
     * Unable to fully structure code
     */
    public void setDataType() throws XMIException {
        Diagnostic.print("Setting datatype to parameter " + this.myParamName);
        if (this.myXMIOperation == null) {
            throw new XMIException("xmi.import.error.unknown.in", "UML:Parameter");
        }
        this.myParent = this.myXMIOperation.getRwiElement();
        if (this.myParent == null) {
            throw new XMIException("xmi.import.error.unknown.in", "UML:Parameter");
        }
        if (this.myDirectionKind == null || this.myDirectionKind.length() == 0) {
            throw new XMIException("xmi.import.error.unknown.in", "UML:Parameter");
        }
        var1_1 = this.myParent.properties("$parameter");
        this.myType = XMI11Import.getDatatype(this.myTypeID);
        if (this.myType == null) {
            throw new XMIException("xmi.import.error.cannot.find.datatype", this.myTypeID);
        }
        Diagnostic.print("Got Datatype " + this.myType);
        if (!"return".equals(this.myDirectionKind)) ** GOTO lbl29
        if (this.myParent.canSetPropertyValue("$returnType", this.myType)) {
            this.myParent.setPropertyValue("$returnType", this.myType);
        } else {
            var2_2 = this.myType.lastIndexOf(".");
            if (var2_2 > -1 && this.myParent.canSetPropertyValue("$returnType", this.myType.substring(var2_2))) {
                this.myParent.setPropertyValue("$returnType", this.myType.substring(var2_2));
            } else {
                throw new XMIException("xmi.import.error.cannot.set.type.return.for", this.myType, this.myParent.getPropertyValue("$name"));
lbl-1000:
                // 1 sources

                {
                    var2_3 = var1_1.next();
                    var3_4 = var2_3.getValue();
                    if (var3_4 == null || !var3_4.endsWith(var4_5 = " " + this.myParamName)) continue;
                    var2_3.setValue(this.myType + " " + this.myParamName);
lbl29:
                    // 3 sources

                    ** while (var1_1.hasMoreElements())
                }
            }
        }
lbl30:
        // 3 sources

    }

    private void init(String string, String string2, String string3, String string4) {
        this.myName = PARAMETER;
        this.myParamName = string;
        this.myType = string2;
        this.myDirectionKind = KIND_IN.equals(string3) || KIND_INOUT.equals(string3) || KIND_OUT.equals(string3) || KIND_RETURN.equals(string3) ? string3 : KIND_INOUT;
        this.myDefaultValue = string4;
        this.myID = XMI11Export.getDiagramElementID(this);
    }
}

