/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.elements;

import com.togethersoft.selena.xmi.elements.XMIAbstractElement;
import com.togethersoft.selena.xmi.elements.XMIDiagram;
import com.togethersoft.selena.xmi.elements.XMIElementImpl;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.ElementWriter;
import com.togethersoft.selena.xmi.util.InterchangeUtils;
import com.togethersoft.selena.xmi.util.XMI11Export;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.enum.EntityEnumeration;

public class XMIPackage
extends XMIElementImpl {
    public static final String PACKAGE = "Package";
    private boolean myRoseExport = false;
    private boolean myDefaultPackage;

    public XMIPackage() {
        this.myDefaultPackage = false;
    }

    public XMIPackage(XMLWriter xMLWriter, Entity entity) {
        super(xMLWriter, entity);
        this.myName = PACKAGE;
        this.myID = XMI11Export.getElementID(this.myElement);
        this.myDefaultPackage = false;
        this.writeTaggedValues();
    }

    public XMIPackage(XMLWriter xMLWriter, Entity entity, XMIDiagram xMIDiagram) {
        super(xMLWriter, entity, xMIDiagram);
        this.myName = PACKAGE;
        this.myID = XMI11Export.getElementID(this.myElement);
        this.myDefaultPackage = false;
        this.writeTaggedValues();
    }

    public XMIPackage(XMLWriter xMLWriter, Entity entity, XMIDiagram xMIDiagram, boolean bl) {
        super(xMLWriter, entity, xMIDiagram);
        this.myName = PACKAGE;
        this.myID = XMI11Export.getElementID(this.myElement);
        this.myDefaultPackage = bl;
        this.writeTaggedValues();
    }

    public void writeXMI11Element() throws Exception {
        Object object;
        super.writeXMI11Element();
        Diagnostic.print("Writing package " + this.myElement.getPropertyValue("$name"));
        if (!this.myRoseExport && XMI11Export.isExported(this.myElement)) {
            return;
        }
        XMI11Export.addExportedElement(this.myElement, this.myID);
        XMI11Export.createCollaboration();
        XMI11Export.createInteraction(this.myWriter);
        XMI11Export.createStateMachine(this.myID);
        String string = this.myElement.getPropertyValue("$name");
        boolean bl = this.myElement.hasPropertyValue("$metaclass", "Model");
        boolean bl2 = false;
        if (!bl) {
            this.myWriter.writeStartTag("UML", this.myName);
            this.myWriter.writeAttribute("xmi.id", this.myID);
            this.myWriter.writeAttribute("name", string, true);
            this.myWriter.writeAttribute("visibility", this.visibilityValue());
            this.myWriter.writeAttribute("isSpecification", this.isSpecificationValue());
            this.myWriter.writeAttribute("isAbstract", this.isAbstractValue(), true);
            this.writeStereotype();
            this.myWriter.writeCloseBrasket();
            if (XMI11Export.isUnisysExport()) {
                this.myWriter.writeStartTag("UML", "ModelElement.namespace", true);
                this.myWriter.writeStartTag("Foundation.Core.Namespace");
                this.myWriter.writeAttribute("xmi.idref", XMI11Export.getModelID(this.myElement));
                this.myWriter.writeCloseBrasket(true);
                this.myWriter.writeEndTag("UML", "ModelElement.namespace");
            }
            this.myWriter.writeStartTag("UML", "Namespace.ownedElement", true);
        }
        if ((this.myElement.hasPropertyValue("$metaclass", PACKAGE) || this.myElement.hasPropertyValue("$metaclass", "Model")) && (object = this.myElement) != null) {
            EntityEnumeration entityEnumeration = object.childEntities();
            while (entityEnumeration.hasMoreElements()) {
                Entity entity = entityEnumeration.next();
                if (entity.hasPropertyValue("$metaclass", PACKAGE) && !InterchangeUtils.getWizardData().isExportedPackage(entity)) continue;
                if (XMI11Export.isRoseSpecificExport()) {
                    if (this.myRoseExport) {
                        if (!entity.hasPropertyValue("$metaclass", "Component") && !entity.hasPropertyValue("$metaclass", "Subsystem")) continue;
                        ElementWriter.writeElement(this.myWriter, entity, this.myDiagram);
                        continue;
                    }
                    if (entity.hasPropertyValue("$metaclass", "Component") || entity.hasPropertyValue("$metaclass", "Subsystem")) {
                        bl2 = true;
                        continue;
                    }
                    ElementWriter.writeElement(this.myWriter, entity, this.myDiagram);
                    continue;
                }
                ElementWriter.writeElement(this.myWriter, entity, this.myDiagram);
            }
        }
        XMI11Export.writeCurrentCollaboration();
        XMI11Export.writeCurrentStateMachine();
        if (!bl) {
            this.myWriter.writeEndTag("UML", "Namespace.ownedElement");
            this.myWriter.writeEndTag("UML", this.myName);
        }
        if (bl2) {
            object = new XMIPackage(this.myWriter, this.myElement, this.myDiagram);
            ((XMIPackage)object).setForRoseExport();
            ((XMIPackage)object).writeXMI11Element();
        }
    }

    public void setForRoseExport() {
        this.myRoseExport = true;
        this.myName = "Subsystem";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Entity createRwiElement(Entity entity) throws XMIException {
        if (entity.hasPropertyValue("$metaclass", "Model")) {
            if (!entity.canCreateChildEntity(PACKAGE, null)) throw new XMIException("Can_not_create_package_4");
            this.myElement = entity.createChildEntity(PACKAGE, null);
        } else {
            if (!entity.hasPropertyValue("$metaclass", PACKAGE)) throw new XMIException("xmi.import.error.cannot.create", PACKAGE);
            if (!entity.canCreateChildEntity(PACKAGE, null)) throw new XMIException("Can_not_create_sub_package_on__5", entity.getPropertyValue("$name"));
            this.myElement = entity.createChildEntity(PACKAGE, null);
        }
        if (this.myElement != null) {
            Diagnostic.print(this.myElement.getPropertyValue("$metaclass") + " '" + this.myElement.getPropertyValue("$name") + "' created successfully");
            return this.myElement;
        } else {
            Diagnostic.print("Failed to create Package");
        }
        return this.myElement;
    }

    public Entity setProperty(String string, String string2) throws XMIException {
        if (string == null || string.length() == 0 || string2 == null) {
            throw new XMIException("xmi.import.error.cannot.set.property", string);
        }
        if ("xmi.id".equals(string) && string2.length() != 0) {
            this.myID = string2;
            XMI11Import.addElement(string2, this.myElement);
        }
        if ("name".equals(string)) {
            Entity entity = this.myElement;
            this.myElement = XMIAbstractElement.setRwiName(this.myElement, string2);
            XMI11Import.replaceElement(entity, this.myElement);
        }
        return this.myElement;
    }
}

