/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.elements;

import com.togethersoft.selena.xmi.elements.XMIAbstractElement;
import com.togethersoft.selena.xmi.elements.XMIElementImpl;
import com.togethersoft.selena.xmi.elements.XMIParameter;
import com.togethersoft.selena.xmi.elements.XMITaggedValue;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.InterchangeUtils;
import com.togethersoft.selena.xmi.util.XMI11Export;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.enum.PropertyEnumeration;

public class XMIOperation
extends XMIElementImpl {
    public static final String RETURN = "Return";
    public static final String OPERATION = "Operation";
    private String myOperationName;
    private Entity myOperationParent;

    public XMIOperation() {
        this.myName = OPERATION;
    }

    public XMIOperation(XMLWriter xMLWriter, Entity entity) {
        super(xMLWriter, entity);
        this.myName = OPERATION;
        this.myID = XMI11Export.getElementID(this.myElement);
        this.writeDocumentation();
        this.writePersistence();
        this.writeAlias();
        this.writeTaggedValues();
    }

    public void writeXMI11Element() throws Exception {
        super.writeXMI11Element();
        this.myWriter.writeStartTag("UML", this.myName);
        this.myWriter.writeAttribute("xmi.id", this.myID);
        String string = this.myElement.getPropertyValue("$name");
        this.myWriter.writeAttribute("name", string, true);
        this.myWriter.writeAttribute("visibility", this.visibilityValue());
        this.myWriter.writeAttribute("isSpecification", this.isSpecificationValue(), true);
        this.myWriter.writeAttribute("isAbstract", this.isAbstractValue(), true);
        this.myWriter.writeAttribute("ownerScope", this.ownerScopeValue());
        String string2 = this.myElement.getPropertyValue("@semantics");
        if (string2 != null && string2.length() != 0) {
            this.myWriter.writeAttribute("specification", string2);
        }
        this.writeStereotype();
        this.myWriter.writeCloseBrasket();
        this.writeAdditionalProperties();
        this.myWriter.writeStartTag("UML", "BehavioralFeature.parameter", true);
        PropertyEnumeration propertyEnumeration = this.myElement.properties("$parameter");
        String string3 = null;
        String string4 = null;
        Entity entity = null;
        Property property = null;
        XMIParameter xMIParameter = null;
        PropertyMap propertyMap = null;
        String string5 = null;
        Model model = InterchangeUtils.getWizardData().getModel();
        while (propertyEnumeration.hasMoreElements()) {
            property = propertyEnumeration.next();
            propertyMap = property.getSubproperties();
            string3 = propertyMap.getPropertyValue("$name");
            string5 = propertyMap.getPropertyValue("$type");
            string4 = propertyMap.getPropertyValue("$typeReferencedElement");
            if (string4 != null) {
                entity = (Entity)model.findElement(ModelAccess.createUniqueName((String)string4));
            }
            xMIParameter = entity != null ? new XMIParameter(this.myWriter, string3, entity, "inout") : new XMIParameter(this.myWriter, string3, string5, "inout");
            xMIParameter.writeXMI11Element();
        }
        entity = null;
        string3 = string + '.' + RETURN;
        string5 = this.myElement.getPropertyValue("$returnType");
        string4 = this.myElement.getPropertyValue("$typeReferencedElement");
        if (string4 != null) {
            entity = (Entity)model.findElement(ModelAccess.createUniqueName((String)string4));
        }
        if (entity != null) {
            xMIParameter = new XMIParameter(this.myWriter, string3, entity, "return");
            xMIParameter.writeXMI11Element();
        } else if (string5 != null && string5.length() != 0) {
            xMIParameter = new XMIParameter(this.myWriter, string3, string5, "return");
            xMIParameter.writeXMI11Element();
        }
        this.myWriter.writeEndTag("UML", "BehavioralFeature.parameter");
        this.myWriter.writeEndTag("UML", this.myName);
    }

    public Entity createRwiElement(Entity entity) throws XMIException {
        return this.createRwiElement(entity, "defaultOperation");
    }

    public Entity createRwiElement(Entity entity, String string) throws XMIException {
        if (!(entity instanceof Entity)) {
            String string2 = entity.getPropertyValue("$metaclass");
            String string3 = entity.getPropertyValue("$name");
            throw new XMIException("xmi.import.error.cannot.create.in", OPERATION, string2, string3);
        }
        Entity entity2 = entity;
        if (entity2.isDeleted()) {
            System.out.println("Class deleted !!!");
        }
        if (!entity2.canCreateChildEntity(OPERATION, null)) {
            throw new XMIException("xmi.import.error.cannot.create", OPERATION);
        }
        this.myElement = entity2.createChildEntity(OPERATION, null);
        if (this.myElement == null) {
            this.myOperationParent = null;
            Diagnostic.print("Failed to create RwiElement");
            throw new XMIException("xmi.import.error.cannot.create", OPERATION);
        }
        this.myOperationParent = entity2;
        Diagnostic.print(this.myElement.getPropertyValue("$metaclass") + " '" + this.myElement.getPropertyValue("$name") + "' created successfully");
        return this.myElement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Entity setProperty(String string, String string2) throws XMIException {
        if (string == null || string.length() == 0 || string2 == null) {
            throw new XMIException("xmi.import.error.cannot.set.property", string);
        }
        if ("xmi.id".equals(string) && string2.length() != 0) {
            this.myID = string2;
            XMI11Import.addElement(string2, this.myElement);
        } else if ("visibility".equals(string)) {
            XMIAbstractElement.setVisibility(this.myElement, string2);
        } else if ("isAbstract".equals(string)) {
            XMIAbstractElement.setAbstract(this.myElement, string2);
        }
        if ("name".equals(string)) {
            Diagnostic.print("Setting operation name " + string2);
            super.setProperty(string, string2);
            this.myOperationName = string2;
            XMI11Import.addOperation(this.myElement, this.myOperationName);
            Entity entity = this.myOperationParent;
            if (entity == null) return this.myElement;
            Entity entity2 = null;
            String string3 = entity.getPropertyValue("$name");
            String string4 = entity.getPropertyValue("originalName");
            if (string2.equals(string3) || string2.equals(string4) || string2.equals("New")) {
                Diagnostic.print("Creating constructor");
                if (!this.myElement.canSetPropertyValue("$constructor", "true")) throw new XMIException("xmi.import.error.cannot.create.constructor.for", entity.getPropertyValue("$name"));
                this.myElement.setPropertyValue("$constructor", "true");
                return this.myElement;
            } else {
                if (!string2.equals('~' + string3) && !string2.equals('~' + string4)) return this.myElement;
                Diagnostic.print("Creating destructor");
                entity2 = this.myElement.cut();
                try {
                    this.myElement = this.createRwiElement(entity, "defaultDestructor");
                    if (this.myID == null) return this.myElement;
                    XMI11Import.addElement(this.myID, this.myElement);
                    return this.myElement;
                }
                catch (Exception exception) {
                    this.myElement = (Entity)entity.paste((Element)entity2, null, false);
                    XMI11Import.addElement(this.myID, this.myElement);
                    XMI11Import.addOperation(this.myElement, this.myOperationName);
                    throw new XMIException("xmi.import.error.cannot.create.destructor.for", entity.getPropertyValue("$name"));
                }
            }
        } else if ("specification".equals(string)) {
            if (!this.myElement.canSetPropertyValue("@semantics", string2)) return this.myElement;
            this.myElement.setPropertyValue("@semantics", string2);
            return this.myElement;
        } else if ("ownerScope".equals(string)) {
            this.setOwnerScope(string2);
            return this.myElement;
        } else if ("ownerScope".equals(string)) {
            this.setOwnerScope(string2);
            return this.myElement;
        } else {
            if (!"stereotype".equals(string)) return this.myElement;
            XMI11Import.addStereotypeSeeks(this.myID, string2);
        }
        return this.myElement;
    }

    public void addParameter(String string, String string2) throws XMIException {
        Diagnostic.print("Adding operation parameter " + string + " " + string2);
        String string3 = string2 + " " + string;
        if (!this.myElement.canAddProperty("$parameter", string3)) {
            throw new XMIException("Cannot_set_parameters__31", string3, this.myElement.getPropertyValue("$name"));
        }
        this.myElement.addProperty("$parameter", string3);
    }

    public void setParameters() throws XMIException {
    }

    protected void writeAdditionalProperties() {
        if (this.myElement == null) {
            return;
        }
        if (this.myElement.hasProperty("$native")) {
            XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "$native");
        }
        if (this.myElement.hasProperty("$synchronized")) {
            XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "$synchronized");
        }
        PropertyEnumeration propertyEnumeration = this.myElement.properties("$throws");
        while (propertyEnumeration.hasMoreElements()) {
            Entity entity;
            Property property = propertyEnumeration.next();
            String string = property.getValue();
            PropertyMap propertyMap = property.getSubproperties();
            String string2 = propertyMap.getPropertyValue("$referencedElement");
            if (string2 != null && (entity = (Entity)this.myElement.getModel().findElement(ModelAccess.createUniqueName((String)string2))) != null) {
                string = entity.getPropertyValue("$fullName");
            }
            if (string == null || string.length() == 0) continue;
            XMI11Export.addTaggedValue(new XMITaggedValue(this.myWriter, this.myID, "$throws", string));
        }
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "@preconditions");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "@postconditions");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "@input");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "@output");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "@time");
    }
}

