/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.elements;

import com.togethersoft.selena.xmi.elements.XMIAbstractElement;
import com.togethersoft.selena.xmi.elements.XMIAssociation;
import com.togethersoft.selena.xmi.elements.XMIClass;
import com.togethersoft.selena.xmi.elements.XMIClassifierRole;
import com.togethersoft.selena.xmi.elements.XMIComments;
import com.togethersoft.selena.xmi.elements.XMIComponent;
import com.togethersoft.selena.xmi.elements.XMIDiagram;
import com.togethersoft.selena.xmi.elements.XMIElement;
import com.togethersoft.selena.xmi.elements.XMIElementImpl;
import com.togethersoft.selena.xmi.elements.XMIStereotype;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.ElementWriter;
import com.togethersoft.selena.xmi.util.XMI11Export;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.enum.EntityEnumeration;
import java.util.Vector;

public class XMINode
extends XMIElementImpl {
    public static final String NODE = "Node";
    public static final String NODE_DEPLOYEDCOMPONENT = "Node.deployedComponent";
    private Vector myComponents;
    private Vector myDependencyLinks;
    private Vector myAssociationLinks;
    private Vector myConnections;
    private Vector myObjects;
    private Vector myNodes;
    private Vector myInterfaces;

    public XMINode() {
        this.myName = NODE;
    }

    public XMINode(XMLWriter xMLWriter, Entity entity, XMIDiagram xMIDiagram) {
        super(xMLWriter, entity, xMIDiagram);
        this.myDiagram = xMIDiagram;
        this.myName = NODE;
        this.myID = XMI11Export.getModelID(this.myElement);
        if (XMI11Export.isRoseSpecificExport()) {
            XMI11Export.addStereotype(new XMIStereotype(this.myWriter, "Device", NODE, this.myID));
        }
        this.myComponents = new Vector();
        this.myObjects = new Vector();
        this.myNodes = new Vector();
        this.myInterfaces = new Vector();
        this.myConnections = new Vector();
        this.myDependencyLinks = new Vector();
        this.myAssociationLinks = new Vector();
        this.writeTaggedValues();
    }

    public void writeXMI11Element() throws Exception {
        super.writeXMI11Element();
        if (XMI11Export.isExported(this.myElement)) {
            return;
        }
        XMI11Export.addExportedElement(this.myElement, this.myID);
        String string = this.myElement.getPropertyValue("$name");
        Diagnostic.print("Writing out " + this.myName + ", name = " + string + ", id = " + this.myID);
        this.myWriter.writeStartTag("UML", this.myName);
        this.myWriter.writeAttribute("xmi.id", this.myID);
        this.myWriter.writeAttribute("name", string, true);
        this.myWriter.writeAttribute("visibility", this.visibilityValue());
        this.myWriter.writeAttribute("isSpecification", this.isSpecificationValue());
        this.writeStereotype();
        if (this.myElement.childEntities().hasMoreElements()) {
            this.myWriter.writeCloseBrasket();
            this.writeXMI11Content();
            this.myWriter.writeEndTag("UML", this.myName);
            int n = 0;
            while (n < this.myDependencyLinks.size()) {
                ElementWriter.writeElement(this.myWriter, (Entity)this.myDependencyLinks.elementAt(n), this.myDiagram);
                ++n;
            }
            int n2 = 0;
            while (n2 < this.myAssociationLinks.size()) {
                ElementWriter.writeElement(this.myWriter, (Entity)this.myAssociationLinks.elementAt(n2), this.myDiagram);
                ++n2;
            }
        } else {
            this.myWriter.writeCloseBrasket(true);
        }
    }

    public Entity createRwiElement(Entity entity) throws XMIException {
        if (entity == null) {
            throw new XMIException("xmi.import.error.cannot.create", NODE);
        }
        if (!entity.canCreateChildEntity(NODE, null)) {
            throw new XMIException("xmi.import.error.cannot.create", this.myName);
        }
        this.myElement = entity.createChildEntity(NODE, null);
        if (this.myElement != null) {
            Diagnostic.print(this.myElement.getPropertyValue("$metaclass") + " '" + this.myElement.getPropertyValue("$name") + "' created successfully");
        } else {
            Diagnostic.print("Failed to create RwiElement");
        }
        return this.myElement;
    }

    public Entity setProperty(String string, String string2) throws XMIException {
        if (string == null || string.length() == 0 || string2 == null) {
            throw new XMIException("xmi.import.error.cannot.set.property", string);
        }
        if ("xmi.id".equals(string) && string2.length() != 0) {
            this.myID = string2;
            XMI11Import.addElement(string2, this.myElement);
        }
        if ("name".equals(string)) {
            Entity entity = this.myElement;
            this.myElement = XMIAbstractElement.setRwiName(this.myElement, string2);
            XMI11Import.replaceElement(entity, this.myElement);
        }
        return this.myElement;
    }

    protected void writeXMI11Content() throws Exception {
        int n;
        this.collectElements();
        if (!this.myComponents.isEmpty()) {
            this.myWriter.writeStartTag("UML", NODE_DEPLOYEDCOMPONENT, true);
            n = 0;
            while (n < this.myComponents.size()) {
                ((XMIComponent)this.myComponents.elementAt(n)).writeXMI11Element();
                ++n;
            }
            this.myWriter.writeEndTag("UML", NODE_DEPLOYEDCOMPONENT);
        }
        if (!(this.myObjects.isEmpty() && this.myDependencyLinks.isEmpty() && this.myConnections.isEmpty() && this.myNodes.isEmpty() && this.myInterfaces.isEmpty())) {
            int n2;
            this.myWriter.writeStartTag("UML", "Namespace.ownedElement", true);
            n = 0;
            while (n < this.myConnections.size()) {
                ((XMIComments)this.myConnections.elementAt(n)).writeXMI11Element();
                ++n;
            }
            if (XMI11Export.isUnisysExport()) {
                n2 = 0;
                while (n2 < this.myDependencyLinks.size()) {
                    Entity entity = (Entity)this.myDependencyLinks.elementAt(n2);
                    this.myWriter.writeStartTag("UML", "ModelElement.supplierDependency", true);
                    this.myWriter.writeStartTag("Foundation.Core.Dependency");
                    this.myWriter.writeAttribute("xmi.idref", XMI11Export.getModelID(entity));
                    this.myWriter.writeCloseBrasket(true);
                    this.myWriter.writeEndTag("UML", "ModelElement.supplierDependency");
                    ++n2;
                }
            }
            n2 = 0;
            while (n2 < this.myNodes.size()) {
                ((XMIElement)this.myNodes.elementAt(n2)).writeXMI11Element();
                ++n2;
            }
            int n3 = 0;
            while (n3 < this.myInterfaces.size()) {
                ((XMIElement)this.myInterfaces.elementAt(n3)).writeXMI11Element();
                ++n3;
            }
            int n4 = 0;
            while (n4 < this.myObjects.size()) {
                ((XMIClassifierRole)this.myObjects.elementAt(n4)).writeXMI11Element();
                ++n4;
            }
            this.myWriter.writeEndTag("UML", "Namespace.ownedElement");
        }
    }

    protected void collectElements() throws Exception {
        EntityEnumeration entityEnumeration = this.myElement.childEntities();
        while (entityEnumeration.hasMoreElements()) {
            Entity entity = entityEnumeration.next();
            String string = entity.getPropertyValue("$metaclass");
            Diagnostic.print("Node child = " + string);
            if ("Component".equals(string)) {
                this.myComponents.add(new XMIComponent(this.myWriter, entity, this.myDiagram));
                continue;
            }
            if (NODE.equals(string)) {
                this.myNodes.add(new XMINode(this.myWriter, entity, this.myDiagram));
                continue;
            }
            if ("Class".equals(string) && entity.hasProperty("$interface")) {
                this.myInterfaces.add(new XMIClass(this.myWriter, entity, this.myDiagram));
                continue;
            }
            if ("Object".equals(string)) {
                this.myObjects.add(new XMIClassifierRole(this.myWriter, entity, this.myDiagram));
                continue;
            }
            if ("Dependency Link".equals(string)) {
                this.myDependencyLinks.add(entity);
                continue;
            }
            if ("Association Link".equals(string)) {
                this.myAssociationLinks.add(entity);
                continue;
            }
            if (!(entity instanceof Entity)) continue;
            if (XMI11Export.isRoseSpecificExport()) {
                XMI11Export.addIncompatibleElement(entity, null);
                continue;
            }
            XMI11Export.addAssociation(new XMIAssociation(this.myWriter, entity, this.myDiagram));
        }
    }
}

