/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.elements;

import com.togethersoft.selena.xmi.elements.XMIAbstractElement;
import com.togethersoft.selena.xmi.elements.XMIElement;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.model.elements.Entity;

public class XMIMultiplicity
extends XMIAbstractElement {
    public static final String MULTIPLICITY = "Multiplicity";
    public static final String MULTIPLICITY_RANGE = "Multiplicity.range";
    public static final String MULTIPLICITYRANGE = "MultiplicityRange";
    public static final String LOWER = "lower";
    public static final String UPPER = "upper";
    public static final String ZERO_OR_ONE = "0..1";
    public static final String ONE = "1";
    public static final String ZERO_OR_MORE = "0..*";
    public static final String ONE_OR_MORE = "1..*";
    public static final String NONE = "0";
    public static final String MORE = "-1";
    private String myLower;
    private String myUpper;

    public XMIMultiplicity() {
    }

    public XMIMultiplicity(XMLWriter xMLWriter, String string) {
        super(xMLWriter);
        this.myName = MULTIPLICITY;
        if (ZERO_OR_ONE.equals(string)) {
            this.myLower = NONE;
            this.myUpper = ONE;
        } else if (ONE.equals(string)) {
            this.myLower = ONE;
            this.myUpper = ONE;
        } else if (ZERO_OR_MORE.equals(string)) {
            this.myLower = NONE;
            this.myUpper = MORE;
        } else if (ONE_OR_MORE.equals(string)) {
            this.myLower = ONE;
            this.myUpper = MORE;
        } else if (NONE.equals(string)) {
            this.myLower = NONE;
            this.myUpper = NONE;
        }
    }

    public void writeXMI11Element() throws Exception {
        this.myWriter.writeStartTag("UML", this.myName);
        if (this.myLower != null && this.myUpper != null) {
            this.myWriter.writeCloseBrasket();
            this.myWriter.writeStartTag("UML", MULTIPLICITY_RANGE, true);
            this.myWriter.writeStartTag("UML", MULTIPLICITYRANGE);
            this.myWriter.writeAttribute(LOWER, this.myLower);
            this.myWriter.writeAttribute(UPPER, this.myUpper);
            this.myWriter.writeCloseBrasket(true);
            this.myWriter.writeEndTag("UML", MULTIPLICITY_RANGE);
            this.myWriter.writeEndTag("UML", this.myName);
        } else {
            this.myWriter.writeCloseBrasket(true);
        }
    }

    public static void setMultiplicity(XMIElement xMIElement, String string, String string2) throws XMIException {
        ((XMIAbstractElement)xMIElement).setMultiplicity(string, string2);
    }

    public static void setSupplierCardinality(Entity entity, String string) throws XMIException {
        if (entity == null || !entity.canSetPropertyValue("@supplierCardinality", string)) {
            throw new XMIException("xmi.import.error.cannot.set.property2", "@supplierCardinality", string);
        }
        entity.setPropertyValue("@supplierCardinality", string);
    }

    public static void setClientCardinality(Entity entity, String string) throws XMIException {
        if (entity == null || !entity.canSetPropertyValue("@clientCardinality", string)) {
            throw new XMIException("xmi.import.error.cannot.set.property2", "@clientCardinality", string);
        }
        entity.setPropertyValue("@clientCardinality", string);
    }

    public static String toRwiPropertyValue(String string, String string2) throws XMIException {
        if (ONE.equals(string) && ONE.equals(string2)) {
            return ONE;
        }
        if (NONE.equals(string) && ONE.equals(string2)) {
            return ZERO_OR_ONE;
        }
        if (NONE.equals(string) && MORE.equals(string2)) {
            return ZERO_OR_MORE;
        }
        if (ONE.equals(string) && MORE.equals(string2)) {
            return ONE_OR_MORE;
        }
        if (NONE.equals(string) && NONE.equals(string2)) {
            return NONE;
        }
        throw new XMIException("xmi.import.error.incorrect.multiplicity", "lower = '" + string + "' " + UPPER + " = '" + string2 + "'");
    }

    public String getRwiPropertyValue() throws XMIException {
        return XMIMultiplicity.toRwiPropertyValue(this.myLower, this.myUpper);
    }

    public Entity setProperty(String string, String string2) throws XMIException {
        Diagnostic.print("Multiplicity, setting property " + string + " = '" + string2 + "'");
        if (LOWER.equals(string)) {
            this.myLower = string2;
        } else if (UPPER.equals(string)) {
            this.myUpper = string2;
        }
        return null;
    }

    public static boolean isValidCardinality(String string) {
        return ZERO_OR_ONE.equals(string) || ONE.equals(string) || ZERO_OR_MORE.equals(string) || ONE_OR_MORE.equals(string) || MORE.equals(string) || NONE.equals(string);
    }
}

