/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.elements;

import com.togethersoft.selena.xmi.elements.XMIAbstractElement;
import com.togethersoft.selena.xmi.elements.XMIAction;
import com.togethersoft.selena.xmi.elements.XMIDiagram;
import com.togethersoft.selena.xmi.elements.XMIElementImpl;
import com.togethersoft.selena.xmi.elements.XMIStereotype;
import com.togethersoft.selena.xmi.elements.XMITaggedValue;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.InterchangeUtils;
import com.togethersoft.selena.xmi.util.XMI11Export;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ElementEnumeration;
import com.tssap.selena.model.enum.EntityEnumeration;
import java.util.Enumeration;
import java.util.Vector;

public class XMIMessage
extends XMIElementImpl {
    public static final String MESSAGE = "Message";
    public static final String MESSAGE_SENDER = "Message.sender";
    public static final String MESSAGE_RECEIVER = "Message.receiver";
    public static final String MESSAGE_COMMUNICATIONCONNECTION = "Message.communicationConnection";
    public static final String MESSAGE_ACTION = "Message.action";
    public static final String STYLE_MESSAGE = "Message, SQN= ";
    public static final String SYNCHRONIZATION_SYNCHRONOUS = "synchronous";
    public static final String SYNCHRONIZATION_ASYNCHRONOUS = "asynchronous";
    public static final String SYNCHRONIZATION_BALKING = "balking";
    public static final String SYNCHRONIZATION_TIMEOUT = "timeout";
    public static final int ROLE_SENDER = 1;
    public static final int ROLE_RECEIVER = 2;
    public static final int ROLE_CONNECTION = 3;
    public static final int ROLE_ACTION = 4;
    private String myLabel;
    private String mySenderID;
    private String myReceiverID;
    private String myConnectionID;
    private String myActionID;
    private Entity myTargetRwiDiagram;

    public XMIMessage() {
        this.mySenderID = "";
        this.myReceiverID = "";
        this.myConnectionID = "";
        this.myActionID = "";
    }

    public XMIMessage(XMLWriter xMLWriter, Entity entity, XMIDiagram xMIDiagram, String string) {
        super(xMLWriter, entity, xMIDiagram);
        this.myName = MESSAGE;
        this.myID = XMI11Export.getModelID(entity);
        this.myConnectionID = string;
        this.writeTaggedValues();
    }

    private Entity getMessageOperation() {
        Entity entity = null;
        EntityEnumeration entityEnumeration = this.myElement.childEntities();
        while (entityEnumeration.hasMoreElements()) {
            ElementEnumeration elementEnumeration;
            Entity entity2 = entityEnumeration.next();
            if (!"Dependency Link".equals(entity2.getPropertyValue("$metaclass")) || !(elementEnumeration = entity2.participants("Supplier")).hasMoreElements()) continue;
            entity = (Entity)elementEnumeration.next();
            break;
        }
        return entity;
    }

    private void setMessageOperation(Entity entity) {
        if (this.myElement.canCreateChildEntity("Dependency Link", null)) {
            Entity entity2 = this.myElement.createChildEntity("Dependency Link", null);
            entity2.setParticipant("Supplier", null, (Element)entity);
            entity2.setParticipant("Client", null, (Element)this.myElement);
            Diagnostic.print("setMessageOperation " + entity.getPropertyValue("$name"));
        } else {
            Diagnostic.print("Can't set operation");
        }
    }

    public void writeXMI11Element() throws Exception {
        String string;
        Entity entity;
        Enumeration enumeration;
        Object object;
        Object object2;
        Entity entity2;
        Object object3;
        super.writeXMI11Element();
        String string2 = this.myElement.getPropertyValue("$name");
        Diagnostic.print("Writing out " + this.myName + ", name = " + string2 + ", id = " + this.myID);
        Entity entity3 = this.myElement;
        if (this.myParent != null) {
            entity3 = this.myParent;
        }
        ElementEnumeration elementEnumeration = entity3.participants("Client");
        ElementEnumeration elementEnumeration2 = entity3.participants("Supplier");
        Entity entity4 = (Entity)(elementEnumeration2.hasMoreElements() ? elementEnumeration2.next() : null);
        this.mySenderID = XMI11Export.getModelID(elementEnumeration.hasMoreElements() ? elementEnumeration.next() : null);
        this.myReceiverID = XMI11Export.getModelID(entity4);
        this.myWriter.writeStartTag("UML", this.myName);
        this.myWriter.writeAttribute("xmi.id", this.myID);
        string2 = this.myElement.getPropertyValue("$name");
        Model model = InterchangeUtils.getWizardData().getModel();
        if ((string2 == null || string2.length() == 0) && (object3 = this.getMessageOperation()) != null) {
            string2 = object3.getPropertyValue("$name");
        }
        this.myWriter.writeAttribute("name", string2, true);
        this.myWriter.writeAttribute("visibility", this.visibilityValue());
        this.myWriter.writeAttribute("isSpecification", this.isSpecificationValue());
        if (!XMI11Export.isUnisysExport()) {
            this.myWriter.writeAttribute("sender", this.mySenderID);
            this.myWriter.writeAttribute("receiver", this.myReceiverID);
        }
        this.writeStereotype();
        this.myWriter.writeCloseBrasket();
        if (XMI11Export.isUnisysExport()) {
            this.myWriter.writeStartTag("UML", MESSAGE_SENDER, true);
            this.myWriter.writeStartTag("Behavioral_Elements.Collaborations.ClassifierRole");
            this.myWriter.writeAttribute("xmi.idref", this.mySenderID);
            this.myWriter.writeCloseBrasket(true);
            this.myWriter.writeEndTag("UML", MESSAGE_SENDER);
            this.myWriter.writeStartTag("UML", MESSAGE_RECEIVER, true);
            this.myWriter.writeStartTag("Behavioral_Elements.Collaborations.ClassifierRole");
            this.myWriter.writeAttribute("xmi.idref", this.myReceiverID);
            this.myWriter.writeCloseBrasket(true);
            this.myWriter.writeEndTag("UML", MESSAGE_RECEIVER);
        }
        if ((entity2 = this.getMessageOperation()) != null) {
            this.myWriter.writeStartTag("UML", MESSAGE_ACTION, true);
            object2 = new XMIAction(this.myWriter, entity2);
            XMI11Export.addAction((XMIAction)object2);
            object3 = ((XMIAbstractElement)object2).getId();
            if (XMI11Export.isUnisysExport()) {
                this.myWriter.writeStartTag("Behavioral_Elements.Common_Behavior.Action");
                this.myWriter.writeAttribute("xmi.idref", (String)object3);
                this.myWriter.writeCloseBrasket(true);
            } else {
                this.myWriter.writeStartTag("UML", "Action");
                this.myWriter.writeAttribute("xmi.idref", (String)object3);
                this.myWriter.writeCloseBrasket(true);
            }
            this.myWriter.writeEndTag("UML", MESSAGE_ACTION);
        }
        object2 = this.myElement.getPropertyValue("controlFlowType");
        String string3 = null;
        if (SYNCHRONIZATION_SYNCHRONOUS.equals(object2)) {
            string3 = SYNCHRONIZATION_SYNCHRONOUS;
        }
        if (SYNCHRONIZATION_ASYNCHRONOUS.equals(object2)) {
            string3 = SYNCHRONIZATION_ASYNCHRONOUS;
        }
        if ("nowait".equals(object2)) {
            string3 = SYNCHRONIZATION_TIMEOUT;
        }
        if ("wait".equals(object2)) {
            string3 = SYNCHRONIZATION_BALKING;
        }
        if (string3 != null) {
            XMI11Export.addStereotype(new XMIStereotype(this.myWriter, string3, MESSAGE, this.myID));
        }
        this.myWriter.writeEndTag("UML", this.myName);
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "@label");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "arguments");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "condition");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "iteration");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "return");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "destruction");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "creation");
        if (XMI11Export.isTCCSpecificExport()) {
            if (this.myElement.hasProperty("destruction")) {
                object = new XMITaggedValue(this.myWriter, this.myReceiverID, "destruction", Boolean.TRUE.toString());
                ((XMITaggedValue)object).setTag("destroyed");
                XMI11Export.addTaggedValue((XMITaggedValue)object);
            }
            if (this.myElement.hasProperty("creation")) {
                object = new XMITaggedValue(this.myWriter, this.myReceiverID, "creation", Boolean.TRUE.toString());
                ((XMITaggedValue)object).setTag("created");
                XMI11Export.addTaggedValue((XMITaggedValue)object);
            }
        }
        if ((object = this.myElement.getPropertyValue("branchingAnchorUid")) != null && ((String)object).length() != 0) {
            enumeration = ModelAccess.createUniqueName((String)object);
            entity = (Entity)this.myElement.getModel().findElement((UniqueName)enumeration);
            if (entity != null && (string = XMI11Export.getModelID(entity)) != null && string.length() != 0) {
                XMI11Export.addTaggedValue(new XMITaggedValue(this.myWriter, this.myID, "branchingAnchorUid", string));
            }
        }
        enumeration = this.returnLinks();
        while (enumeration.hasMoreElements()) {
            entity = (Entity)enumeration.nextElement();
            string = entity.getPropertyValue("normalizedIndex");
            if (string == null) {
                string = "";
            }
            XMITaggedValue xMITaggedValue = new XMITaggedValue(this.myWriter, this.myID, "showReturnArrow", string);
            XMI11Export.addTaggedValue(xMITaggedValue);
            XMI11Export.addTaggedValue((Element)entity, this.myWriter, this.myID, "return");
        }
    }

    public Entity setProperty(String string, String string2) throws XMIException {
        if (string2 == null) {
            return this.myElement;
        }
        if ("xmi.id".equals(string) && string2.length() != 0) {
            this.myID = string2;
            XMI11Import.addMessage(this.myID, this);
        } else if ("name".equals(string)) {
            this.myLabel = string2;
        } else if ("sender".equals(string)) {
            this.setSender(string2);
        } else if ("receiver".equals(string)) {
            this.setReceiver(string2);
        } else if ("action".equals(string)) {
            this.setAction(string2);
        }
        return this.myElement;
    }

    public void setSender(String string) {
        this.mySenderID = string;
    }

    public void setReceiver(String string) {
        this.myReceiverID = string;
    }

    public void setCommunicationConnection(String string) {
        this.myConnectionID = string;
    }

    public void setAction(String string) {
        this.myActionID = string;
    }

    public void setReference(int n, String string) throws XMIException {
        Diagnostic.print("XMIMessage. Setting reference " + n + " : " + string);
        if (n == 1) {
            this.setSender(string);
        } else if (n == 2) {
            this.setReceiver(string);
        } else if (n == 3) {
            this.setCommunicationConnection(string);
        } else if (n == 4) {
            this.setAction(string);
        }
        Diagnostic.print("XMIMessage. Sender = " + this.mySenderID + " receiver = " + this.myReceiverID + " connection = " + this.myConnectionID + " action = " + this.myActionID);
    }

    private void createMessage(Entity entity, Entity entity2) {
        Entity entity3 = null;
        if (entity.canCreateChildEntity("Message Link", null)) {
            entity3 = entity.createChildEntity("Message Link", null);
            entity3.setParticipant("Client", null, (Element)entity);
            entity3.setParticipant("Supplier", null, (Element)entity2);
            Entity entity4 = entity2.createChildEntity("Activation", null);
            XMI11Import.storeUINReferences(entity3, new Object[]{entity4, "messageUid"});
            XMI11Import.storeUINReferences(entity4, new Object[]{entity3, "activationUid"});
        }
        this.myElement = entity3;
    }

    public Entity createRwiElement() throws XMIException {
        String string;
        Object object;
        XMIStereotype xMIStereotype;
        Diagnostic.print("Creating message link from " + this.mySenderID + " to " + this.myReceiverID);
        Entity entity = XMI11Import.getElement(this.mySenderID);
        if (entity == null) {
            throw new XMIException("xmi.import.error.cannot.find.message.sender", this.mySenderID, this.myLabel);
        }
        Entity entity2 = XMI11Import.getElement(this.myReceiverID);
        if (entity2 == null) {
            throw new XMIException("xmi.import.error.cannot.find.message.receiver", this.myReceiverID, this.myLabel);
        }
        String string2 = entity.getPropertyValue("$metaclass");
        String string3 = entity.getPropertyValue("$name");
        String string4 = entity2.getPropertyValue("$metaclass");
        String string5 = entity2.getPropertyValue("$name");
        this.createMessage(entity, entity2);
        if (this.myLabel != null && this.myLabel.length() != 0 && this.myElement.canSetPropertyValue("$name", this.myLabel)) {
            xMIStereotype = this.myElement.setPropertyValue("$name", this.myLabel);
        }
        if ((xMIStereotype = XMI11Import.getStereotype(this.myID)) != null) {
            object = xMIStereotype.getName();
            string = xMIStereotype.getBaseClass();
            if (MESSAGE.equals(string)) {
                String string6 = null;
                if (SYNCHRONIZATION_SYNCHRONOUS.equals(object)) {
                    string6 = SYNCHRONIZATION_SYNCHRONOUS;
                }
                if (SYNCHRONIZATION_ASYNCHRONOUS.equals(object)) {
                    string6 = SYNCHRONIZATION_ASYNCHRONOUS;
                }
                if (SYNCHRONIZATION_TIMEOUT.equals(object)) {
                    string6 = "nowait";
                }
                if (SYNCHRONIZATION_BALKING.equals(object)) {
                    string6 = "wait";
                }
                if (string6 != null) {
                    this.myElement.setPropertyValue("controlFlowType", string6);
                    XMI11Import.removeStereotype(this.myID);
                }
            }
        }
        Diagnostic.print("Setting operation");
        object = XMI11Import.getAction(this.myActionID);
        if (object != null) {
            string = ((XMIAction)object).getOperation();
            if (string == null) {
                string = this.findOperation(((XMIAction)object).getName());
            }
            if (string != null) {
                this.setMessageOperation((Entity)string);
            } else {
                Diagnostic.print("xmiAction.getOperation() == null ");
            }
        } else {
            Diagnostic.print("Action null");
        }
        if (this.myElement != null) {
            XMI11Import.addElement(this.myID, this.myElement);
            Diagnostic.print(this.myElement.getPropertyValue("$metaclass") + " '" + this.myElement.getPropertyValue("$name") + "' created successfully");
        } else {
            Diagnostic.print("Failed to create RwiElement");
        }
        if (this.myTargetRwiDiagram != null) {
            InterchangeUtils.addReference(this.myElement, this.myTargetRwiDiagram);
        }
        return this.myElement;
    }

    private Entity findOperation(String string) {
        Diagnostic.print("Try to find operation " + string);
        if (string == null || string.length() == 0 || string.indexOf(46) == -1) {
            return null;
        }
        int n = string.indexOf(35);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        int n2 = string2.lastIndexOf(46);
        if (n2 + 1 == string2.length()) {
            return null;
        }
        String string4 = string2.substring(0, n2);
        String string5 = string2.substring(n2 + 1);
        Diagnostic.print("Name: " + string2 + " Class name: " + string4 + " Operation: " + string5 + " Signature: " + string3);
        Entity entity = null;
        UniqueName uniqueName = NameUtil.getTypeUniqueName((String)"bin", (String)string4);
        if (uniqueName != null) {
            entity = (Entity)this.myElement.getModel().findElement(uniqueName);
        }
        if (entity == null && (uniqueName = NameUtil.getTypeUniqueName((String)"ref", (String)string4)) != null) {
            entity = (Entity)this.myElement.getModel().findElement(uniqueName);
        }
        if (entity == null && (uniqueName = NameUtil.getTypeUniqueName((String)"src", (String)string4)) != null) {
            entity = (Entity)this.myElement.getModel().findElement(uniqueName);
        }
        if (entity == null) {
            Diagnostic.print("Can't find class " + string4);
            return null;
        }
        Entity entity2 = null;
        EntityEnumeration entityEnumeration = entity.childEntities();
        while (entityEnumeration.hasMoreElements()) {
            Entity entity3 = entityEnumeration.next();
            if (!entity3.hasPropertyValue("$metaclass", "Operation")) continue;
            String string6 = entity3.getPropertyValue("$memberSignature");
            Diagnostic.print("++ Operation: " + entity3.getPropertyValue("$name") + " : " + string6);
            if (string6 == null || !string6.equals(string3)) continue;
            entity2 = entity3;
            break;
        }
        Diagnostic.print("Operation: " + entity2);
        return entity2;
    }

    public void setTargetDiagram(Entity entity) {
        this.myTargetRwiDiagram = entity;
    }

    private Enumeration returnLinks() {
        Entity entity;
        Vector<Entity> vector = new Vector<Entity>();
        String string = this.myElement.getPropertyValue("activationUid");
        if (string != null && (entity = (Entity)this.myElement.getModel().findElement(ModelAccess.createUniqueName((String)string))) != null) {
            EntityEnumeration entityEnumeration = entity.childEntities();
            while (entityEnumeration.hasMoreElements()) {
                Entity entity2 = entityEnumeration.next();
                if (!"Return Link".equals(entity2.getPropertyValue("$metaclass"))) continue;
                vector.add(entity2);
            }
        }
        return vector.elements();
    }
}

