/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.elements;

import com.togethersoft.selena.xmi.elements.XMIAbstractElement;
import com.togethersoft.selena.xmi.elements.XMIDiagram;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.XMI11Export;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.model.elements.Entity;

public class XMIInteraction
extends XMIAbstractElement {
    public static final String INTERACTION = "Interaction";
    public static final String INTERACTION_MESSAGE = "Interaction.message";

    public XMIInteraction(Entity entity) {
        this.myParent = entity;
    }

    public XMIInteraction(XMLWriter xMLWriter, XMIDiagram xMIDiagram) {
        super(xMLWriter, xMIDiagram);
        this.myName = INTERACTION;
        this.myID = XMI11Export.getModelID(this);
    }

    public XMIInteraction(XMLWriter xMLWriter) {
        super(xMLWriter, null);
        this.myName = INTERACTION;
        this.myID = XMI11Export.getModelID(this);
    }

    public void writeXMI11Element() throws Exception {
        String string = "{Logical View}";
        if (this.myDiagram != null) {
            string = string + this.myDiagram.getDiagramName();
        }
        Diagnostic.print("Writing out " + this.myName + ", name = " + string + ", id = " + this.myID);
        this.myWriter.writeStartTag("UML", this.myName);
        this.myWriter.writeAttribute("xmi.id", this.myID);
        this.myWriter.writeAttribute("name", string, true);
        this.myWriter.writeAttribute("visibility", "public");
        this.myWriter.writeAttribute("isSpecification", "false");
        this.myWriter.writeCloseBrasket();
        this.writeXMI11Content();
        this.myWriter.writeEndTag("UML", this.myName);
    }

    public void writeXMI11Content() throws Exception {
        if (this.myDiagram == null) {
            this.myWriter.writeStartTag("UML", INTERACTION_MESSAGE, true);
            XMI11Export.getCurrentCollaboration().getMessages().write(this.myWriter);
            this.myWriter.writeEndTag("UML", INTERACTION_MESSAGE);
        } else if (!this.myDiagram.getMessages().isEmpty()) {
            this.myWriter.writeStartTag("UML", INTERACTION_MESSAGE, true);
            this.myDiagram.getMessages().write(this.myWriter);
            this.myWriter.writeEndTag("UML", INTERACTION_MESSAGE);
        }
    }

    public Entity setProperty(String string, String string2) throws XMIException {
        if (string == null || string.length() == 0 || string2 == null) {
            throw new XMIException("xmi.import.error.cannot.set.property", string);
        }
        if ("xmi.id".equals(string) && string2.length() != 0) {
            this.myID = string2;
            XMI11Import.addXMIElement(string2, this);
        }
        return null;
    }
}

