/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.elements;

import com.togethersoft.selena.xmi.elements.XMIElementImpl;
import com.togethersoft.selena.xmi.elements.XMINotInProjectElement;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.XMI11Export;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.enum.ElementEnumeration;

public class XMIGeneralization
extends XMIElementImpl {
    public static final String GENERALIZATION = "Generalization";
    public static final String GENERALIZATION_PARENT = "Generalization.parent";
    public static final String GENERALIZATION_CHILD = "Generalization.child";
    public static final String GENERALIZABLEELEMENT = "GeneralizableElement";
    public static final short ROLE_PARENT = 1;
    public static final short ROLE_CHILD = 2;
    private String myParentID;
    private String myChildID;
    private String myDiscriminator;
    private short myCurrentRole;
    private boolean myRoleAllowed;

    public XMIGeneralization() {
        this.myCurrentRole = 0;
        this.myRoleAllowed = false;
    }

    public XMIGeneralization(XMLWriter xMLWriter, Entity entity) {
        super(xMLWriter, entity);
        this.myName = GENERALIZATION;
        this.myID = XMI11Export.getModelID(this.myElement);
        this.myDiscriminator = "";
        this.myVisibility = "public";
        this.writeTaggedValues();
    }

    public void writeXMI11Element() throws Exception {
        super.writeXMI11Element();
        Entity entity = this.myElement;
        Entity entity2 = null;
        Entity entity3 = null;
        ElementEnumeration elementEnumeration = entity.participants("Supplier");
        ElementEnumeration elementEnumeration2 = entity.participants("Client");
        if (elementEnumeration.hasMoreElements()) {
            entity2 = (Entity)elementEnumeration.next();
        }
        if (elementEnumeration2.hasMoreElements()) {
            entity3 = (Entity)elementEnumeration2.next();
        }
        if (!this.isRoseCompatible(entity2) || !this.isRoseCompatible(entity3)) {
            return;
        }
        this.myWriter.writeStartTag("UML", this.myName);
        this.myWriter.writeAttribute("xmi.id", this.myID);
        this.myWriter.writeAttribute("name", "", true);
        this.myWriter.writeAttribute("visibility", this.myVisibility);
        this.myWriter.writeAttribute("isSpecification", "false");
        this.myWriter.writeAttribute("discriminator", this.myDiscriminator, true);
        this.writeStereotype();
        this.myWriter.writeCloseBrasket();
        if (!XMI11Export.isInProject(entity2)) {
            XMI11Export.addOutOfScopeElement(entity2, XMI11Export.getElementID(entity2));
        }
        if (!XMI11Export.isInProject(entity3)) {
            XMI11Export.addOutOfScopeElement(entity3, XMI11Export.getElementID(entity3));
        }
        this.myWriter.writeStartTag("UML", GENERALIZATION_CHILD, true);
        if (XMI11Export.isUnisysExport()) {
            this.myWriter.writeStartTag("Foundation.Core.GeneralizableElement");
            this.myWriter.writeAttribute("xmi.idref", XMI11Export.getElementID(entity3));
            this.myWriter.writeCloseBrasket(true);
        } else {
            this.myWriter.writeStartTag("UML", GENERALIZABLEELEMENT);
            this.myWriter.writeAttribute("xmi.idref", XMI11Export.getElementID(entity3));
            this.myWriter.writeCloseBrasket(true);
        }
        this.myWriter.writeEndTag("UML", GENERALIZATION_CHILD);
        this.myWriter.writeStartTag("UML", GENERALIZATION_PARENT, true);
        if (XMI11Export.isUnisysExport()) {
            this.myWriter.writeStartTag("Foundation.Core.GeneralizableElement");
            this.myWriter.writeAttribute("xmi.idref", XMI11Export.getElementID(entity2));
            this.myWriter.writeCloseBrasket(true);
        } else {
            this.myWriter.writeStartTag("UML", GENERALIZABLEELEMENT);
            this.myWriter.writeAttribute("xmi.idref", XMI11Export.getElementID(entity2));
            this.myWriter.writeCloseBrasket(true);
        }
        this.myWriter.writeEndTag("UML", GENERALIZATION_PARENT);
        this.myWriter.writeEndTag("UML", this.myName);
    }

    public Entity createRwiElement() throws XMIException {
        Diagnostic.print("XMIGeneralization.createRwiElement(), id = " + this.myID + ", parent = " + this.myParentID + ", child = " + this.myChildID);
        String string = null;
        Entity entity = XMI11Import.getElement(this.myChildID);
        if (entity == null) {
            return null;
        }
        String string2 = entity.getPropertyValue("$metaclass");
        Entity entity2 = XMI11Import.getElement(this.myParentID);
        if (entity2 != null) {
            string = entity2.getPropertyValue("$name");
            Diagnostic.print(">>> " + string2);
            if ("Class".equals(string2)) {
                if (entity2.hasProperty("$interface") || entity2.hasPropertyValue("$metaclass", "Interface")) {
                    Diagnostic.print("Setting IMPLEMENTS * " + string + ":" + this.myParentID);
                    XMI11Import.addExtendsImplements(entity, "$implements", this.myParentID);
                } else {
                    Diagnostic.print("Setting EXTENDS * " + string);
                    XMI11Import.addExtendsImplements(entity, "$extends", this.myParentID);
                }
            } else if ("Interface".equals(string2)) {
                if (entity2.hasProperty("$interface") || entity2.hasPropertyValue("$metaclass", "Interface")) {
                    Diagnostic.print("Setting EXTENDS *** " + string);
                    XMI11Import.addExtendsImplements(entity, "$extends", this.myParentID);
                } else {
                    Diagnostic.print(">>> IMPOSSIBLE <<<");
                }
            } else {
                this.myElement = entity.createChildEntity("Generalization Link", null);
                this.myElement.setParticipant("Supplier", null, (Element)entity2);
                if (this.myElement != null) {
                    Diagnostic.print(this.myElement.getPropertyValue("$metaclass") + " '" + this.myElement.getPropertyValue("$name") + "' created successfully");
                } else {
                    Diagnostic.print("Fails...");
                }
            }
        } else {
            XMINotInProjectElement xMINotInProjectElement = XMI11Import.getNotInProjectElement(this.myParentID);
            if (xMINotInProjectElement == null) {
                return null;
            }
            string = xMINotInProjectElement.getElementName();
            String string3 = xMINotInProjectElement.getName();
            if ("Class".equals(string2)) {
                if ("Interface".equals(string3)) {
                    Diagnostic.print("Setting IMPLEMENTS ** " + string);
                    entity.addProperty("$implements", string);
                } else if ("Class".equals(string3)) {
                    Diagnostic.print("Setting EXTENDS ** " + string);
                    entity.setPropertyValue("$extends", string);
                } else {
                    Diagnostic.print(">>> IMPOSSIBLE <<<");
                }
            } else if ("Interface".equals(string2)) {
                if ("Interface".equals(string3)) {
                    Diagnostic.print("Setting EXTENDS **** " + string);
                    entity.setPropertyValue("$extends", string);
                } else {
                    Diagnostic.print(">>> IMPOSSIBLE <<<");
                }
            }
        }
        return this.myElement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Entity setProperty(String string, String string2) throws XMIException {
        if ("xmi.id".equals(string)) {
            this.myID = string2;
            XMI11Import.addGeneralization(this.myID, this);
            return this.myElement;
        } else if ("xmi.idref".equals(string)) {
            if (this.myRoleAllowed && this.myCurrentRole == 1) {
                this.setParent(string2);
                return this.myElement;
            } else {
                if (!this.myRoleAllowed || this.myCurrentRole != 2) throw new XMIException("xmi.import.error.cannot.set.generalization");
                this.setChild(string2);
            }
            return this.myElement;
        } else if ("parent".equals(string)) {
            this.setParent(string2);
            return this.myElement;
        } else {
            if (!"child".equals(string)) return this.myElement;
            this.setChild(string2);
        }
        return this.myElement;
    }

    public void setCurrentRole(short s) {
        this.myCurrentRole = 1 == s || 2 == s ? s : (short)0;
    }

    public void removeRole() {
        this.myCurrentRole = 0;
    }

    public void setAllowRole(boolean bl) {
        this.myRoleAllowed = this.myCurrentRole != 0 ? bl : false;
    }

    public void setParent(String string) {
        Diagnostic.print("XMIGeneralization.setParent, id = " + this.myID + " parent = " + string);
        this.myParentID = string;
    }

    public void setChild(String string) {
        Diagnostic.print("XMIGeneralization.setChild, id = " + this.myID + " child = " + string);
        this.myChildID = string;
    }

    public String getParentID() {
        return this.myParentID;
    }

    public String getChildID() {
        return this.myChildID;
    }
}

