/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.elements;

import com.togethersoft.selena.xmi.elements.XMIAbstractElement;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.model.elements.Entity;

public class XMIExpression
extends XMIAbstractElement {
    public static final String EXPRESSION = "Expression";
    public static final String ITERATIONEXPRESSION = "IterationExpression";
    public static final String OBJECTSETEXPRESSION = "ObjectSetExpression";
    public static final String ACTIONEXPRESSION = "ActionExpression";
    public static final String ARGLISTSEXPRESSION = "ArgListsExpression";
    public static final String BOOLEANEXPRESSION = "BooleanExpression";
    public static final String LANGUAGE = "language";
    public static final String BODY = "body";
    private String myLanguage;
    private String myBody;

    public XMIExpression(String string) {
        this.myName = string;
    }

    public XMIExpression(XMLWriter xMLWriter, String string) {
        super(xMLWriter);
        this.init(null, string, null);
    }

    public XMIExpression(XMLWriter xMLWriter, String string, String string2) {
        super(xMLWriter);
        this.init(null, string, string2);
    }

    public XMIExpression(XMLWriter xMLWriter, String string, String string2, String string3) {
        super(xMLWriter);
        this.init(string, string2, string3);
    }

    public void writeXMI11Element() throws Exception {
        this.myWriter.writeStartTag("UML", this.myName);
        this.myWriter.writeAttribute(LANGUAGE, this.myLanguage, true);
        this.myWriter.writeAttribute(BODY, this.myBody);
        this.myWriter.writeCloseBrasket(true);
    }

    public Entity processRwiElement(Entity entity, String string) throws XMIException {
        try {
            if (entity == null) {
                return entity;
            }
            String string2 = XMI11Import.getUMLNamespace();
            String string3 = XMI11Import.getNamespace(string);
            String string4 = XMI11Import.getLocalName(string);
            Diagnostic.print("Namespace = " + string3 + " localName = " + string4);
            if (string2.equals(string3)) {
                Diagnostic.print("Namespace complied");
                if ("Attribute.initialValue".equals(string4)) {
                    Diagnostic.print("Setting property");
                    entity.setPropertyValue("$initialValue", this.myBody);
                }
            }
            return entity;
        }
        catch (Exception exception) {
            Diagnostic.printError(exception);
            throw new XMIException("xmi.import.error.unknown.in", entity.getPropertyValue("$metaclass") + " " + entity.getPropertyValue("$name"));
        }
    }

    public String getType() {
        return this.myName;
    }

    public String getLanguage() {
        return this.myLanguage;
    }

    public String getBody() {
        return this.myBody;
    }

    public void setLanguage(String string) {
        this.myLanguage = string;
    }

    public void setBody(String string) {
        this.myBody = string;
    }

    public Entity setProperty(String string, String string2) throws XMIException {
        if (string == null || string.length() == 0 || string2 == null) {
            throw new XMIException("xmi.import.error.cannot.set.property", string);
        }
        if (LANGUAGE.equals(string)) {
            this.myLanguage = string2;
        } else if (BODY.equals(string)) {
            this.myBody = string2;
        } else {
            throw new XMIException("xmi.import.error.unsupported.attribute.in", string, "UML:" + this.myName);
        }
        return null;
    }

    private void init(String string, String string2, String string3) {
        this.myName = ITERATIONEXPRESSION.equals(string) || BOOLEANEXPRESSION.equals(string) || OBJECTSETEXPRESSION.equals(string) || ACTIONEXPRESSION.equals(string) || ARGLISTSEXPRESSION.equals(string) || EXPRESSION.equals(string) ? string : EXPRESSION;
        this.myBody = string2 == null ? "" : string2;
        this.myLanguage = string3 == null ? "" : string3;
    }
}

