/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.elements;

import com.togethersoft.selena.xmi.elements.XMIAbstractElement;
import com.togethersoft.selena.xmi.elements.XMIDiagram;
import com.togethersoft.selena.xmi.elements.XMIStereotype;
import com.togethersoft.selena.xmi.elements.XMITaggedValue;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.XMI11Export;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.enum.PropertyEnumeration;
import java.util.HashSet;

public abstract class XMIElementImpl
extends XMIAbstractElement {
    public static final String COMPONENT_TYPE_TCC = "component_type";
    public static final String NODE_TYPE_TCC = "node_type";
    public static final String INSTANCE_FORM = "instanceForm";
    public static final String REAL_NAME_PROPERTY_FOR_SAP = "@XMIName";
    protected static HashSet myKnownProperties = new HashSet();
    protected Entity myElement;
    protected XMIStereotype myStereotype;

    protected XMIElementImpl() {
    }

    protected XMIElementImpl(String string) {
        this.myName = string;
    }

    protected XMIElementImpl(XMLWriter xMLWriter, Entity entity) {
        super(xMLWriter);
        this.myElement = entity;
    }

    protected XMIElementImpl(XMLWriter xMLWriter, Entity entity, XMIDiagram xMIDiagram) {
        super(xMLWriter);
        this.myElement = entity;
        this.myDiagram = xMIDiagram;
    }

    public String getName() {
        return this.myName;
    }

    public Entity getRwiElement() {
        return this.myElement;
    }

    public void writeXMI11Element() throws Exception {
        if (this.myElement == null) {
            return;
        }
        String string = this.myElement.getPropertyValue("$metaclass");
        String string2 = this.myElement.getPropertyValue("$name");
    }

    public Entity setProperty(String string, String string2) throws XMIException {
        if (string == null || string.length() == 0 || string2 == null) {
            throw new XMIException("xmi.import.error.cannot.set.property2", string, string2);
        }
        if ("xmi.id".equals(string) && string2.length() != 0) {
            this.myID = string2;
            XMI11Import.addElement(string2, this.myElement);
        }
        if ("name".equals(string)) {
            Entity entity = this.myElement;
            this.myElement = XMIAbstractElement.setRwiName(this.myElement, string2);
            XMI11Import.replaceElement(entity, this.myElement);
        } else if ("isAbstract".equals(string)) {
            XMIAbstractElement.setAbstract(this.myElement, string2);
        } else if ("stereotype".equals(string) && this.myID != null) {
            XMI11Import.addStereotypeSeeks(this.myID, string2);
        }
        return this.myElement;
    }

    protected String visibilityValue() {
        if (this.myElement == null) {
            return "";
        }
        boolean bl = this.myElement.hasProperty("$public");
        if (bl) {
            return "public";
        }
        bl = this.myElement.hasProperty("$protected");
        if (bl) {
            return "protected";
        }
        bl = this.myElement.hasProperty("$private");
        if (bl) {
            return "private";
        }
        return "package";
    }

    protected String ownerScopeValue() {
        if (this.myElement == null) {
            return null;
        }
        if (this.myElement.hasProperty("$static")) {
            return "classifier";
        }
        return "instance";
    }

    protected String isSpecificationValue() {
        return "false";
    }

    protected String isAbstractValue() {
        if (this.myElement == null) {
            return null;
        }
        boolean bl = this.myElement.hasProperty("$abstract");
        if (bl) {
            return "true";
        }
        return "false";
    }

    protected String isActiveValue() {
        if (this.myElement == null) {
            return null;
        }
        boolean bl = this.myElement.hasProperty("active");
        if (bl) {
            return "true";
        }
        return "false";
    }

    protected void setOwnerScope(String string) throws XMIException {
        if (this.myElement == null) {
            return;
        }
        if ("classifier".equals(string)) {
            if (this.myElement.canSetPropertyValue("$static", Boolean.TRUE.toString())) {
                this.myElement.setPropertyValue("$static", Boolean.TRUE.toString());
            }
        } else if ("instance".equals(string)) {
            // empty if block
        }
    }

    protected void writeStereotype() throws Exception {
        if (this.myElement == null) {
            return;
        }
        this.addStereotype();
        if (!XMI11Export.isUnisysExport() && this.myStereotype != null) {
            this.myWriter.writeAttribute("stereotype", this.myStereotype.getId());
        }
    }

    protected void addStereotype() throws Exception {
        if (this.myElement == null) {
            return;
        }
        String string = "";
        PropertyEnumeration propertyEnumeration = this.myElement.properties("@stereotype");
        while (propertyEnumeration.hasMoreElements()) {
            Property property = propertyEnumeration.next();
            String string2 = property.getValue();
            if (string2 == null || string2.length() == 0) continue;
            string = string + string2;
            if (!propertyEnumeration.hasMoreElements()) continue;
            string = string + ";";
        }
        if (string.length() != 0) {
            Diagnostic.print("Adding Stereotype, myName = " + this.myName + "; myID " + this.myID);
            this.myStereotype = new XMIStereotype(this.myWriter, string, this.myName, this.myID);
            XMI11Export.addStereotype(this.myStereotype);
        }
    }

    public void writeOutOfScopeElement() throws Exception {
        this.myWriter.writeStartTag("UML", this.myName);
        this.myWriter.writeAttribute("xmi.id", this.myID);
        this.myWriter.writeAttribute("name", this.myElement.getPropertyValue("$fullName"));
        this.myWriter.writeAttribute("visibility", this.visibilityValue());
        this.myWriter.writeCloseBrasket();
        this.myWriter.writeEndTag("UML", this.myName);
    }

    protected boolean isRoseCompatible() {
        return !XMI11Export.isRoseSpecificExport() || XMI11Export.isRoseCompatible(this.myElement);
    }

    protected boolean isRoseCompatible(Entity entity) {
        return !XMI11Export.isRoseSpecificExport() || XMI11Export.isRoseCompatible(entity);
    }

    protected void writeDocumentation() {
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "$comment");
    }

    protected void writePersistence() {
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "$persistence");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "@persistent");
    }

    protected void writeAlias() {
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "@alias");
    }

    protected void writeVolatile() {
        if (this.myElement.hasProperty("$volatile")) {
            XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "$volatile");
        }
    }

    protected void writeWebService() {
    }

    protected void writeTaggedValues() {
        if (this.myElement == null) {
            return;
        }
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "@author");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "@number");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "@description");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "$description");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "@document");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "@priority");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "@difficulty");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "@testcase");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "@type");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "$constraint");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "$send_time");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "$receive_time");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "@clientRole");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "@supplierRole");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "$condition");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "@url");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "$alternate_flow");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "$explanation");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "$normal_flow");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "@postconditions");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "@preconditions");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "$rank");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "@deprecated");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "@see");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "@since");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "@version");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "@associates");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "$state");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "$multiple_instance");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "$concurrent");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "$active");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "@clientQualifier");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "@supplierQualifier");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "@associationAsClass");
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "@labelDirection");
        String string = this.myElement.getPropertyValue("$metaclass");
        String string2 = this.myElement.getPropertyValue("$type");
        if ("Component".equals(string)) {
            XMITaggedValue xMITaggedValue = new XMITaggedValue(this.myWriter, this.myID, COMPONENT_TYPE_TCC, string2);
            XMI11Export.addTaggedValue(xMITaggedValue);
            if (XMI11Export.isTCCSpecificExport()) {
                xMITaggedValue = new XMITaggedValue(this.myWriter, this.myID, INSTANCE_FORM, "");
                XMI11Export.addTaggedValue(xMITaggedValue);
            }
        } else if ("Node".equals(string)) {
            XMITaggedValue xMITaggedValue = new XMITaggedValue(this.myWriter, this.myID, NODE_TYPE_TCC, string2);
            XMI11Export.addTaggedValue(xMITaggedValue);
        }
        this.writeCustomProperties();
    }

    private static String propertiesToString(Entity entity) {
        StringBuffer stringBuffer = new StringBuffer("Element Properties: ");
        if (entity == null) {
            return stringBuffer.append("Element NULL").toString();
        }
        PropertyEnumeration propertyEnumeration = entity.properties();
        while (propertyEnumeration.hasMoreElements()) {
            Property property = propertyEnumeration.next();
            stringBuffer.append("\n\t" + property.getName() + "\t" + property.getValue());
        }
        return stringBuffer.toString();
    }

    public static void showProperties(Entity entity) {
        Diagnostic.print(XMIElementImpl.propertiesToString(entity));
    }

    protected String getRealNameProperty() {
        String string = null;
        if (this.myElement.hasPropertyValue("$metaclass", "Attribute") && this.myElement.hasProperty(REAL_NAME_PROPERTY_FOR_SAP)) {
            string = this.myElement.getPropertyValue(REAL_NAME_PROPERTY_FOR_SAP);
        }
        return string;
    }

    protected void writeCustomProperties() {
        if (this.myElement == null) {
            return;
        }
        HashSet hashSet = XMIElementImpl.knownProperties();
        PropertyEnumeration propertyEnumeration = this.myElement.properties();
        while (propertyEnumeration.hasMoreElements()) {
            Property property = propertyEnumeration.next();
            String string = property.getName();
            if (hashSet.contains(string) || XMITaggedValue.isTagFiltered(string)) continue;
            XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, string, true);
            Diagnostic.print("FOUND Custom property for '" + this.myElement.getPropertyValue("$metaclass") + "' \"" + this.myElement.getPropertyValue("$name") + "\": " + string + " == " + property.getValue());
        }
    }

    public static HashSet knownProperties() {
        return myKnownProperties;
    }

    static {
        myKnownProperties.add(REAL_NAME_PROPERTY_FOR_SAP);
        myKnownProperties.add("$metaclass");
        myKnownProperties.add("$name");
        myKnownProperties.add("$static");
        myKnownProperties.add("$public");
        myKnownProperties.add("$protected");
        myKnownProperties.add("$private");
        myKnownProperties.add("$comment");
        myKnownProperties.add("$persistence");
        myKnownProperties.add("@persistent");
        myKnownProperties.add("@alias");
        myKnownProperties.add("$volatile");
        myKnownProperties.add("@author");
        myKnownProperties.add("@number");
        myKnownProperties.add("@description");
        myKnownProperties.add("$description");
        myKnownProperties.add("@document");
        myKnownProperties.add("@priority");
        myKnownProperties.add("@difficulty");
        myKnownProperties.add("@testcase");
        myKnownProperties.add("@type");
        myKnownProperties.add("$constraint");
        myKnownProperties.add("$send_time");
        myKnownProperties.add("$receive_time");
        myKnownProperties.add("@clientRole");
        myKnownProperties.add("@supplierRole");
        myKnownProperties.add("$condition");
        myKnownProperties.add("@url");
        myKnownProperties.add("$alternate_flow");
        myKnownProperties.add("$explanation");
        myKnownProperties.add("$normal_flow");
        myKnownProperties.add("@postconditions");
        myKnownProperties.add("@preconditions");
        myKnownProperties.add("$rank");
        myKnownProperties.add("@deprecated");
        myKnownProperties.add("@see");
        myKnownProperties.add("@since");
        myKnownProperties.add("@version");
        myKnownProperties.add("@associates");
        myKnownProperties.add("$state");
        myKnownProperties.add("$multiple_instance");
        myKnownProperties.add("$concurrent");
        myKnownProperties.add("$active");
        myKnownProperties.add("@clientQualifier");
        myKnownProperties.add("@supplierQualifier");
        myKnownProperties.add("@associationAsClass");
        myKnownProperties.add("@labelDirection");
        myKnownProperties.add("$type");
        myKnownProperties.add(COMPONENT_TYPE_TCC);
        myKnownProperties.add(NODE_TYPE_TCC);
        myKnownProperties.add(INSTANCE_FORM);
        myKnownProperties.add("$metaclass");
        myKnownProperties.add("$name");
        myKnownProperties.add("$fullName");
        myKnownProperties.add("$memberSignature");
        myKnownProperties.add("@stereotype");
        myKnownProperties.add("$interface");
        myKnownProperties.add("@label");
        myKnownProperties.add("$refAttribute");
        myKnownProperties.add("$refAssociationLink");
        myKnownProperties.add("@clientRole");
        myKnownProperties.add("@supplierRole");
        myKnownProperties.add("@link");
        myKnownProperties.add("@directed");
        myKnownProperties.add("@supplierCardinality");
        myKnownProperties.add("@clientCardinality");
        myKnownProperties.add("$final");
        myKnownProperties.add("const");
        myKnownProperties.add("$initialValue");
        myKnownProperties.add("$language");
        myKnownProperties.add("$type");
        myKnownProperties.add("$typeReferencedElement");
        myKnownProperties.add("$file");
        myKnownProperties.add("$final");
        myKnownProperties.add("namespace");
        myKnownProperties.add("$extends");
        myKnownProperties.add("@invariants");
        myKnownProperties.add("$abstract");
        myKnownProperties.add("$multiple_instance");
        myKnownProperties.add("$note_text");
        myKnownProperties.add("@label");
        myKnownProperties.add("$imported");
        myKnownProperties.add("sequenceNumber");
        myKnownProperties.add("3Dlook");
        myKnownProperties.add("$shortcutReference");
        myKnownProperties.add("$orientation");
        myKnownProperties.add("bounds");
        myKnownProperties.add("bounds_setted_by_user");
        myKnownProperties.add("text_only");
        myKnownProperties.add("minProcessingDuration");
        myKnownProperties.add("processingDuration");
        myKnownProperties.add("deliveryTime");
        myKnownProperties.add("$interface");
        myKnownProperties.add("$implements");
        myKnownProperties.add("$extends");
        myKnownProperties.add("controlFlowType");
        myKnownProperties.add("branchingAnchorUid");
        myKnownProperties.add("normalizedIndex");
        myKnownProperties.add("return");
        myKnownProperties.add("activationUid");
        myKnownProperties.add("arguments");
        myKnownProperties.add("condition");
        myKnownProperties.add("iteration");
        myKnownProperties.add("return");
        myKnownProperties.add("destruction");
        myKnownProperties.add("creation");
        myKnownProperties.add("@semantics");
        myKnownProperties.add("$parameter");
        myKnownProperties.add("$type");
        myKnownProperties.add("$typeReferencedElement");
        myKnownProperties.add("$returnType");
        myKnownProperties.add("$typeReferencedElement");
        myKnownProperties.add("$constructor");
        myKnownProperties.add("$native");
        myKnownProperties.add("$synchronized");
        myKnownProperties.add("$throws");
        myKnownProperties.add("$referencedElement");
        myKnownProperties.add("$fullName");
        myKnownProperties.add("@preconditions");
        myKnownProperties.add("@postconditions");
        myKnownProperties.add("@input");
        myKnownProperties.add("@output");
        myKnownProperties.add("@time");
        myKnownProperties.add("$returnType");
        myKnownProperties.add("$parameter");
        myKnownProperties.add("$guard_condition");
        myKnownProperties.add("$action_expression");
        myKnownProperties.add("$send_clause");
        myKnownProperties.add("$event_name");
        myKnownProperties.add("$event_arguments");
        myKnownProperties.add("showReturnArrow");
        myKnownProperties.add("vertical");
    }
}

