/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.elements;

import com.togethersoft.selena.xmi.elements.XMIAbstractElement;
import com.togethersoft.selena.xmi.elements.XMIDiagram;
import com.togethersoft.selena.xmi.elements.XMIElementImpl;
import com.togethersoft.selena.xmi.elements.XMIMessage;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.InterchangeUtils;
import com.togethersoft.selena.xmi.util.XMI11Export;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.impl.model.elements.EntityTemplateImpl;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.enum.ReferenceEnumeration;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class XMIDiagramElement
extends XMIElementImpl {
    public static final String DIAGRAMELEMENT = "DiagramElement";
    public static final String PRESENTATIONELEMENT_SUBJECT = "PresentationElement.subject";
    public static final String GEOMETRY = "geometry";
    public static final String SHORTCUT = "shortcut";
    public static final String SUBJECT = "subject";
    public static final String STYLE = "style";
    public static final String DLOOK = "dlook";
    public static final String STYLE_ASSOCIATION = "Association:Font.Blue= 0,Font.Green= 0,Font.Red= 0,Font.FaceName=Arial,Font.Size= 10,Font.Bold=0,Font.Italic=0,Font.Strikethrough=0,Font.Underline=0,LineColor.Blue= 51,LineColor.Green= 0,LineColor.Red= 153,";
    public static final String STYLE_INHERITANCE = "Inheritance";
    public static final String STYLE_TRANSITION = "Transition";
    public static final String STYLE_STATE = "FillColor.Blue= 204,FillColor.Green= 255,FillColor.Red= 255,FillColor.Transparent=1,Font.Blue= 0,Font.Green= 0,Font.Red= 0,Font.FaceName=Arial,Font.Size= 10,Font.Bold=0,Font.Italic=0,Font.Strikethrough=0,Font.Underline=0,LineColor.Blue= 51,LineColor.Green= 0,LineColor.Red= 153,";
    public static final String STYLE_CLASS = "Font.Blue= 0,Font.Green= 0,Font.Red= 0,Font.FaceName=Arial,Font.Size= 10,Font.Bold=0,Font.Italic=0,Font.Strikethrough=0,Font.Underline=0,LineColor.Blue= 51,LineColor.Green= 0,LineColor.Red= 153,FillColor.Blue= 204,FillColor.Green= 255,FillColor.Red= 255,FillColor.Transparent=1,AutomaticResize=1,ShowAllAttributes=1,ShowAllOperations=1,ShowOperationSignature=0,SuppressAttributes=0,SuppressOperations=0,";
    public static final String STYLE_ROLE = "Role";
    private static Vector ourMovedElements = new Vector();
    private String myIdref;
    private String myGeometry;
    private String myStyle;
    private boolean myGeometryIsDefault;
    private Entity myRwiDiagram;
    private Reference myReference;
    private String myDlook;
    private boolean myShortcut;
    private boolean myShortcutPresent;

    public XMIDiagramElement(Entity entity) {
        this.myRwiDiagram = entity;
        this.myShortcut = false;
        this.myShortcutPresent = false;
    }

    public XMIDiagramElement(XMLWriter xMLWriter, Entity entity, Entity entity2, String string) {
        super(xMLWriter, entity);
        this.myIdref = string;
        this.myRwiDiagram = entity2;
        this.myName = DIAGRAMELEMENT;
        this.myID = XMI11Export.getDiagramElementID(this);
        this.myGeometryIsDefault = false;
    }

    public XMIDiagramElement(XMLWriter xMLWriter, Entity entity, Entity entity2, String string, Reference reference) {
        super(xMLWriter, entity);
        this.myIdref = string;
        this.myRwiDiagram = entity2;
        this.myName = DIAGRAMELEMENT;
        this.myID = XMI11Export.getDiagramElementID(this);
        this.myGeometryIsDefault = false;
        this.myReference = reference;
    }

    public Entity getElement() {
        return this.myElement;
    }

    public String getIdref() {
        return this.myIdref;
    }

    public String getStyle() {
        return this.myStyle;
    }

    public String getGeometry() {
        return this.myGeometry;
    }

    public void writeXMI11Element() throws Exception {
        String string;
        if (this.myReference == null) {
            return;
        }
        if (XMI11Export.isRoseSpecificExport() && !XMI11Export.isReferenceRoseCompatible(this.myReference)) {
            return;
        }
        Entity entity = this.myReference.getEntity();
        String string2 = entity.getPropertyValue("$metaclass");
        if (!this.myGeometryIsDefault && this.myReference != null) {
            this.myGeometry = XMIDiagram.convertPositions(this.myReference, this.myRwiDiagram);
        }
        this.myWriter.writeStartTag("UML", this.myName);
        this.myWriter.writeAttribute("xmi.id", this.myID);
        if (this.myGeometry != null && this.myElement != null) {
            this.myWriter.writeAttribute(GEOMETRY, this.myGeometry, true);
        }
        if (XMI11Export.isTCCSpecificExport()) {
            if (this.myReference.hasProperty("$imported")) {
                this.myWriter.writeAttribute(SHORTCUT, "true");
            } else {
                this.myWriter.writeAttribute(SHORTCUT, "false");
            }
        }
        if ("Message Link".equals(string2)) {
            string = this.myReference.getPropertyValue("sequenceNumber");
            if (string == null || string.length() == 0) {
                string = "1";
            }
            this.myStyle = "Message, SQN= " + string + ",";
            if (!XMI11Export.isRoseSpecificExport()) {
                XMI11Export.addTaggedValue((Element)this.myReference, this.myWriter, this.myID, "minProcessingDuration");
                XMI11Export.addTaggedValue((Element)this.myReference, this.myWriter, this.myID, "processingDuration");
                XMI11Export.addTaggedValue((Element)this.myReference, this.myWriter, this.myID, "sendingInstant");
                XMI11Export.addTaggedValue((Element)this.myReference, this.myWriter, this.myID, "deliveryTime");
            }
        }
        if (this.myStyle == null) {
            this.myStyle = XMIDiagramElement.makeStyle(this.myReference);
        }
        if (this.myStyle != null) {
            if (entity.hasPropertyValue("$metaclass", "Association Link") && XMI11Export.isRoseSpecificExport()) {
                this.myStyle = "Association:" + this.myStyle;
            } else if (entity.hasPropertyValue("$metaclass", "Note") && XMI11Export.isRoseSpecificExport()) {
                this.myStyle = "Note:" + this.myStyle;
            }
            this.myWriter.writeAttribute(STYLE, this.myStyle);
        }
        if ((string = this.myReference.getPropertyValue("3Dlook")) != null) {
            if ("Yes".equals(string)) {
                this.myWriter.writeAttribute(DLOOK, "yes");
            } else {
                this.myWriter.writeAttribute(DLOOK, "no");
            }
        }
        this.writeStereotype();
        this.myWriter.writeCloseBrasket();
        this.myWriter.writeStartTag("UML", PRESENTATIONELEMENT_SUBJECT, true);
        this.myWriter.writeStartTag("Foundation.Core.ModelElement");
        if (this.myReference.hasProperty("$shortcutReference")) {
            // empty if block
        }
        this.myWriter.writeAttribute("xmi.idref", this.myIdref);
        this.myWriter.writeCloseBrasket(true);
        if (this.myElement != null) {
            String string3 = this.myElement.getPropertyValue("$name");
            string2 = this.myElement.getPropertyValue("$metaclass");
            this.myWriter.writeComments(string2 + " " + string3, false);
        }
        this.myWriter.writeEndTag("UML", PRESENTATIONELEMENT_SUBJECT);
        this.myWriter.writeEndTag("UML", this.myName);
    }

    public String getId() {
        return XMI11Export.getDiagramElementID(this);
    }

    public Entity setProperty(String string, String string2) throws XMIException {
        if (string == null || string.length() == 0 || string2 == null) {
            throw new XMIException("xmi.import.error.cannot.set.property", string);
        }
        if ("xmi.id".equals(string) && string2.length() != 0) {
            this.myID = string2;
        } else if (GEOMETRY.equals(string)) {
            this.myGeometry = string2;
        } else if (STYLE.equals(string)) {
            this.myStyle = string2;
        } else if (DLOOK.equals(string)) {
            this.myDlook = string2;
        } else if (SHORTCUT.equals(string)) {
            this.myShortcutPresent = true;
            if ("true".equals(string2)) {
                this.myShortcut = true;
            }
        } else if (SUBJECT.equals(string)) {
            this.setDiagram(string2, 1);
        }
        return this.myElement;
    }

    public void setReference(String string) throws XMIException {
        this.setDiagram(string, 1);
    }

    public static List makeListOfParents(Entity entity) {
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        Entity entity2 = entity.getParent();
        String string = entity2 == null ? null : entity2.getPropertyValue("$metaclass");
        while (entity2 != null && !"Model".equals(string)) {
            if (!"Package".equals(string)) {
                arrayList.add(entity2);
            }
            String string2 = string = (entity2 = entity2.getParent()) == null ? null : entity2.getPropertyValue("$metaclass");
        }
        return arrayList;
    }

    public static Reference createReference(ReferenceCollection referenceCollection, Entity entity) throws XMIException {
        Date date = new Date();
        if (entity.hasPropertyValue("$metaclass", "Package") && (entity = XMI11Import.getDefaultReferenceCollection(entity)) == null) {
            throw new XMIException("xmi.import.error.unknown1", "createReference");
        }
        List list = XMIDiagramElement.makeListOfParents(entity);
        Reference reference = XMIDiagramElement.findReference(referenceCollection.references(), entity);
        if (reference == null && list.size() == 0) {
            Reference reference2 = null;
            reference2 = entity.getModel().createReferenceTemplate();
            reference2.setPropertyValue("$shortcutReference", "true");
            reference = referenceCollection.addReference(entity, reference2);
        }
        XMI11Import.addReferenceTime(new Date().getTime() - date.getTime());
        return reference;
    }

    public static Reference findReference(ReferenceEnumeration referenceEnumeration, Entity entity) {
        Reference reference = null;
        while (referenceEnumeration.hasMoreElements() && reference == null) {
            Reference reference2 = referenceEnumeration.next();
            Entity entity2 = reference2.getEntity();
            reference = entity2 == entity ? reference2 : XMIDiagramElement.findReference(reference2.references(), entity);
        }
        return reference;
    }

    public Reference setDiagram(String string, int n) throws XMIException {
        Object object;
        if (this.myRwiDiagram == null || string == null) {
            return null;
        }
        Entity entity = XMI11Import.getElement(string);
        if (entity == null && (object = (XMIElementImpl)XMI11Import.getXMIElement(string)) != null) {
            entity = ((XMIAbstractElement)object).getParent();
        }
        if (entity == null && n == 1) {
            XMI11Import.addEmptyReference(this, string);
            return null;
        }
        if (entity == null) {
            return null;
        }
        if (entity instanceof EntityTemplateImpl) {
            Diagnostic.print("<<---- Try to create refefrence to TEMPLATE  ---->>");
            return null;
        }
        object = entity.getPropertyValue("$metaclass");
        Reference reference = null;
        if (entity instanceof Entity) {
            if (XMIDiagramElement.isMoved(entity)) {
                reference = InterchangeUtils.findReference(entity, this.myRwiDiagram);
            } else {
                XMIMessage xMIMessage;
                reference = XMIDiagramElement.createReference((ReferenceCollection)this.myRwiDiagram, entity);
                if (reference == null && n == 1) {
                    XMI11Import.addEmptyReference(this, string);
                    return null;
                }
                if (reference == null) {
                    Diagnostic.print("!!! NULL REFERENCE !!!");
                    return null;
                }
                if (this.myShortcutPresent) {
                    if (this.myShortcut) {
                        Diagnostic.print("This is shortcut from TWSE");
                        reference.setPropertyValue("$imported", Boolean.TRUE.toString());
                    }
                } else if (!entity.hasPropertyValue("$metaclass", "Package Diagram")) {
                    if (((String)object).endsWith("Diagram")) {
                        reference.setPropertyValue("$imported", Boolean.TRUE.toString());
                    }
                    if (XMI11Import.isElementAlreadyCreated(reference)) {
                        Diagnostic.print("This is shortcut!");
                        reference.setPropertyValue("$imported", Boolean.TRUE.toString());
                    }
                }
                if ((xMIMessage = XMI11Import.getMessage(string)) != null) {
                    XMI11Import.addMessageReference(reference, this.myStyle);
                }
            }
            XMIDiagramElement.setViewProperties(reference, this.myGeometry, this.myStyle, this.myDlook);
            XMI11Import.addReference(this.myID, reference);
            return reference;
        }
        if (("Class".equals(object) || "Class Diagram".equals(object)) && !"Class Diagram".equals(this.myRwiDiagram.getPropertyValue("$metaclass")) && !"Component Diagram".equals(this.myRwiDiagram.getPropertyValue("$metaclass"))) {
            return null;
        }
        if (entity.getParent() != null) {
            return null;
        }
        if (!(XMIDiagramElement.isMoved(entity) || "Class".equals(object) || entity.hasPropertyValue("$metaclass", "Package"))) {
            try {
                Hashtable hashtable = new Hashtable();
                Hashtable hashtable2 = new Hashtable();
                hashtable = XMIDiagramElement.getChildrenIDs(entity, hashtable, hashtable2);
                if (entity.canCut()) {
                    entity = entity.cut();
                }
                if (this.myRwiDiagram.canPaste((Element)entity, null, false)) {
                    entity = (Entity)this.myRwiDiagram.paste((Element)entity, null, false);
                }
                XMI11Import.addElement(string, entity);
                XMIDiagramElement.addMoved(entity);
                reference = InterchangeUtils.findReference(entity, this.myRwiDiagram);
                this.updateElementTable(entity, hashtable, this.myRwiDiagram, hashtable2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            reference = InterchangeUtils.addReference(entity, this.myRwiDiagram);
        }
        XMIDiagramElement.setViewProperties(reference, this.myGeometry, this.myStyle, this.myDlook);
        XMI11Import.addReference(this.myID, reference);
        return reference;
    }

    private static void addMoved(Entity entity) {
        ourMovedElements.add(entity);
    }

    private static boolean isMoved(Entity entity) {
        return ourMovedElements.contains(entity);
    }

    private static Hashtable getChildrenIDs(Entity entity, Hashtable hashtable, Hashtable hashtable2) {
        if (entity == null) {
            return hashtable;
        }
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        if (hashtable2 == null) {
            hashtable2 = new Hashtable<String, String>();
        }
        EntityEnumeration entityEnumeration = null;
        Entity entity2 = null;
        String string = null;
        if (entity.childEntities().hasMoreElements()) {
            Entity entity3 = entity.getParent();
            entityEnumeration = entity.childEntities();
            while (entityEnumeration.hasMoreElements()) {
                entity2 = entityEnumeration.next();
                string = XMI11Import.getElementID(entity2);
                if (string != null) {
                    hashtable.put(entity2.getPropertyValue("$name"), string);
                    String string2 = entity2.getPropertyValue("bounds");
                    if (string2 != null) {
                        hashtable2.put(string, string2);
                    }
                }
                hashtable = XMIDiagramElement.getChildrenIDs(entity2, hashtable, hashtable2);
            }
        }
        return hashtable;
    }

    private void updateElementTable(Entity entity, Hashtable hashtable, Entity entity2, Hashtable hashtable2) {
        if (hashtable == null || hashtable.isEmpty()) {
            return;
        }
        EntityEnumeration entityEnumeration = entity.childEntities();
        Entity entity3 = null;
        String string = null;
        while (entityEnumeration.hasMoreElements()) {
            entity3 = entityEnumeration.next();
            if (entity3 == null) continue;
            string = (String)hashtable.get(entity3.getPropertyValue("$name"));
            if (string != null) {
                XMI11Import.addElement(string, entity3);
                if (!XMIDiagramElement.isMoved(entity3) && entity2 != null && hashtable2 != null) {
                    String string2 = (String)hashtable2.get(string);
                    Reference reference = InterchangeUtils.findReference(entity3, entity2);
                    if (reference != null) {
                        reference.setPropertyValue("bounds", string2);
                    }
                }
                XMIDiagramElement.addMoved(entity3);
            }
            this.updateElementTable(entity3, hashtable, entity2, hashtable2);
        }
    }

    public static void setViewProperties(Reference reference, String string, String string2, String string3) {
        if (reference != null) {
            if (string != null && string.length() != 0) {
                Entity entity;
                String string4 = XMIDiagram.restorePositions(string);
                String string5 = XMI11Import.getExporterName();
                if ((string5 == null || string5.indexOf("Together") == -1) && (entity = reference.getEntity()).hasPropertyValue("$metaclass", "Synchronization Bar") && XMIDiagram.width() < XMIDiagram.height()) {
                    entity.setPropertyValue("$orientation", "vertical");
                    Diagnostic.print("VERTICAL");
                }
                reference.setPropertyValue("bounds", string4);
                reference.setPropertyValue("bounds_setted_by_user", "true");
            }
            if (string2 != null && string2.length() != 0) {
                XMIDiagramElement.setStyle(reference, string2);
            }
            if (string3 != null && string3.length() != 0) {
                if ("yes".equals(string3)) {
                    reference.setPropertyValue("3Dlook", "Yes");
                } else {
                    reference.setPropertyValue("3Dlook", "No");
                }
            }
        }
    }

    private static void setStyle(Reference reference, String string) {
        String string2;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            string2 = stringTokenizer.nextToken();
            if (string2 != null) {
                int n2 = string2.lastIndexOf("=");
                String string9 = string2.substring(n2 + 1).trim();
                switch (n) {
                    case 0: {
                        string5 = string9;
                        break;
                    }
                    case 1: {
                        string4 = string9;
                        break;
                    }
                    case 2: {
                        string3 = string9;
                        break;
                    }
                    case 13: {
                        string8 = string9;
                        break;
                    }
                    case 14: {
                        string7 = string9;
                        break;
                    }
                    case 15: {
                        string6 = string9;
                    }
                }
            }
            ++n;
        }
        if (string3 == null || string4 == null || string5 == null || string6 == null || string7 == null || string8 == null) {
            return;
        }
        string2 = string3 + "," + string4 + "," + string5;
        String string10 = string6 + "," + string7 + "," + string8;
        reference.setPropertyValue("background_color", string2);
        reference.setPropertyValue("foreground_color", string10);
    }

    private static String makeStyle(Reference reference) {
        String string;
        String string2 = "255";
        String string3 = "255";
        String string4 = "255";
        String string5 = "0";
        String string6 = "0";
        String string7 = "0";
        String string8 = reference.getPropertyValue("foreground_color");
        String string9 = reference.getPropertyValue("background_color");
        int n = 0;
        StringTokenizer stringTokenizer = null;
        if (string9 != null) {
            stringTokenizer = new StringTokenizer(string9, ",");
            while (stringTokenizer.hasMoreElements()) {
                string = stringTokenizer.nextToken();
                switch (n) {
                    case 0: {
                        string2 = string;
                        break;
                    }
                    case 1: {
                        string3 = string;
                    }
                    case 2: {
                        string4 = string;
                    }
                }
                ++n;
            }
        }
        n = 0;
        if (string8 != null) {
            stringTokenizer = new StringTokenizer(string8, ",");
            while (stringTokenizer.hasMoreElements()) {
                string = stringTokenizer.nextToken();
                switch (n) {
                    case 0: {
                        string5 = string;
                        break;
                    }
                    case 1: {
                        string6 = string;
                    }
                    case 2: {
                        string7 = string;
                    }
                }
                ++n;
            }
        }
        string = null;
        string = "FillColor.Blue= " + string4 + ",FillColor.Green= " + string3 + ",FillColor.Red= " + string2 + ",FillColor.Transparent=1" + ",Font.Blue= 0" + ",Font.Green= 0" + ",Font.Red= 0" + ",Font.FaceName=Arial" + ",Font.Size= 10" + ",Font.Bold=0" + ",Font.Italic=0" + ",Font.Strikethrough=0" + ",Font.Underline=0" + ",LineColor.Blue= " + string7 + ",LineColor.Green= " + string6 + ",LineColor.Red= " + string5 + ",";
        return string;
    }
}

