/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.elements;

import com.togethersoft.selena.xmi.elements.XMIAbstractElement;
import com.togethersoft.selena.xmi.elements.XMIAction;
import com.togethersoft.selena.xmi.elements.XMIAssociation;
import com.togethersoft.selena.xmi.elements.XMIAssociationRole;
import com.togethersoft.selena.xmi.elements.XMIClass;
import com.togethersoft.selena.xmi.elements.XMIDiagramElement;
import com.togethersoft.selena.xmi.elements.XMIElement;
import com.togethersoft.selena.xmi.elements.XMIMessage;
import com.togethersoft.selena.xmi.elements.XMIStereotype;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.ElementCollector;
import com.togethersoft.selena.xmi.util.ElementCollectorImpl;
import com.togethersoft.selena.xmi.util.InterchangeUtils;
import com.togethersoft.selena.xmi.util.XMI11Export;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIElementCollector;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.impl.model.elements.EntityTemplateImpl;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.enum.ReferenceEnumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;

public class XMIDiagram
extends XMIAbstractElement {
    public static final String DIAGRAM = "Diagram";
    public static final String DIAGRAM_OWNER = "Diagram.owner";
    public static final String DIAGRAM_ELEMENT = "Diagram.element";
    public static final String NAME_MODULEDIAGRAM = "ModuleDiagram";
    public static final String TYPE_COLLABORATIONDIAGRAM = "CollaborationDiagram";
    public static final String TYPE_SEQUENCEDIAGRAM = "SequenceDiagram";
    public static final String DIAGRAMTYPE = "diagramType";
    public static final String TOOLNAME = "toolName";
    public static final String STYLE = "style";
    public static final String USECASE_VIEW = "Use Case View";
    public static final String USECASEMODEL = "useCaseModel";
    protected Entity myRwiDiagram;
    protected String myDiagramName;
    protected String myDiagramType;
    protected String myOwnerID;
    protected XMIElementCollector myMessageCollector;
    protected XMIElementCollector myAssociationRoleCollector;
    protected ElementCollector myDependencyCollector;
    protected XMIElementCollector myAssociationCollector;
    protected XMIElementCollector myClassCollector;
    protected XMIElementCollector myActionCollector;
    protected XMIElementCollector myStereotypeCollector;
    protected XMIElementCollector myPartitionCollector;
    protected XMIElementCollector myElementViewCollector;
    protected boolean myDefaultDiagram;
    protected boolean myExported;
    private Vector myRwiElements;
    private HashMap myEntityToReferences;
    private static int ourX;
    private static int ourY;
    private static int ourW;
    private static int ourH;

    public XMIDiagram() {
    }

    public XMIDiagram(XMLWriter xMLWriter, Entity entity, String string) {
        super(xMLWriter);
        this.myRwiDiagram = entity;
        if (this.myRwiDiagram != null) {
            this.myDiagramName = this.myRwiDiagram.getPropertyValue("$name");
            if ("<default>".equals(this.myDiagramName)) {
                this.myDiagramName = "Main";
            }
            this.myDiagramType = this.myRwiDiagram.getPropertyValue("$metaclass");
        }
        this.myMessageCollector = new XMIElementCollector();
        this.myAssociationRoleCollector = new XMIElementCollector(true);
        this.myDependencyCollector = new ElementCollectorImpl(true);
        this.myAssociationCollector = new XMIElementCollector(true);
        this.myActionCollector = new XMIElementCollector();
        this.myClassCollector = new XMIElementCollector(true);
        this.myStereotypeCollector = new XMIElementCollector(true);
        this.myElementViewCollector = new XMIElementCollector(true);
        this.myDefaultDiagram = false;
        this.myRwiElements = new Vector();
        this.myID = XMI11Export.getElementID(this.myRwiDiagram);
        Diagnostic.print("DiagramConstructor " + this.myDiagramType + " " + this.myDiagramName + " " + this.myID);
        if (XMI11Export.isExportedType(this.myRwiDiagram) && !XMI11Export.isExportedDiagram(this.myRwiDiagram) && !XMI11Export.isExported(this.myRwiDiagram)) {
            Diagnostic.print("\tNOT EXPORTED");
            this.myExported = false;
            XMI11Export.addDiagram(this);
            XMI11Export.addExportedElement(this.myRwiDiagram, this.myID);
            XMI11Export.addExportedDiagram(this.myRwiDiagram);
        } else {
            Diagnostic.print("\tALREADY EXPORTED");
            this.myExported = true;
        }
        if (!"".equals(string)) {
            this.setDiagramType(string);
        }
        this.myOwnerID = XMI11Export.getElementID(entity.getParent());
        ReferenceEnumeration referenceEnumeration = ((ReferenceCollection)this.myRwiDiagram).references();
        this.collectElements(referenceEnumeration);
    }

    public Entity getPhysicalDiagram() {
        return this.myRwiDiagram;
    }

    public void addElementView(Entity entity, String string, Reference reference) {
        XMIDiagramElement xMIDiagramElement = new XMIDiagramElement(this.myWriter, entity, this.myRwiDiagram, string, reference);
        this.myElementViewCollector.addXMIElement(xMIDiagramElement);
    }

    public String getDiagramName() {
        return this.myDiagramName;
    }

    public String getDiagramType() {
        return this.myDiagramType;
    }

    public void setDiagramName(String string) {
        this.myDiagramName = string;
    }

    public void setDiagramType(String string) {
        this.myDiagramType = string;
    }

    public void addMessage(XMIMessage xMIMessage) {
        this.myMessageCollector.addXMIElement(xMIMessage);
    }

    public void addAssociation(XMIAssociation xMIAssociation) {
        Diagnostic.print("Diagram, addAssociation");
        this.myAssociationCollector.addXMIElement(xMIAssociation);
    }

    public void addAssociationRole(XMIAssociationRole xMIAssociationRole) {
        Diagnostic.print("Diagram, addAssociationRole");
        this.myAssociationRoleCollector.addXMIElement(xMIAssociationRole);
    }

    public void addAction(XMIAction xMIAction) {
        this.myActionCollector.addXMIElement(xMIAction);
    }

    public void addClass(XMIClass xMIClass) {
        this.myClassCollector.addXMIElement(xMIClass);
    }

    public void addStereotype(XMIStereotype xMIStereotype) {
        this.myStereotypeCollector.addXMIElement(xMIStereotype);
    }

    public void addDependency(Entity entity) {
        this.myDependencyCollector.addElement(entity);
    }

    public ElementCollector getMessages() {
        return this.myMessageCollector;
    }

    public ElementCollector getAssociationRoles() {
        return this.myAssociationRoleCollector;
    }

    public ElementCollector getAssociations() {
        return this.myAssociationCollector;
    }

    public ElementCollector getActions() {
        return this.myActionCollector;
    }

    public ElementCollector getStereotypes() {
        return this.myStereotypeCollector;
    }

    public void setOwner(String string) {
        this.myOwnerID = string;
    }

    public ElementCollector getClasses() {
        Diagnostic.print("\n DIAGRAM, getting CLASSES!");
        return this.myClassCollector;
    }

    public ElementCollector getPartitions() {
        Diagnostic.print("\n DIAGRAM, getting CLASSES!");
        return this.myPartitionCollector;
    }

    public void setDefault(boolean bl) {
        this.myDefaultDiagram = bl;
    }

    public void setReference(String string) {
        this.setOwner(string);
        this.createRwiDiagram();
    }

    public String getOwner() {
        return this.myOwnerID;
    }

    public Entity setProperty(String string, String string2) throws XMIException {
        if (string == null || string.length() == 0 || string2 == null) {
            throw new XMIException("xmi.import.error.cannot.set.name", string2);
        }
        if ("xmi.id".equals(string) && string2.length() != 0) {
            this.myID = string2;
        } else if ("name".equals(string)) {
            this.myDiagramName = string2;
        } else if (DIAGRAMTYPE.equals(string)) {
            this.myDiagramType = string2;
        } else if ("owner".equals(string)) {
            this.setReference(string2);
        }
        return this.myRwiDiagram;
    }

    public static String convertPositions(Reference reference, Entity entity) {
        if (reference == null || entity == null) {
            return null;
        }
        String string = reference.getPropertyValue("bounds");
        Diagnostic.print("Positions : " + string);
        if (string == null || string.length() == 0) {
            return null;
        }
        string = string.trim();
        StringBuffer stringBuffer = new StringBuffer(string);
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        while (n < stringBuffer.length()) {
            if (Character.isDigit(stringBuffer.charAt(n)) || stringBuffer.charAt(n) == ',') {
                stringBuffer2.append(stringBuffer.charAt(n));
            }
            ++n;
        }
        string = stringBuffer2.toString();
        Diagnostic.print("New Positions : " + string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        int n4 = Integer.parseInt(stringTokenizer.nextToken());
        int n5 = Integer.parseInt(stringTokenizer.nextToken());
        String string2 = new String((n2 + n4 / 2) * 3 + "," + (n3 + n5 / 2) * 3 + "," + n4 * 3 + "," + n5 * 3 + ",");
        return string2;
    }

    public static String restorePositions(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = string;
        string = string.trim();
        StringBuffer stringBuffer = new StringBuffer(string);
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        while (n < stringBuffer.length()) {
            if (Character.isDigit(stringBuffer.charAt(n)) || stringBuffer.charAt(n) == ',') {
                stringBuffer2.append(stringBuffer.charAt(n));
            }
            ++n;
        }
        string = stringBuffer2.toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        int n4 = Integer.parseInt(stringTokenizer.nextToken());
        int n5 = Integer.parseInt(stringTokenizer.nextToken());
        ourX = (n2 - n4 / 2) / 3;
        ourY = (n3 - n5 / 2) / 3;
        ourW = n4 / 3;
        ourH = n5 / 3;
        String string3 = new String(ourX + "," + ourY + "," + ourW + "," + ourH);
        return string3;
    }

    protected Entity createRwiDiagram() {
        Diagnostic.print("Creating diagram " + this.myDiagramName + " " + this.myDiagramType);
        boolean bl = true;
        Entity entity = XMI11Import.getElement(this.getOwner());
        Model model = InterchangeUtils.getWizardData().getModel();
        Entity entity2 = model.childEntities().next();
        if (entity != null && entity.hasPropertyValue("$metaclass", "Package")) {
            entity2 = entity;
        } else {
            XMIElement xMIElement = XMI11Import.getXMIElement(this.getOwner());
            if (xMIElement != null) {
                entity = ((XMIAbstractElement)xMIElement).getParent();
            }
            if (entity != null && (entity.hasPropertyValue("$metaclass", "Package") || entity.hasPropertyValue("$metaclass", "Model"))) {
                if (entity instanceof EntityTemplateImpl) {
                    entity2 = XMI11Import.realEntity(entity);
                    if (entity2 == null || entity2 instanceof EntityTemplateImpl) {
                        entity2 = model;
                    }
                } else {
                    entity2 = entity;
                }
            }
            if (entity == null) {
                entity2 = model;
            }
        }
        if ("ClassDiagram".equals(this.myDiagramType)) {
            if (entity2.getPropertyValue("$name").equals(this.myDiagramName)) {
                Diagnostic.print("ClassDiagram should not be created");
                this.myRwiDiagram = XMI11Import.getDefaultReferenceCollection(entity2);
                bl = false;
                Diagnostic.print("Default diagram1: " + this.myRwiDiagram + " : " + (this.myRwiDiagram == null ? "" : this.myRwiDiagram.getPropertyValue("$name")));
            } else {
                this.myRwiDiagram = XMI11Import.createRwiDiagram(entity2, "Class Diagram");
            }
        } else if ("PackageDiagram".equals(this.myDiagramType)) {
            this.myRwiDiagram = XMI11Import.getDefaultReferenceCollection(entity2);
            bl = false;
            Diagnostic.print("Default diagram2: " + this.myRwiDiagram + " : " + (this.myRwiDiagram == null ? "" : this.myRwiDiagram.getPropertyValue("$name")));
        } else {
            this.myRwiDiagram = "UseCaseDiagram".equals(this.myDiagramType) ? XMI11Import.createRwiDiagram(entity2, "Use Case Diagram") : (TYPE_SEQUENCEDIAGRAM.equals(this.myDiagramType) ? XMI11Import.createRwiDiagram(entity2, "Sequence Diagram") : (TYPE_COLLABORATIONDIAGRAM.equals(this.myDiagramType) ? XMI11Import.createRwiDiagram(entity2, "Collaboration Diagram") : ("StateDiagram".equals(this.myDiagramType) ? XMI11Import.createRwiDiagram(entity2, "State Diagram") : ("ActivityDiagram".equals(this.myDiagramType) ? XMI11Import.createRwiDiagram(entity2, "Activity Diagram") : (NAME_MODULEDIAGRAM.equals(this.myDiagramType) ? XMI11Import.createRwiDiagram(entity2, "Component Diagram") : ("DeploymentDiagram".equals(this.myDiagramType) ? XMI11Import.createRwiDiagram(entity2, "Deployment Diagram") : null))))));
        }
        if (this.myRwiDiagram != null) {
            Diagnostic.print("Diagram (" + this.myID + ") " + this.myRwiDiagram.getPropertyValue("$metaclass") + " created ");
            XMI11Import.addElement(this.myID, this.myRwiDiagram);
        } else {
            Diagnostic.print("Failed to create Diagram ");
        }
        if (bl && this.myRwiDiagram != null && this.myDiagramName != null && this.myDiagramName.length() != 0) {
            Diagnostic.print("Setting name " + this.myDiagramName);
            if (this.myRwiDiagram.canSetPropertyValue("$name", this.myDiagramName)) {
                this.myRwiDiagram.setPropertyValue("$name", this.myDiagramName);
            } else {
                Diagnostic.print("canSetPropertyValue(name) == false, isDeleted() == " + this.myRwiDiagram.isDeleted());
            }
        }
        return this.myRwiDiagram;
    }

    public void writeXMI11Element() throws Exception {
    }

    public boolean isPackageDefaultDiagram() {
        return XMIDiagram.isPackageDefaultDiagram(this.myRwiDiagram);
    }

    public static boolean isPackageDefaultDiagram(Entity entity) {
        if (entity == null) {
            return false;
        }
        return entity.hasPropertyValue("$metaclass", "Package");
    }

    public void writeXMI11Diagram() throws Exception {
        if (this.myExported) {
            return;
        }
        this.myWriter.writeStartTag("UML", DIAGRAM);
        this.myWriter.writeAttribute("xmi.id", this.myID);
        this.myWriter.writeAttribute("name", this.myDiagramName, true);
        this.myWriter.writeAttribute(TOOLNAME, "Rational Rose 98");
        this.myWriter.writeAttribute(DIAGRAMTYPE, InterchangeUtils.convertConstants(this.myDiagramType));
        this.myWriter.writeAttribute(STYLE, "");
        this.myWriter.writeCloseBrasket();
        this.myWriter.writeStartTag("UML", DIAGRAM_OWNER, true);
        this.myWriter.writeStartTag("Foundation.Core.ModelElement");
        if (this.myOwnerID == null || this.myOwnerID.length() == 0) {
            this.myOwnerID = XMI11Export.getMainModelID();
        }
        this.myWriter.writeAttribute("xmi.idref", this.myOwnerID);
        this.myWriter.writeCloseBrasket(true);
        this.myWriter.writeEndTag("UML", DIAGRAM_OWNER);
        this.myWriter.writeStartTag("UML", DIAGRAM_ELEMENT, true);
        this.myElementViewCollector.write(this.myWriter);
        this.myWriter.writeEndTag("UML", DIAGRAM_ELEMENT);
        this.myWriter.writeEndTag("UML", DIAGRAM);
    }

    private String checkPackageDiagram(Entity entity) {
        Entity entity2;
        String string = XMI11Export.getElementID(entity);
        String string2 = entity.getPropertyValue("$metaclass");
        if ("Package Diagram".equals(string2) && (entity2 = entity.getParent()) != null) {
            string = XMI11Export.getElementID(entity2);
        }
        return string;
    }

    protected void collectElements(ReferenceEnumeration referenceEnumeration) {
        Entity entity = null;
        while (referenceEnumeration.hasMoreElements()) {
            Reference reference = referenceEnumeration.next();
            entity = reference.getEntity();
            if (entity == null || entity.isDeleted()) continue;
            String string = entity.getPropertyValue("$metaclass");
            String string2 = null;
            if (XMI11Export.hasElementID(entity)) {
                if (string.endsWith(DIAGRAM)) {
                    if (XMI11Export.isTCCSpecificExport() || "Package Diagram".equals(string)) {
                        string2 = this.checkPackageDiagram(entity);
                        this.addElementView(entity, string2, reference);
                    }
                } else {
                    string2 = XMI11Export.getElementID(entity);
                    this.addElementView(entity, string2, reference);
                }
            } else if (XMI11Export.hasModelID(entity)) {
                string2 = XMI11Export.getModelID(entity);
                this.addElementView(entity, string2, reference);
            } else if (XMI11Export.hasDiagramElementID(entity)) {
                string2 = XMI11Export.getDiagramElementID(entity);
                this.addElementView(entity, string2, reference);
            } else if ((XMI11Export.isTCCSpecificExport() || "Package Diagram".equals(string)) && string.endsWith(DIAGRAM)) {
                string2 = this.checkPackageDiagram(entity);
                this.addElementView(entity, string2, reference);
            }
            this.collectElements(reference.references());
        }
    }

    public static int width() {
        return ourW;
    }

    public static int height() {
        return ourH;
    }
}

