/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.elements;

import com.togethersoft.selena.xmi.elements.XMIDiagram;
import com.togethersoft.selena.xmi.elements.XMIElementImpl;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.InterchangeUtils;
import com.togethersoft.selena.xmi.util.XMI11Export;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.enum.ElementEnumeration;
import com.tssap.selena.model.enum.EntityEnumeration;

public class XMIDependency
extends XMIElementImpl {
    public static final String DEPENDENCY = "Dependency";
    public static final String DEPENDENCY_CLIENT = "Dependency.client";
    public static final String DEPENDENCY_SUPPLIER = "Dependency.supplier";
    public static final String SUPPORTS_LINK_TYPE = "supports";
    public static final int ROLE_SUPPLIER = 1;
    public static final int ROLE_CLIENT = 2;
    private String mySupplierID;
    private String myClientID;
    private String myLabel;

    public XMIDependency() {
        this.myName = DEPENDENCY;
    }

    public XMIDependency(XMLWriter xMLWriter, Entity entity, XMIDiagram xMIDiagram) {
        super(xMLWriter, entity, xMIDiagram);
        this.myID = XMI11Export.getModelID(this.myElement);
        this.myName = DEPENDENCY;
        this.writeTaggedValues();
    }

    public Entity setProperty(String string, String string2) throws XMIException {
        if (string2 == null) {
            return this.myElement;
        }
        if ("xmi.id".equals(string) && string2.length() != 0) {
            this.myID = string2;
            XMI11Import.addDependency(this.myID, this);
        } else if ("name".equals(string)) {
            this.myLabel = string2;
        } else if ("supplier".equals(string)) {
            this.mySupplierID = string2;
        } else if ("client".equals(string)) {
            this.myClientID = string2;
        }
        return this.myElement;
    }

    public void setReference(int n, String string) throws XMIException {
        if (n == 1) {
            this.setSupplier(string);
        } else if (n == 2) {
            this.setClient(string);
        }
    }

    public Entity createRwiElement() throws XMIException {
        if (this.myID == null) {
            this.myID = "";
        }
        Diagnostic.print("Creating dependency link " + this.myID);
        Entity entity = XMI11Import.getElement(this.mySupplierID);
        Entity entity2 = XMI11Import.getElement(this.myClientID);
        if (entity == null) {
            throw new XMIException("xmi.import.error.cannot.find.dependency.supplier", this.mySupplierID, this.myID);
        }
        if (entity2 == null) {
            throw new XMIException("xmi.import.error.cannot.find.dependency.client", this.myClientID, this.myID);
        }
        String string = entity2.getPropertyValue("$metaclass");
        String string2 = entity2.getPropertyValue("$name");
        String string3 = entity.getPropertyValue("$metaclass");
        String string4 = entity.getPropertyValue("$name");
        Entity entity3 = this.myElement = "Object".equals(entity2.getPropertyValue("$metaclass")) ? XMIDependency.getChildDependencyLink(entity2) : null;
        if (this.myElement == null) {
            if (entity2.canCreateChildEntity("Dependency Link", null)) {
                this.myElement = entity2.createChildEntity("Dependency Link", null);
                this.myElement.setParticipant("Supplier", null, (Element)entity);
            } else {
                throw new XMIException("xmi.import.error.cannot.create.link2", new String[]{"Dependency Link", this.myID, string, string2, string3, string4});
            }
        }
        if (this.myElement == null) {
            throw new XMIException("xmi.import.error.cannot.create.link2", new String[]{"Dependency Link", this.myID, string, string2, string3, string4});
        }
        if (this.myLabel != null && this.myLabel.length() != 0 && this.myElement.canSetPropertyValue("@label", this.myLabel)) {
            this.myElement.setPropertyValue("@label", this.myLabel);
        }
        if (this.myElement != null) {
            Diagnostic.print(this.myElement.getPropertyValue("$metaclass") + " '" + this.myElement.getPropertyValue("$name") + "' created successfully");
        } else {
            Diagnostic.print("Failed to create Dependency link");
        }
        return this.myElement;
    }

    public static Entity getChildDependencyLink(Entity entity) {
        EntityEnumeration entityEnumeration = entity.childEntities();
        while (entityEnumeration.hasMoreElements()) {
            Entity entity2 = entityEnumeration.next();
            String string = entity2.getPropertyValue("$metaclass");
            if (!"Dependency Link".equals(string)) continue;
            return entity2;
        }
        return null;
    }

    public void setSupplier(String string) {
        this.mySupplierID = string;
    }

    public void setClient(String string) {
        this.myClientID = string;
    }

    public void writeXMI11Element() throws Exception {
        super.writeXMI11Element();
        Entity entity = this.myElement;
        Entity entity2 = null;
        ElementEnumeration elementEnumeration = entity.participants("Supplier");
        if (elementEnumeration.hasMoreElements()) {
            entity2 = (Entity)elementEnumeration.next();
        }
        if (entity2 != null && entity2.hasPropertyValue("$metaclass", "DesignDiagram")) {
            if ("Class Diagram".equals(entity2.getPropertyValue("$metaclass")) && XMIDiagram.isPackageDefaultDiagram(entity2) && !"<default>".equals(entity2.getPropertyValue("$name"))) {
                entity2 = InterchangeUtils.getContainingPackage(entity2);
            } else {
                return;
            }
        }
        if (!XMI11Export.isInProject(entity2)) {
            return;
        }
        Entity entity3 = null;
        ElementEnumeration elementEnumeration2 = entity.participants("Client");
        if (elementEnumeration2.hasMoreElements()) {
            entity3 = (Entity)elementEnumeration2.next();
        }
        if (entity3 != null && entity3.hasPropertyValue("$metaclass", "DesignDiagram")) {
            if ("Class Diagram".equals(entity3.getPropertyValue("$metaclass")) && XMIDiagram.isPackageDefaultDiagram(entity3) && !"<default>".equals(entity3.getPropertyValue("$name"))) {
                entity3 = InterchangeUtils.getContainingPackage(entity3);
            } else {
                return;
            }
        }
        if (!this.isRoseCompatible(entity2) || !this.isRoseCompatible(entity3)) {
            return;
        }
        this.writeElementComments(entity3, entity2);
        String string = entity3.getPropertyValue("$metaclass");
        this.myClientID = "Node".equals(string) || "Object".equals(string) ? XMI11Export.getModelID(entity3) : XMI11Export.getElementID(entity3);
        String string2 = entity2.getPropertyValue("$metaclass");
        this.mySupplierID = "Node".equals(string2) || "Object".equals(string2) ? XMI11Export.getModelID(entity2) : XMI11Export.getElementID(entity2);
        this.myWriter.writeStartTag("UML", this.myName);
        this.myWriter.writeAttribute("xmi.id", this.myID);
        this.myLabel = entity.getPropertyValue("@label");
        this.myWriter.writeAttribute("name", this.myLabel, true);
        this.myWriter.writeAttribute("visibility", "public");
        this.myWriter.writeAttribute("isSpecification", "false");
        if (!XMI11Export.isUnisysExport()) {
            this.myWriter.writeAttribute("supplier", this.mySupplierID);
            this.myWriter.writeAttribute("client", this.myClientID);
        }
        this.writeStereotype();
        this.myWriter.writeCloseBrasket();
        String string3 = this.myElement.getPropertyValue("$metaclass");
        if (XMI11Export.isUnisysExport()) {
            this.myWriter.writeStartTag("UML", DEPENDENCY_CLIENT, true);
            this.myWriter.writeStartTag("Foundation.Core.ModelElement");
            this.myWriter.writeAttribute("xmi.idref", this.myClientID);
            this.myWriter.writeCloseBrasket(true);
            this.myWriter.writeEndTag("UML", DEPENDENCY_CLIENT);
            this.myWriter.writeStartTag("UML", DEPENDENCY_SUPPLIER, true);
            this.myWriter.writeStartTag("Foundation.Core.ModelElement");
            this.myWriter.writeAttribute("xmi.idref", this.mySupplierID);
            this.myWriter.writeCloseBrasket(true);
            this.myWriter.writeEndTag("UML", DEPENDENCY_SUPPLIER);
        }
        this.myWriter.writeEndTag("UML", this.myName);
    }
}

