/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.elements;

import com.togethersoft.selena.xmi.elements.XMIAbstractElement;
import com.togethersoft.selena.xmi.elements.XMIAssociation;
import com.togethersoft.selena.xmi.elements.XMIClassifierRole;
import com.togethersoft.selena.xmi.elements.XMIDependency;
import com.togethersoft.selena.xmi.elements.XMIDiagram;
import com.togethersoft.selena.xmi.elements.XMIElement;
import com.togethersoft.selena.xmi.elements.XMIElementImpl;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.ElementWriter;
import com.togethersoft.selena.xmi.util.XMI11Export;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.enum.EntityEnumeration;
import java.util.Enumeration;
import java.util.Vector;

public class XMIComponent
extends XMIElementImpl {
    public static final String COMPONENT = "Component";
    public static final String STYLE_CATEGORY = "Category";
    public static final String STYLE_MODULE = "Module";

    public XMIComponent() {
        this.myName = COMPONENT;
    }

    public XMIComponent(XMLWriter xMLWriter, Entity entity, XMIDiagram xMIDiagram) {
        super(xMLWriter, entity, xMIDiagram);
        this.myName = COMPONENT;
        this.myID = XMI11Export.getElementID(this.myElement);
        this.writeTaggedValues();
    }

    public void writeXMI11Element() throws Exception {
        super.writeXMI11Element();
        if (!this.isRoseCompatible()) {
            return;
        }
        if (XMI11Export.isExported(this.myElement)) {
            return;
        }
        XMI11Export.addExportedElement(this.myElement, this.myID);
        String string = this.myElement.getPropertyValue("$name");
        Diagnostic.print("Writing out " + this.myName + ", name = " + string + ", id = " + this.myID);
        this.myWriter.writeStartTag("UML", this.myName);
        this.myWriter.writeAttribute("xmi.id", this.myID);
        this.myWriter.writeAttribute("name", string, true);
        this.myWriter.writeAttribute("visibility", this.visibilityValue());
        this.myWriter.writeAttribute("isSpecification", this.isSpecificationValue());
        this.writeStereotype();
        if (this.myElement.childEntities().hasMoreElements() || this.myStereotype != null) {
            this.myWriter.writeCloseBrasket();
            Enumeration enumeration = this.writeXMI11Content();
            this.myWriter.writeEndTag("UML", this.myName);
            while (enumeration.hasMoreElements()) {
                XMIElement xMIElement = (XMIElement)enumeration.nextElement();
                xMIElement.writeXMI11Element();
            }
        } else {
            this.myWriter.writeCloseBrasket(true);
        }
    }

    public Entity createRwiElement(Entity entity) throws XMIException {
        if (entity == null) {
            throw new XMIException("xmi.import.error.cannot.create", COMPONENT);
        }
        if (!entity.canCreateChildEntity(COMPONENT, null)) {
            throw new XMIException("xmi.import.error.cannot.create", this.myName);
        }
        this.myElement = entity.createChildEntity(COMPONENT, null);
        if (this.myElement != null) {
            Diagnostic.print(this.myElement.getPropertyValue("$metaclass") + " '" + this.myElement.getPropertyValue("$name") + "' created successfully");
        } else {
            Diagnostic.print("Failed to create RwiElement");
        }
        return this.myElement;
    }

    public Entity setProperty(String string, String string2) throws XMIException {
        if (string == null || string.length() == 0 || string2 == null) {
            throw new XMIException("xmi.import.error.cannot.set.property", string);
        }
        if ("xmi.id".equals(string) && string2.length() != 0) {
            this.myID = string2;
            XMI11Import.addElement(string2, this.myElement);
        }
        if ("name".equals(string)) {
            Entity entity = this.myElement;
            this.myElement = XMIAbstractElement.setRwiName(this.myElement, string2);
            XMI11Import.replaceElement(entity, this.myElement);
        }
        return this.myElement;
    }

    protected Enumeration writeXMI11Content() throws Exception {
        EntityEnumeration entityEnumeration = this.myElement.childEntities();
        Vector vector = new Vector();
        while (entityEnumeration.hasMoreElements()) {
            Entity entity = entityEnumeration.next();
            String string = entity.getPropertyValue("$metaclass");
            String string2 = entity.getPropertyValue("$name");
            if ("Dependency Link".equals(string)) {
                if (this.myDiagram != null) {
                    this.myDiagram.addDependency(entity);
                }
                if (XMI11Export.isUnisysExport()) {
                    this.myWriter.writeStartTag("UML", "ModelElement.supplierDependency", true);
                    this.myWriter.writeStartTag("Foundation.Core.Dependency");
                    this.myWriter.writeAttribute("xmi.idref", XMI11Export.getModelID(entity));
                    this.myWriter.writeCloseBrasket(true);
                    this.myWriter.writeEndTag("UML", "ModelElement.supplierDependency");
                }
                XMI11Export.addDependency(new XMIDependency(this.myWriter, entity, this.myDiagram));
                continue;
            }
            if ("Association Link".equals(string)) {
                XMI11Export.addAssociation(new XMIAssociation(this.myWriter, entity, this.myDiagram));
                continue;
            }
            if ("Object".equals(string)) {
                this.myWriter.writeStartTag("UML", "Namespace.ownedElement", true);
                XMIClassifierRole xMIClassifierRole = new XMIClassifierRole(this.myWriter, entity, null);
                xMIClassifierRole.writeXMI11Element();
                this.myWriter.writeEndTag("UML", "Namespace.ownedElement");
                continue;
            }
            this.myWriter.writeStartTag("UML", "Namespace.ownedElement", true);
            ElementWriter.writeElement(this.myWriter, entity, null, true);
            this.myWriter.writeEndTag("UML", "Namespace.ownedElement");
        }
        return vector.elements();
    }
}

