/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.elements;

import com.togethersoft.selena.xmi.elements.XMIDiagram;
import com.togethersoft.selena.xmi.elements.XMIElementImpl;
import com.togethersoft.selena.xmi.elements.XMITaggedValue;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.TextUtil;
import com.togethersoft.selena.xmi.util.XMI11Export;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.util.XMIInterchangeMessages;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.enum.ElementEnumeration;
import com.tssap.selena.model.enum.EntityEnumeration;
import java.util.Enumeration;
import java.util.Vector;

public class XMIComment
extends XMIElementImpl {
    public static final String COMMENT = "Comment";
    public static final String COMMENT_ANNOTATEDELEMENT = "Comment.annotatedElement";
    public static final String ROSE_ANNOTATEDELEMENT = "annotatedElement";

    public XMIComment() {
    }

    public XMIComment(XMLWriter xMLWriter, Entity entity, XMIDiagram xMIDiagram) {
        super(xMLWriter, entity, xMIDiagram);
        this.myID = XMI11Export.getDiagramElementID(this.myElement);
        this.myName = COMMENT;
        String string = "Note:Font.Blue= 0,Font.Green= 0,Font.Red= 0,Font.FaceName=Arial,Font.Size= 10,Font.Bold=0,Font.Italic=0,Font.Strikethrough=0,Font.Underline=0,LineColor.Blue= 51,LineColor.Green= 0,LineColor.Red= 153,FillColor.Blue= 204,FillColor.Green= 255,FillColor.Red= 255,FillColor.Transparent=1,";
        this.writeTaggedValues();
    }

    private Enumeration collectAnnotatedElements() {
        Vector<String> vector = new Vector<String>();
        EntityEnumeration entityEnumeration = this.myElement.childEntities();
        if (entityEnumeration.hasMoreElements()) {
            while (entityEnumeration.hasMoreElements()) {
                Entity entity = entityEnumeration.next();
                Entity entity2 = null;
                ElementEnumeration elementEnumeration = entity.participants("Supplier");
                if (elementEnumeration.hasMoreElements()) {
                    entity2 = (Entity)elementEnumeration.next();
                }
                if (entity2 == null || entity2.hasPropertyValue("$metaclass", "DesignDiagram")) continue;
                String string = entity2.getPropertyValue("$metaclass");
                String string2 = null;
                string2 = "Object".equals(string) || "Node".equals(string) || "State".equals(string) || "Start State".equals(string) || "End State".equals(string) || "Decision".equals(string) || "Activity".equals(string) || "Synchronization Bar".equals(string) || "Synchronization Bar".equals(string) || "History".equals(string) ? XMI11Export.getModelID(entity2) : XMI11Export.getElementID(entity2);
                vector.add(string2);
            }
        }
        return vector.elements();
    }

    public void writeXMI11Element() throws Exception {
        String string;
        super.writeXMI11Element();
        if (XMI11Export.isExported(this.myElement)) {
            return;
        }
        XMI11Export.addExportedElement(this.myElement, this.myID);
        String string2 = this.myElement.getPropertyValue("$note_text");
        Diagnostic.print("Writing out " + this.myName + ", text = " + string2 + ", id = " + this.myID);
        this.myWriter.writeStartTag("UML", this.myName);
        this.myWriter.writeAttribute("xmi.id", this.myID);
        this.myWriter.writeAttribute("visibility", this.visibilityValue());
        this.myWriter.writeAttribute("isSpecification", this.isSpecificationValue());
        this.writeStereotype();
        Enumeration enumeration = this.collectAnnotatedElements();
        if (XMI11Export.isRoseSpecificExport()) {
            if (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                this.myWriter.writeAttribute(ROSE_ANNOTATEDELEMENT, string);
                if (enumeration.hasMoreElements()) {
                    Diagnostic.printError(XMIInterchangeMessages.getString("xmi.export.warning.notelink"), this.myElement.getModel().getUniqueName(), this.myElement.getUniqueName());
                }
            }
            if (string2 != null) {
                string2 = TextUtil.replace(string2, "\r", "");
                string2 = TextUtil.replace(string2, "\n", " ");
                this.myWriter.writeAttribute("name", string2);
            } else {
                this.myWriter.writeAttribute("name", "");
            }
            this.myWriter.writeCloseBrasket(true);
        } else {
            this.myWriter.writeCloseBrasket();
            this.myWriter.writeStartTag("UML", "ModelElement.name", true);
            if (string2 != null) {
                this.myWriter.writeCDATA(string2);
            }
            this.myWriter.writeEndTag("UML", "ModelElement.name");
            if (enumeration.hasMoreElements()) {
                this.myWriter.writeStartTag("UML", COMMENT_ANNOTATEDELEMENT, true);
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    if (XMI11Export.isUnisysExport()) {
                        this.myWriter.writeStartTag("Foundation.Core.ModelElement");
                        this.myWriter.writeAttribute("xmi.idref", string);
                        this.myWriter.writeCloseBrasket(true);
                        continue;
                    }
                    this.myWriter.writeStartTag("UML", "ModelElement");
                    this.myWriter.writeAttribute("xmi.idref", string);
                    this.myWriter.writeCloseBrasket(true);
                }
                this.myWriter.writeEndTag("UML", COMMENT_ANNOTATEDELEMENT);
            }
            this.myWriter.writeEndTag("UML", this.myName);
        }
        boolean bl = this.myElement.hasPropertyValue("text_only", "true");
        if (bl) {
            XMITaggedValue xMITaggedValue = new XMITaggedValue(this.myWriter, this.myID, "text_only", "");
            XMI11Export.addTaggedValue(xMITaggedValue);
        }
    }

    public Entity createRwiElement(Entity entity) throws XMIException {
        if (entity == null) {
            throw new XMIException("xmi.import.error.cannot.create.null", "Note");
        }
        if (!entity.canCreateChildEntity("Note", null)) {
            throw new XMIException("xmi.import.error.cannot.create", "Note");
        }
        this.myElement = entity.createChildEntity("Note", null);
        return this.myElement;
    }

    public void setText(String string) throws XMIException {
        if (this.myElement == null) {
            throw new XMIException("xmi.import.error.cannot.set.property.null", "$note_text");
        }
        if (string != null) {
            string = TextUtil.replace(string, "&#x000d;&#x000a;", "\n");
        }
        if (!this.myElement.canSetPropertyValue("$note_text", string)) {
            throw new XMIException("xmi.import.error.cannot.set.property2", "$note_text", string);
        }
        this.myElement.setPropertyValue("$note_text", string);
    }

    public void setValue(String string) {
        try {
            this.setText(string);
        }
        catch (XMIException xMIException) {
            xMIException.printStackTrace();
        }
    }

    public Entity setProperty(String string, String string2) throws XMIException {
        if (string == null || string.length() == 0 || string2 == null) {
            return this.myElement;
        }
        if ("name".equals(string)) {
            this.setText(string2);
        } else if (ROSE_ANNOTATEDELEMENT.equals(string) && string2.length() != 0) {
            Diagnostic.print("Setting comment reference " + string2);
            XMI11Import.addNoteLink(this, string2);
        } else if ("xmi.id".equals(string) && string2.length() != 0) {
            this.myID = string2;
            XMI11Import.addElement(string2, this.myElement);
        }
        return this.myElement;
    }

    public void setReference(String string) throws XMIException {
        Diagnostic.print("Setting comment reference " + string);
        XMI11Import.addNoteLink(this, string);
    }
}

