/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.elements;

import com.togethersoft.selena.xmi.elements.XMIAbstractElement;
import com.togethersoft.selena.xmi.elements.XMIAction;
import com.togethersoft.selena.xmi.elements.XMIAssociationRole;
import com.togethersoft.selena.xmi.elements.XMIClassifierRole;
import com.togethersoft.selena.xmi.elements.XMIDiagram;
import com.togethersoft.selena.xmi.elements.XMIInteraction;
import com.togethersoft.selena.xmi.elements.XMIMessage;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.ElementCollector;
import com.togethersoft.selena.xmi.util.XMI11Export;
import com.togethersoft.selena.xmi.util.XMIElementCollector;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.model.elements.Entity;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class XMICollaboration
extends XMIAbstractElement {
    public static final String COLLABORATION = "Collaboration";
    public static final String COLLABORATION_INTERACTION = "Collaboration.interaction";
    private XMIElementCollector ourClassifierRoleCollector;
    private XMIElementCollector ourAssociationRoleCollector;
    private XMIElementCollector ourActionCollector;
    private XMIElementCollector ourMessageCollector;
    private Hashtable myInteractions;
    private Vector myInteractions2;

    public XMICollaboration() {
    }

    public XMICollaboration(XMLWriter xMLWriter) {
        super(xMLWriter);
        this.myName = COLLABORATION;
        this.myID = XMI11Export.getElementID(this);
        this.myInteractions = new Hashtable();
        this.myInteractions2 = new Vector();
        this.ourClassifierRoleCollector = new XMIElementCollector(true);
        this.ourAssociationRoleCollector = new XMIElementCollector(true);
        this.ourMessageCollector = new XMIElementCollector();
        this.ourActionCollector = new XMIElementCollector(true);
    }

    public void writeXMI11Element() throws Exception {
        Diagnostic.print("Writing out Collaboration");
        if (this.ourClassifierRoleCollector.isEmpty()) {
            return;
        }
        this.myWriter.writeStartTag("UML", this.myName);
        this.myWriter.writeAttribute("xmi.id", this.myID);
        String string = COLLABORATION;
        this.myWriter.writeAttribute("name", string, true);
        this.myWriter.writeAttribute("visibility", "public");
        this.myWriter.writeAttribute("isSpecification", "false");
        this.myWriter.writeAttribute("isAbstract", "false");
        this.myWriter.writeCloseBrasket();
        this.writeXMI11Content();
        this.myWriter.writeEndTag("UML", this.myName);
        this.ourActionCollector.write(this.myWriter);
    }

    public String createInteraction(XMLWriter xMLWriter, XMIDiagram xMIDiagram) {
        Entity entity = xMIDiagram.getPhysicalDiagram();
        if (entity != null) {
            XMIInteraction xMIInteraction = new XMIInteraction(xMLWriter, xMIDiagram);
            this.myInteractions.put(entity, xMIInteraction);
            return xMIInteraction.getId();
        }
        return null;
    }

    public String createInteraction(XMLWriter xMLWriter) {
        XMIInteraction xMIInteraction = new XMIInteraction(xMLWriter);
        this.myInteractions2.add(xMIInteraction);
        return xMIInteraction.getId();
    }

    public void addClassifierRole(XMIClassifierRole xMIClassifierRole) {
        this.ourClassifierRoleCollector.addXMIElement(xMIClassifierRole);
    }

    public void addAssociationRole(XMIAssociationRole xMIAssociationRole) {
        this.ourAssociationRoleCollector.addXMIElement(xMIAssociationRole);
    }

    public void addAction(XMIAction xMIAction) {
        this.ourActionCollector.addXMIElement(xMIAction);
    }

    public void addMessage(XMIMessage xMIMessage) {
        this.ourMessageCollector.addXMIElement(xMIMessage);
    }

    public ElementCollector getMessages() {
        return this.ourMessageCollector;
    }

    protected void writeXMI11Content() throws Exception {
        XMIInteraction xMIInteraction;
        Object object;
        this.myWriter.writeStartTag("UML", "Namespace.ownedElement", true);
        this.ourClassifierRoleCollector.write(this.myWriter);
        this.ourAssociationRoleCollector.write(this.myWriter);
        this.myWriter.writeEndTag("UML", "Namespace.ownedElement");
        this.myWriter.writeStartTag("UML", COLLABORATION_INTERACTION, true);
        Enumeration enumeration = this.myInteractions.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            xMIInteraction = (XMIInteraction)this.myInteractions.get(object);
            if (xMIInteraction == null) continue;
            xMIInteraction.writeXMI11Element();
        }
        object = this.myInteractions2.elements();
        while (object.hasMoreElements()) {
            xMIInteraction = (XMIInteraction)object.nextElement();
            if (xMIInteraction == null) continue;
            xMIInteraction.writeXMI11Element();
        }
        this.myWriter.writeEndTag("UML", COLLABORATION_INTERACTION);
    }
}

