/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.elements;

import com.togethersoft.selena.xmi.elements.BooleanUtil;
import com.togethersoft.selena.xmi.elements.XMIAbstractElement;
import com.togethersoft.selena.xmi.elements.XMIAssociation;
import com.togethersoft.selena.xmi.elements.XMIAssociationRole;
import com.togethersoft.selena.xmi.elements.XMIDependency;
import com.togethersoft.selena.xmi.elements.XMIDiagram;
import com.togethersoft.selena.xmi.elements.XMIElementImpl;
import com.togethersoft.selena.xmi.elements.XMIMessage;
import com.togethersoft.selena.xmi.elements.XMIMultiplicity;
import com.togethersoft.selena.xmi.elements.XMITransition;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.XMI11Export;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.enum.ElementEnumeration;
import com.tssap.selena.model.enum.EntityEnumeration;
import java.util.ArrayList;
import java.util.Vector;

public class XMIClassifierRole
extends XMIElementImpl {
    public static final String CLASSIFIERROLE = "ClassifierRole";
    public static final String CLASSIFIERROLE_MULTIPLICITY = "ClassifierRole.multiplicity";
    public static final String CLASSIFIERROLE_BASE = "ClassifierRole.base";
    public static final String CLASSIFIERROLE_MESSAGE = "ClassifierRole.message";
    private Vector myMessages;
    private String myBase;
    private boolean myBaseAllowed;
    private boolean myMessageAllowed;
    private boolean myNeedCloseTag = true;
    private ArrayList myDependencyToBaseClass;
    private Vector myDependencies;

    public XMIClassifierRole() {
        this.myMessages = new Vector();
        this.myBaseAllowed = false;
        this.myMessageAllowed = false;
    }

    public XMIClassifierRole(XMLWriter xMLWriter, Entity entity, XMIDiagram xMIDiagram) {
        super(xMLWriter, entity, xMIDiagram);
        this.myName = CLASSIFIERROLE;
        this.myID = XMI11Export.getModelID(this.myElement);
        this.myDependencyToBaseClass = new ArrayList();
        this.myDependencies = new Vector();
        this.writePersistence();
        this.writeTaggedValues();
    }

    public void writeXMI11Element() throws Exception {
        super.writeXMI11Element();
        if (!this.isRoseCompatible()) {
            return;
        }
        if (XMI11Export.isExported(this.myElement)) {
            return;
        }
        XMI11Export.addExportedElement(this.myElement, this.myID);
        String string = this.myElement.getPropertyValue("$name");
        Diagnostic.print("Writing out " + this.myName + ", name = " + string + ", id = " + this.myID);
        this.myWriter.writeStartTag("UML", this.myName);
        this.myWriter.writeAttribute("xmi.id", this.myID);
        this.myWriter.writeAttribute("name", string, true);
        this.myWriter.writeAttribute("visibility", this.visibilityValue());
        this.myWriter.writeAttribute("isSpecification", this.isSpecificationValue());
        this.myWriter.writeAttribute("isAbstract", this.isAbstractValue(), true);
        this.writeStereotype();
        this.myWriter.writeCloseBrasket();
        this.myWriter.writeStartTag("UML", CLASSIFIERROLE_MULTIPLICITY, true);
        new XMIMultiplicity(this.myWriter, "1").writeXMI11Element();
        this.myWriter.writeEndTag("UML", CLASSIFIERROLE_MULTIPLICITY);
        Entity entity = null;
        entity = this.findInstantiatedClass();
        Diagnostic.print("Instantiated Class " + entity);
        String string2 = null;
        if (entity != null) {
            if (!XMI11Export.isInProject(entity)) {
                XMI11Export.addOutOfScopeElement(entity, XMI11Export.getElementID(entity));
            }
            string2 = XMI11Export.getElementID(entity);
        } else if (XMI11Export.isRoseSpecificExport()) {
            string2 = XMI11Export.addDummyClass();
        }
        this.myWriter.writeStartTag("UML", CLASSIFIERROLE_BASE, true);
        if (XMI11Export.isUnisysExport()) {
            this.myWriter.writeStartTag("Foundation.Core.Classifier");
            this.myWriter.writeAttribute("xmi.idref", string2);
            this.myWriter.writeCloseBrasket(true);
        } else {
            this.myWriter.writeStartTag("UML", "Classifier");
            this.myWriter.writeAttribute("xmi.idref", string2);
            this.myWriter.writeCloseBrasket(true);
        }
        this.myWriter.writeEndTag("UML", CLASSIFIERROLE_BASE);
        this.writeXMI11Content();
        this.myWriter.writeEndTag("UML", this.myName);
        int n = 0;
        while (n < this.myDependencies.size()) {
            ((XMIDependency)this.myDependencies.get(n)).writeXMI11Element();
            ++n;
        }
    }

    private Entity findInstantiatedClass() {
        Entity entity = null;
        EntityEnumeration entityEnumeration = this.myElement.childEntities();
        while (entityEnumeration.hasMoreElements()) {
            ElementEnumeration elementEnumeration;
            Entity entity2 = entityEnumeration.next();
            String string = entity2.getPropertyValue("$metaclass");
            if (!"Dependency Link".equals(string) || !(elementEnumeration = entity2.participants("Supplier")).hasMoreElements()) continue;
            entity = (Entity)elementEnumeration.next();
            if ("Class".equals(entity.getPropertyValue("$metaclass"))) {
                this.myDependencyToBaseClass.add(entity2);
                Diagnostic.print("Found baseClass: " + entity.getPropertyValue("$name"));
                break;
            }
            Diagnostic.print("NOT Found baseClass");
            entity = null;
        }
        return entity;
    }

    public Entity createRwiElement(Entity entity) throws XMIException {
        Diagnostic.print("Creating object ");
        this.myElement = null;
        if (entity == null) {
            Diagnostic.print("Parent null, cannot create Object");
            return null;
        }
        Diagnostic.print("Parent " + entity.getPropertyValue("$metaclass") + " " + entity.getPropertyValue("$name"));
        if (!entity.canCreateChildEntity("Object", null)) {
            throw new XMIException("xmi.import.error.cannot.create", "Object");
        }
        this.myElement = entity.createChildEntity("Object", null);
        if (this.myElement != null) {
            Diagnostic.print(this.myElement.getPropertyValue("$metaclass") + " '" + this.myElement.getPropertyValue("$name") + "' created successfully");
        } else {
            Diagnostic.print("Failed to create RwiElement");
        }
        return this.myElement;
    }

    public Entity setProperty(String string, String string2) throws XMIException {
        if (string == null || string.length() == 0 || string2 == null) {
            throw new XMIException("xmi.import.error.cannot.set.property", string);
        }
        if ("xmi.id".equals(string) && string2.length() != 0) {
            this.myID = string2;
            XMI11Import.addElement(string2, this.myElement);
        } else if ("name".equals(string)) {
            Entity entity = this.myElement;
            this.myElement = XMIAbstractElement.setRwiName(this.myElement, string2);
            XMI11Import.replaceElement(entity, this.myElement);
        } else if ("base".equals(string)) {
            this.allowReference(true);
            this.setReference(string2);
            this.allowReference(false);
        } else if ("stereotype".equals(string) && this.myID != null) {
            XMI11Import.addStereotypeSeeks(this.myID, string2);
        }
        return this.myElement;
    }

    public void allowReference(boolean bl) {
        this.myBaseAllowed = bl;
    }

    public void setReference(String string) throws XMIException {
        if (this.myBaseAllowed) {
            this.myBase = string;
            if (string != null && string.length() != 0 && this.myElement != null) {
                XMI11Import.addBase(this, string);
            }
        }
    }

    public void allowMessage(boolean bl) {
        this.myMessageAllowed = bl;
    }

    public void addMessage(String string) throws XMIException {
        if (this.myMessageAllowed) {
            this.myMessages.add(string);
        }
    }

    public Vector getMessages() {
        return this.myMessages;
    }

    public void setBase(Entity entity) throws XMIException {
        Diagnostic.print("Set base to " + entity);
        if (entity == null) {
            return;
        }
        this.myElement = XMI11Import.getElement(this.myID);
        if (this.myElement == null) {
            throw new XMIException("xmi.import.error.cannot.set.base.for", "", "Object", this.myID);
        }
        Entity entity2 = XMIDependency.getChildDependencyLink(this.myElement);
        if (entity2 == null) {
            if (this.myElement.canCreateChildEntity("Dependency Link", null)) {
                entity2 = this.myElement.createChildEntity("Dependency Link", null);
                entity2.setParticipant("Supplier", null, (Element)entity);
                Diagnostic.print("Set base completed");
            } else {
                throw new XMIException("xmi.import.error.cannot.set.property2", "Supplier", entity.getPropertyValue("$name"));
            }
        }
    }

    public void setMultiplicity(String string) throws XMIException {
        if ("1..*".equals(string) || "0..*".equals(string)) {
            if (this.myElement.canSetPropertyValue("$multiple_instance", BooleanUtil.toString(true))) {
                this.myElement.setPropertyValue("$multiple_instance", BooleanUtil.toString(true));
            } else {
                throw new XMIException("xmi.import.error.cannot.set.property", "$multiple_instance");
            }
        }
    }

    protected void writeXMI11Content() throws Exception {
        EntityEnumeration entityEnumeration = this.myElement.childEntities();
        while (entityEnumeration.hasMoreElements()) {
            XMIElementImpl xMIElementImpl;
            Entity entity = entityEnumeration.next();
            String string = entity.getPropertyValue("$metaclass");
            Diagnostic.print("Next child, type = " + string);
            if ("Association Link".equals(string)) {
                xMIElementImpl = new XMIAssociation(this.myWriter, entity, this.myDiagram);
                XMI11Export.addAssociation((XMIAssociation)xMIElementImpl);
            } else if ("Message Link".equals(string)) {
                Object object;
                xMIElementImpl = new XMIAssociationRole(this.myWriter, entity, null);
                String string2 = xMIElementImpl.getId();
                if ("Messages Link".equals(string)) {
                    object = entity.childEntities();
                    while (object.hasMoreElements()) {
                        Entity entity2 = object.next();
                        string = entity2.getPropertyValue("$metaclass");
                        if (!"Message Link".equals(string)) continue;
                        XMIMessage xMIMessage = new XMIMessage(this.myWriter, entity2, this.myDiagram, string2);
                        xMIMessage.setParent(entity);
                        XMI11Export.addMessage(xMIMessage);
                        if (!XMI11Export.isUnisysExport()) continue;
                        this.myWriter.writeStartTag("UML", CLASSIFIERROLE_MESSAGE, true);
                        this.myWriter.writeStartTag("Behavioral_Elements.Collaborations.Message");
                        this.myWriter.writeAttribute("xmi.idref", xMIMessage.getId());
                        this.myWriter.writeCloseBrasket(true);
                        this.myWriter.writeEndTag("UML", CLASSIFIERROLE_MESSAGE);
                    }
                } else {
                    object = new XMIMessage(this.myWriter, entity, this.myDiagram, string2);
                    if (this.myDiagram != null) {
                        this.myDiagram.addMessage((XMIMessage)object);
                    } else {
                        XMI11Export.addMessage((XMIMessage)object);
                    }
                    if (XMI11Export.isUnisysExport()) {
                        this.myWriter.writeStartTag("UML", CLASSIFIERROLE_MESSAGE, true);
                        this.myWriter.writeStartTag("Behavioral_Elements.Collaborations.Message");
                        this.myWriter.writeAttribute("xmi.idref", ((XMIAbstractElement)object).getId());
                        this.myWriter.writeCloseBrasket(true);
                        this.myWriter.writeEndTag("UML", CLASSIFIERROLE_MESSAGE);
                    }
                }
            } else if ("Dependency Link".equals(string)) {
                xMIElementImpl = new XMIDependency(this.myWriter, entity, this.myDiagram);
                this.myDependencies.add(xMIElementImpl);
            }
            if (!"Object Flow".equals(string)) continue;
            if (!XMI11Export.isTCCSpecificExport()) {
                XMI11Export.addIncompatibleElement(entity, null);
                continue;
            }
            xMIElementImpl = new XMITransition(this.myWriter, entity, this.myDiagram);
            XMI11Export.addTransition((XMITransition)xMIElementImpl);
        }
    }
}

