/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.elements;

import com.togethersoft.selena.xmi.elements.BooleanUtil;
import com.togethersoft.selena.xmi.elements.XMIAbstractElement;
import com.togethersoft.selena.xmi.elements.XMIDiagram;
import com.togethersoft.selena.xmi.elements.XMIElement;
import com.togethersoft.selena.xmi.elements.XMIElementImpl;
import com.togethersoft.selena.xmi.elements.XMIGeneralization;
import com.togethersoft.selena.xmi.elements.XMIStereotype;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.ElementWriter;
import com.togethersoft.selena.xmi.util.InterchangeUtils;
import com.togethersoft.selena.xmi.util.XMI11Export;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.enum.EntityEnumeration;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class XMIClass
extends XMIElementImpl {
    public static final String CLASS = "Class";
    public static final String INTERFACE = "Interface";
    public static final String ACTOR = "Actor";
    public static final String USECASE = "UseCase";
    public static final String CLASS_ISACTIVE = "Class.isActive";
    private static Hashtable ourNameTable = new Hashtable();
    private Reference myReference;
    private Vector myDependencies;
    private boolean myVisible;
    private Entity myParent;
    private boolean myStereotypeNotPresent;
    private String myClassName;

    public XMIClass() {
    }

    public XMIClass(String string) {
        super(string);
    }

    public XMIClass(XMLWriter xMLWriter, Entity entity, XMIDiagram xMIDiagram) {
        super(xMLWriter, entity, xMIDiagram);
        this.init();
        this.myVisible = true;
    }

    public XMIClass(XMLWriter xMLWriter, Entity entity, XMIDiagram xMIDiagram, boolean bl) {
        super(xMLWriter, entity, xMIDiagram);
        this.init();
        this.myVisible = bl;
    }

    public void writeXMI11Element() throws Exception {
        Object object;
        String string;
        super.writeXMI11Element();
        Diagnostic.print("Writing Class " + this.myElement.getPropertyValue("$name"));
        if (!this.isRoseCompatible()) {
            return;
        }
        String string2 = this.myElement.getPropertyValue("$file");
        if (string2 != null && string2.endsWith(".exe")) {
            return;
        }
        if (XMI11Export.isExported(this.myElement)) {
            return;
        }
        XMI11Export.addExportedElement(this.myElement, this.myID);
        Entity entity = this.myElement.getParent();
        this.writeClassType();
        this.myWriter.writeStartTag("UML", this.myName);
        this.myWriter.writeAttribute("xmi.id", this.myID);
        String string3 = this.myElement.getPropertyValue("$name");
        this.myWriter.writeAttribute("name", string3, true);
        this.myWriter.writeAttribute("visibility", this.visibilityValue());
        this.myWriter.writeAttribute("isSpecification", this.isSpecificationValue());
        this.myWriter.writeAttribute("isAbstract", this.isAbstractValue(), true);
        if (this.myElement.hasProperty("$final")) {
            this.myWriter.writeAttribute("changeability", "frozen");
        }
        if (CLASS.equals(this.myName)) {
            this.myWriter.writeAttribute("isActive", this.isActiveValue());
        }
        if ("classifier".equals(this.ownerScopeValue())) {
            this.myWriter.writeAttribute("ownerScope", this.ownerScopeValue());
        }
        if ((string = this.myElement.getPropertyValue("namespace")) != null && string.length() != 0) {
            this.myWriter.writeAttribute("namespace", string);
        }
        if (!this.myStereotypeNotPresent) {
            // empty if block
        }
        this.writeStereotype();
        this.myWriter.writeCloseBrasket();
        if (this.myDiagram != null && XMI11Export.isUnisysExport()) {
            this.myWriter.writeStartTag("UML", "ModelElement.namespace", true);
            this.myWriter.writeStartTag("Foundation.Core.Namespace");
            this.myWriter.writeAttribute("xmi.idref", this.myDiagram.getId());
            this.myWriter.writeCloseBrasket(true);
            this.myWriter.writeEndTag("UML", "ModelElement.namespace");
        }
        String string4 = this.myElement.getPropertyValue("$extends");
        Model model = InterchangeUtils.getWizardData().getModel();
        Entity entity2 = null;
        if (string4 != null) {
            entity2 = (Entity)model.findElement(ModelAccess.createUniqueName((String)string4));
        }
        if (entity2 != null) {
            object = XMI11Export.getElementID(entity2);
            this.myWriter.writeStartTag("UML", "GeneralizableElement.generalization", true);
            if (XMI11Export.isUnisysExport()) {
                this.myWriter.writeStartTag("Foundation.Core.Generalization");
                this.myWriter.writeAttribute("xmi.id", (String)object);
                this.myWriter.writeCloseBrasket(true);
            } else {
                this.myWriter.writeStartTag("UML", "Generalization");
                this.myWriter.writeAttribute("xmi.idref", (String)object);
                this.myWriter.writeCloseBrasket(true);
            }
            this.myWriter.writeEndTag("UML", "GeneralizableElement.generalization");
        }
        object = this.writeXMI11Content();
        this.myWriter.writeEndTag("UML", this.myName);
        int n = 0;
        while (n < this.myDependencies.size()) {
            ElementWriter.writeElement(this.myWriter, (Entity)this.myDependencies.elementAt(n), this.myDiagram);
            ++n;
        }
        while (object.hasMoreElements()) {
            XMIElement xMIElement = (XMIElement)object.nextElement();
            xMIElement.writeXMI11Element();
        }
    }

    public Entity createRwiElement(Entity entity) throws XMIException {
        return this.createRwiElement(this.myName, entity);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Entity createRwiElement(String string, Entity entity) throws XMIException {
        try {
            Diagnostic.print("XMICLass.createRwiElement " + string + " on " + entity + " " + entity.getClass().getName());
            this.myParent = entity;
            if (entity == null) {
                throw new XMIException("xmi.import.error.cannot.create.null", string);
            }
            if (CLASS.equals(string)) {
                if (!this.myParent.canCreateChildEntity(CLASS, null)) throw new XMIException("xmi.import.error.cannot.create", CLASS);
                this.myElement = this.myParent.createChildEntity(CLASS, null);
                XMI11Import.needJavaNature();
            } else if (INTERFACE.equals(string)) {
                if (!this.myParent.canCreateChildEntity(INTERFACE, null)) throw new XMIException("xmi.import.error.cannot.create", INTERFACE);
                this.myElement = this.myParent.createChildEntity(INTERFACE, null);
                XMI11Import.needJavaNature();
            } else if (USECASE.equals(string)) {
                this.myElement = entity.createChildEntity("Use Case", null);
            } else {
                if (!ACTOR.equals(string)) throw new XMIException("xmi.import.error.cannot.create", string);
                this.myElement = entity.createChildEntity(ACTOR, null);
            }
            if (this.myElement == null) {
                throw new XMIException("xmi.import.error.cannot.create", string);
            }
            if (this.myElement != null) {
                Diagnostic.print(this.myElement.getPropertyValue("$metaclass") + " '" + this.myElement.getPropertyValue("$name") + "' created successfully");
                return this.myElement;
            } else {
                Diagnostic.print("Failed to create RwiElement");
            }
            return this.myElement;
        }
        catch (XMIException xMIException) {
            throw xMIException;
        }
        catch (Exception exception) {
            Diagnostic.printError(exception);
            throw new XMIException("xmi.import.error.cannot.create.exc", string, exception.getMessage());
        }
    }

    public Entity setProperty(String string, String string2) throws XMIException {
        super.setProperty(string, string2);
        if (this.myElement == null) {
            return null;
        }
        if ("xmi.id".equals(string) || "name".equals(string)) {
            if ("name".equals(string)) {
                this.myClassName = string2;
            }
            if (this.myID != null && this.myID.length() != 0 && this.myClassName != null && this.myClassName.length() != 0) {
                XMI11Import.addDatatype(this.myID, this.myClassName);
                Diagnostic.print("ADD DATATYPE, datatype \"" + this.myClassName + "\"[" + this.myID + "] added");
            }
        }
        if (("xmi.id".equals(string) || "stereotype".equals(string)) && string2 != null && string2.length() != 0) {
            XMIStereotype xMIStereotype = null;
            if ("xmi.id".equals(string)) {
                xMIStereotype = XMI11Import.getStereotype(this.myID);
            } else if ("stereotype".equals(string)) {
                xMIStereotype = XMI11Import.getStereotypeById(string2);
            }
            if (xMIStereotype != null) {
                String string3 = xMIStereotype.getName();
                Entity entity = null;
                try {
                    entity = this.createSpecificClass(this.myParent, string3);
                }
                catch (XMIException xMIException) {
                    Diagnostic.printError(xMIException);
                }
                if (entity != null) {
                    if (this.myElement != null) {
                        String string4 = this.myElement.getPropertyValue("$name");
                        entity.setPropertyValue("originalName", this.myElement.getPropertyValue("originalName"));
                        entity.setPropertyValue("$private", BooleanUtil.toString(this.myElement.hasProperty("$private")));
                        entity.setPropertyValue("$abstract", BooleanUtil.toString(this.myElement.hasProperty("$abstract")));
                        entity.setPropertyValue("$final", BooleanUtil.toString(this.myElement.hasProperty("$final")));
                        entity.setPropertyValue("$static", BooleanUtil.toString(this.myElement.hasProperty("$static")));
                        this.myElement.delete();
                        entity.setPropertyValue("$name", string4);
                        if ("xmi.id".equals(string)) {
                            XMI11Import.removeStereotype(this.myID);
                        } else if ("stereotype".equals(string)) {
                            XMI11Import.removeStereotypeById(string2);
                        }
                    }
                    this.myElement = entity;
                }
                if (this.myElement != null) {
                    XMI11Import.addElement(this.myID, this.myElement);
                }
            }
            if (this.myReference != null) {
                XMI11Import.addReference(this.myID, this.myReference);
            }
        } else if ("visibility".equals(string)) {
            if (CLASS.equals(this.myElement.getPropertyValue("$metaclass")) && !this.myElement.hasProperty("$interface")) {
                XMIAbstractElement.setVisibility(this.myElement, string2);
            }
        } else if ("generalization".equals(string)) {
            XMIGeneralization xMIGeneralization = new XMIGeneralization();
            xMIGeneralization.setProperty("xmi.id", XMI11Import.getTemporaryID());
            xMIGeneralization.setParent(string2);
            xMIGeneralization.setChild(this.myID);
        } else if ("ownerScope".equals(string)) {
            this.setOwnerScope(string2);
        } else if ("changeability".equals(string)) {
            if ("frozen".equals(string2) && this.myElement.canSetPropertyValue("$final", BooleanUtil.toString(true))) {
                this.myElement.setPropertyValue("$final", BooleanUtil.toString(true));
            }
        } else if ("namespace".equals(string)) {
            this.myElement.setPropertyValue("namespace", string2);
        }
        return this.myElement;
    }

    protected Enumeration writeXMI11Content() throws Exception {
        int n;
        Diagnostic.print("Processing Class members");
        Vector<XMIElement> vector = new Vector<XMIElement>();
        Vector<Entity> vector2 = new Vector<Entity>();
        Vector<Entity> vector3 = new Vector<Entity>();
        Vector<XMIClass> vector4 = new Vector<XMIClass>();
        EntityEnumeration entityEnumeration = this.myElement.childEntities();
        while (entityEnumeration.hasMoreElements()) {
            Entity entity = entityEnumeration.next();
            String string = entity.getPropertyValue("$metaclass");
            Diagnostic.print("\tProcessing class child " + string + " " + entity.getPropertyValue("$name"));
            if ("Generalization Link".equals(string) || "Implementation Link".equals(string)) {
                vector3.add(entity);
                continue;
            }
            if ("Dependency Link".equals(string)) {
                this.myDependencies.add(entity);
                continue;
            }
            if (CLASS.equals(string)) {
                vector4.add(new XMIClass(this.myWriter, entity, this.myDiagram));
                continue;
            }
            vector2.add(entity);
        }
        if (!vector2.isEmpty()) {
            this.myWriter.writeStartTag("UML", "Classifier.feature", true);
            n = 0;
            while (n < vector2.size()) {
                Entity entity = (Entity)vector2.elementAt(n);
                XMIElement xMIElement = null;
                String string = entity.getPropertyValue("$metaclass");
                if ("Association Link".equals(string) || "Extends Link".equals(string) || "Includes Link".equals(string)) {
                    xMIElement = ElementWriter.writeElement(this.myWriter, entity, this.myDiagram, false);
                    if (xMIElement != null) {
                        vector.add(xMIElement);
                    }
                } else {
                    ElementWriter.writeElement(this.myWriter, entity, this.myDiagram);
                }
                ++n;
            }
            this.myWriter.writeEndTag("UML", "Classifier.feature");
        }
        if (!(vector3.isEmpty() && vector4.isEmpty() && this.myDependencies.isEmpty())) {
            this.myWriter.writeStartTag("UML", "Namespace.ownedElement", true);
            n = 0;
            while (n < vector4.size()) {
                if (vector4.elementAt(n) instanceof XMIElement) {
                    ((XMIElement)vector4.elementAt(n)).writeXMI11Element();
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < vector3.size()) {
                ElementWriter.writeElement(this.myWriter, (Entity)vector3.elementAt(n2), this.myDiagram);
                ++n2;
            }
            this.myWriter.writeEndTag("UML", "Namespace.ownedElement");
        }
        return vector.elements();
    }

    private void init() {
        if (this.myElement == null) {
            return;
        }
        String string = this.myElement.getPropertyValue("$metaclass");
        try {
            this.myName = (String)ourNameTable.get(string);
        }
        catch (ClassCastException classCastException) {
            this.myName = string;
        }
        if (this.myName == null) {
            this.myName = CLASS;
        }
        if (CLASS.equals(string)) {
            boolean bl = this.myElement.hasProperty("$interface");
            this.myName = bl ? INTERFACE : CLASS;
        }
        this.myID = XMI11Export.getElementID(this.myElement);
        this.writeDocumentation();
        this.writePersistence();
        this.writeAlias();
        this.writeInvariants();
        this.writeWebService();
        this.writeTaggedValues();
        this.myDependencies = new Vector();
        this.myStereotypeNotPresent = false;
    }

    public boolean isRoseCompatible() {
        Entity entity;
        if (!XMI11Export.isRoseSpecificExport()) {
            return true;
        }
        boolean bl = true;
        String string = null;
        if (this.myDiagram != null && (entity = this.myDiagram.getPhysicalDiagram()) != null) {
            string = entity.getPropertyValue("$metaclass");
        }
        if (ACTOR.equals(this.myName) && string != null && !"Use Case Diagram".equals(string)) {
            bl = false;
        }
        if (INTERFACE.equals(this.myElement.getPropertyValue("$metaclass")) && string != null && !string.equals("Component Diagram")) {
            bl = false;
        }
        if (!bl) {
            if (this.myDiagram != null) {
                XMI11Export.addIncompatibleElement(this.myElement, this.myDiagram.getPhysicalDiagram());
            }
            XMI11Export.addIncompatibleElement(this.myElement, null);
        }
        return bl;
    }

    protected void writeNamespace() {
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "namespace");
    }

    protected void writeInvariants() {
        XMI11Export.addTaggedValue((Element)this.myElement, this.myWriter, this.myID, "@invariants");
    }

    protected void writeClassType() throws Exception {
        if (this.myElement.hasProperty("$enum")) {
            this.myStereotype = new XMIStereotype(this.myWriter, "enum", CLASS, this.myID);
        } else if (this.myElement.hasProperty("$struct")) {
            this.myStereotype = new XMIStereotype(this.myWriter, "structure", CLASS, this.myID);
        } else if (this.myElement.hasProperty("$union") || this.myElement.hasProperty("union")) {
            this.myStereotype = new XMIStereotype(this.myWriter, "union", CLASS, this.myID);
        } else if (this.myElement.hasProperty("$valuetype")) {
            this.myStereotype = new XMIStereotype(this.myWriter, "valuetype", CLASS, this.myID);
        } else if (this.myElement.hasProperty("$exception")) {
            this.myStereotype = new XMIStereotype(this.myWriter, "exception", CLASS, this.myID);
        }
        if (this.myStereotype != null) {
            XMI11Export.addStereotype(this.myStereotype);
            this.myStereotypeNotPresent = true;
        }
    }

    protected Entity createSpecificClass(Entity entity, String string) throws XMIException {
        if (entity == null) {
            return null;
        }
        Object var3_3 = null;
        Entity entity2 = null;
        if (var3_3 != null) {
            if (entity.hasPropertyValue("$metaclass", "DesignDiagram")) {
                Entity entity3 = entity;
            } else if (entity.hasPropertyValue("$metaclass", "Package")) {
                Entity entity4 = entity;
            } else if (entity instanceof Entity) {
                Entity entity5 = entity;
            }
        }
        return entity2;
    }

    static {
        ourNameTable.put(CLASS, CLASS);
        ourNameTable.put(ACTOR, ACTOR);
        ourNameTable.put("Use Case", USECASE);
        ourNameTable.put(INTERFACE, INTERFACE);
    }
}

