/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.elements;

import com.togethersoft.selena.xmi.elements.BooleanUtil;
import com.togethersoft.selena.xmi.elements.XMIAbstractElement;
import com.togethersoft.selena.xmi.elements.XMIElementImpl;
import com.togethersoft.selena.xmi.elements.XMIExpression;
import com.togethersoft.selena.xmi.elements.XMIMultiplicity;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.InterchangeUtils;
import com.togethersoft.selena.xmi.util.XMI11Export;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;

public class XMIAttribute
extends XMIElementImpl {
    public static final String ATTRIBUTE = "Attribute";
    public static final String ATTRIBUTE_INITIALVALUE = "Attribute.initialValue";
    private boolean myTypeAllowed;
    private boolean myValueAllowed;

    public XMIAttribute() {
        this.myValueAllowed = false;
        this.myTypeAllowed = false;
    }

    public XMIAttribute(XMLWriter xMLWriter, Entity entity) {
        super(xMLWriter, entity);
        this.myName = ATTRIBUTE;
        this.myID = XMI11Export.getElementID(this.myElement);
        this.writeDocumentation();
        this.writePersistence();
        this.writeAlias();
        this.writeVolatile();
        this.writeTaggedValues();
    }

    public void writeXMI11Element() throws Exception {
        Object object;
        super.writeXMI11Element();
        if (!this.isRoseCompatible()) {
            return;
        }
        this.myWriter.writeStartTag("UML", this.myName);
        this.myWriter.writeAttribute("xmi.id", this.myID);
        String string = this.myElement.getPropertyValue("$name");
        String string2 = this.getRealNameProperty();
        if (string2 != null) {
            string = string2;
        }
        this.myWriter.writeAttribute("name", string, true);
        this.myWriter.writeAttribute("visibility", this.visibilityValue());
        this.myWriter.writeAttribute("isSpecification", this.isSpecificationValue());
        this.myWriter.writeAttribute("changeability", this.changeabilityValue(), true);
        this.myWriter.writeAttribute("ownerScope", this.ownerScopeValue());
        this.writeStereotype();
        this.myWriter.writeCloseBrasket();
        this.myWriter.writeStartTag("UML", "StructuralFeature.multiplicity", true);
        XMIMultiplicity xMIMultiplicity = new XMIMultiplicity(this.myWriter, "1");
        xMIMultiplicity.writeXMI11Element();
        this.myWriter.writeEndTag("UML", "StructuralFeature.multiplicity");
        String string3 = this.myElement.getPropertyValue("$initialValue");
        String string4 = this.myElement.getPropertyValue("$language");
        if (string3 != null && string3.length() != 0) {
            this.myWriter.writeStartTag("UML", ATTRIBUTE_INITIALVALUE, true);
            object = new XMIExpression(this.myWriter, string3, string4);
            object.writeXMI11Element();
            this.myWriter.writeEndTag("UML", ATTRIBUTE_INITIALVALUE);
        }
        this.myWriter.writeStartTag("UML", "StructuralFeature.type", true);
        object = this.myElement.getPropertyValue("$type");
        String string5 = this.myElement.getPropertyValue("$typeReferencedElement");
        Model model = InterchangeUtils.getWizardData().getModel();
        Entity entity = null;
        if (string5 != null) {
            entity = (Entity)model.findElement(ModelAccess.createUniqueName((String)string5));
        }
        String string6 = entity != null ? XMI11Export.addDataType(entity) : XMI11Export.addDataType((String)object);
        if (XMI11Export.isUnisysExport()) {
            this.myWriter.writeStartTag("Foundation.Core.Classifier");
            this.myWriter.writeAttribute("xmi.idref", string6);
            this.myWriter.writeCloseBrasket(true);
        } else {
            this.myWriter.writeStartTag("UML", "Classifier", true);
            this.myWriter.writeStartTag("UML", "Namespace.ownedElement", true);
            this.myWriter.writeStartTag("UML", "DataType");
            this.myWriter.writeAttribute("xmi.idref", string6);
            this.myWriter.writeCloseBrasket(true);
            this.myWriter.writeEndTag("UML", "Namespace.ownedElement");
            this.myWriter.writeEndTag("UML", "Classifier");
        }
        this.myWriter.writeEndTag("UML", "StructuralFeature.type");
        this.myWriter.writeEndTag("UML", this.myName);
    }

    public Entity createRwiElement(Entity entity) throws XMIException {
        if (entity == null || !(entity instanceof Entity)) {
            throw new XMIException("xmi.import.error.cannot.create", ATTRIBUTE);
        }
        Entity entity2 = entity;
        String string = entity2.getPropertyValue("$metaclass");
        String string2 = entity2.getPropertyValue("$name");
        if (!entity2.canCreateChildEntity(ATTRIBUTE, null)) {
            throw new XMIException("xmi.import.error.cannot.create.in", ATTRIBUTE, string, string2);
        }
        this.myElement = entity2.createChildEntity(ATTRIBUTE, null);
        if (this.myElement != null) {
            Diagnostic.print(this.myElement.getPropertyValue("$metaclass") + " '" + this.myElement.getPropertyValue("$name") + "' created successfully");
        } else {
            Diagnostic.print("Failed to create RwiElement");
        }
        return this.myElement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Entity setProperty(String string, String string2) throws XMIException {
        super.setProperty(string, string2);
        if ("visibility".equals(string)) {
            XMIAbstractElement.setVisibility(this.myElement, string2);
        } else if ("changeability".equals(string) && "frozen".equals(string2)) {
            if (!this.myElement.canSetPropertyValue("$final", BooleanUtil.toString(true))) throw new XMIException("xmi.import.error.cannot.set.property", "$final");
            this.myElement.setPropertyValue("$final", BooleanUtil.toString(true));
        } else if ("xmi.idref".equals(string) && this.myTypeAllowed) {
            XMI11Import.addAttributeType(this.myElement, string2);
        } else if ("type".equals(string)) {
            XMI11Import.addAttributeType(this.myElement, string2);
        }
        if ("body".equals(string) && this.myValueAllowed) {
            Diagnostic.print("Set initial value to: \"" + string2 + "\"");
            if (string2 == null || string2.length() == 0) return this.myElement;
            if (!this.myElement.canSetPropertyValue("$initialValue", string2)) throw new XMIException("xmi.import.error.cannot.set.property2", "$initialValue", string2);
            this.myElement.setPropertyValue("$initialValue", string2);
            return this.myElement;
        } else if ("ownerScope".equals(string)) {
            this.setOwnerScope(string2);
            return this.myElement;
        } else {
            if (!"stereotype".equals(string)) return this.myElement;
            XMI11Import.addStereotypeSeeks(this.myID, string2);
        }
        return this.myElement;
    }

    public void setAllowType(boolean bl) {
        this.myTypeAllowed = bl;
    }

    public void setAllowValue(boolean bl) {
        this.myValueAllowed = bl;
    }

    protected String changeabilityValue() {
        if (this.myElement.hasProperty("$final") || this.myElement.hasProperty("const")) {
            return "frozen";
        }
        return "changeable";
    }

    protected boolean isRoseCompatible() {
        if (!XMI11Export.isRoseSpecificExport()) {
            return true;
        }
        Entity entity = this.myElement.getParent();
        if (entity != null && entity.hasProperty("$interface")) {
            XMI11Export.addIncompatibleElement(this.myElement, entity);
            return false;
        }
        return true;
    }
}

