/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.elements;

import com.togethersoft.selena.xmi.elements.XMIAssociationEnd;
import com.togethersoft.selena.xmi.elements.XMIDiagram;
import com.togethersoft.selena.xmi.elements.XMIElementImpl;
import com.togethersoft.selena.xmi.elements.XMIMultiplicity;
import com.togethersoft.selena.xmi.elements.XMIStereotype;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.XMI11Export;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.enum.ElementEnumeration;

public class XMIAssociation
extends XMIElementImpl {
    public static final String ASSOCIATION = "Association";
    public static final String ASSOCIATION_CONNECTION = "Association.connection";
    public static final String SUPPLIER = "supplier";
    public static final String CLIENT = "client";
    public static final String ASSOCIATION_ATTRIBUTE = "associationAttribute";
    private XMIAssociationEnd myEnd1;
    private XMIAssociationEnd myEnd2;
    private String myLabel;
    private String myStereotypeID;
    private String myAttributeID;

    public XMIAssociation() {
        this.myID = null;
        this.myEnd1 = null;
        this.myEnd2 = null;
        this.myAttributeID = null;
    }

    public XMIAssociation(XMLWriter xMLWriter, Entity entity, XMIDiagram xMIDiagram) {
        super(xMLWriter, entity, xMIDiagram);
        this.myID = XMI11Export.getModelID(this.myElement);
        this.myName = ASSOCIATION;
        this.writeTaggedValues();
    }

    public void writeXMI11Element() throws Exception {
        Object object;
        super.writeXMI11Element();
        Entity entity = this.myElement;
        Entity entity2 = null;
        Entity entity3 = null;
        ElementEnumeration elementEnumeration = entity.participants("Client");
        ElementEnumeration elementEnumeration2 = entity.participants("Supplier");
        if (elementEnumeration.hasMoreElements()) {
            entity2 = (Entity)elementEnumeration.next();
        }
        if (elementEnumeration2.hasMoreElements()) {
            entity3 = (Entity)elementEnumeration2.next();
        }
        if (!XMI11Export.isInProject(entity2) || !XMI11Export.isInProject(entity3)) {
            return;
        }
        if (!this.isRoseCompatible(entity2) || !this.isRoseCompatible(entity3)) {
            return;
        }
        this.writeElementComments(entity2, entity3);
        this.myWriter.writeStartTag("UML", this.myName);
        this.myWriter.writeAttribute("xmi.id", this.myID);
        String string = entity.getPropertyValue("@label");
        if (string == null || string.length() == 0) {
            string = "{" + entity2.getPropertyValue("$name") + '-' + entity3.getPropertyValue("$name") + "}";
        }
        this.myWriter.writeAttribute("name", string, true);
        this.myWriter.writeAttribute("visibility", this.visibilityValue());
        this.myWriter.writeAttribute("isSpecification", this.isSpecificationValue());
        this.myWriter.writeAttribute("isAbstract", this.isAbstractValue(), true);
        this.writeStereotype();
        String string2 = null;
        String string3 = this.myElement.getPropertyValue("$refAttribute");
        if (string3 != null && string3.length() != 0) {
            object = (Entity)this.myElement.getModel().findElement(ModelAccess.createUniqueName((String)string3));
            Diagnostic.print("correspondingAttributeUIN = " + string3);
            if (object != null) {
                string2 = XMI11Export.getElementID(object);
                Diagnostic.print("Corresponding attribute is " + object.getPropertyValue("$name") + "[" + string2 + "]");
            } else {
                Diagnostic.print("can't find corresponding attribute !!!");
            }
        } else {
            Diagnostic.print("correspondingAttributeUIN is empty !!!");
        }
        this.myWriter.writeCloseBrasket();
        this.myWriter.writeStartTag("UML", ASSOCIATION_CONNECTION, true);
        object = new XMIAssociationEnd(this.myWriter, this.myElement, this.myDiagram, CLIENT, this.myID, string2);
        ((XMIAssociationEnd)object).writeXMI11Element();
        XMIAssociationEnd xMIAssociationEnd = new XMIAssociationEnd(this.myWriter, this.myElement, this.myDiagram, SUPPLIER, this.myID, null);
        xMIAssociationEnd.writeXMI11Element();
        this.myWriter.writeEndTag("UML", ASSOCIATION_CONNECTION);
        this.myWriter.writeEndTag("UML", this.myName);
    }

    public Entity setProperty(String string, String string2) throws XMIException {
        if ("xmi.id".equals(string) && string2 != null) {
            this.myID = string2;
            XMI11Import.addAssociation(this.myID, this);
        } else if ("name".equals(string) && string2 != null) {
            this.myLabel = string2.indexOf("{") > -1 && string2.indexOf("{") < string2.indexOf("}") ? string2.substring(0, string2.indexOf("{")) : string2;
        } else if ("stereotype".equals(string)) {
            this.myStereotypeID = string2;
        } else if ("associationattribute".equals(string)) {
            this.myAttributeID = string2;
        }
        return this.myElement;
    }

    public void setAssociationEnd(XMIAssociationEnd xMIAssociationEnd) throws XMIException {
        if (this.myEnd1 == null) {
            this.myEnd1 = xMIAssociationEnd;
        } else if (this.myEnd2 == null) {
            this.myEnd2 = xMIAssociationEnd;
        }
    }

    public void add() {
        if (this.myID != null) {
            return;
        }
        this.myID = XMI11Import.getTemporaryID();
        XMI11Import.addAssociation(this.myID, this);
    }

    public void setAttributeID(String string) {
        Diagnostic.print("setAttributeID " + string);
        this.myAttributeID = string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Entity createRwiElement() throws XMIException {
        XMIAssociationEnd xMIAssociationEnd;
        Diagnostic.print("createRwiElement");
        if (this.myEnd1 == null || this.myEnd2 == null) {
            Diagnostic.printError(new XMIException("xmi.import.error.cannot.create.link", ASSOCIATION, this.myID, "", ""));
            return null;
        }
        if (this.myEnd2.isAggregate() || this.myEnd2.isComposite()) {
            Diagnostic.print("Change link's direction");
            xMIAssociationEnd = this.myEnd2;
            this.myEnd2 = this.myEnd1;
            this.myEnd1 = xMIAssociationEnd;
        }
        Diagnostic.print("XMIAssociation,creating RwiElement, end from: " + this.myEnd1.getReference() + " end to: " + this.myEnd2.getReference());
        xMIAssociationEnd = XMI11Import.getElement(this.myEnd1.getReference());
        Entity entity = XMI11Import.getElement(this.myEnd2.getReference());
        if (xMIAssociationEnd == null) {
            throw new XMIException("xmi.import.error.cannot.find.association.end", this.myEnd1.getReference(), this.myLabel);
        }
        if (entity == null) {
            throw new XMIException("xmi.import.error.cannot.find.association.end", this.myEnd2.getReference(), this.myLabel);
        }
        Diagnostic.print("Creating Association Entity");
        if (this.myStereotypeID == null) {
            this.myStereotype = XMI11Import.getStereotypeById(this.myStereotypeID);
        }
        if (this.myStereotype == null) {
            this.myStereotype = XMI11Import.getStereotype(this.myID);
        }
        String string = "";
        if (this.myStereotype != null) {
            string = this.myStereotype.getName();
        }
        boolean bl = false;
        String string2 = "Association Link";
        if ("extend".equals(string)) {
            string2 = "Extends Link";
            bl = true;
        } else if ("include".equals(string)) {
            string2 = "Includes Link";
            bl = true;
        }
        Diagnostic.print("Creating " + string2);
        Entity entity2 = null;
        if (!xMIAssociationEnd.canCreateChildEntity(string2, null)) {
            throw new XMIException("xmi.import.error.cannot.create.link2", new String[]{string2, this.myID, xMIAssociationEnd.getPropertyValue("$metaclass"), xMIAssociationEnd.getPropertyValue("$name"), entity.getPropertyValue("$metaclass"), entity.getPropertyValue("$name")});
        }
        entity2 = xMIAssociationEnd.createChildEntity(string2, null);
        entity2.setParticipant("Supplier", null, (Element)entity);
        if (entity2 == null) {
            return null;
        }
        if (this.myAttributeID != null) {
            entity2.setPropertyValue(ASSOCIATION_ATTRIBUTE, this.myAttributeID);
            Diagnostic.print("Association link corresponds to attribute[" + this.myAttributeID + "]");
        }
        if (this.myLabel != null && this.myLabel.length() != 0 && entity2.canSetPropertyValue("@label", this.myLabel)) {
            entity2.setPropertyValue("@label", this.myLabel);
        }
        if (this.myEnd1.getRole() != null) {
            if (!entity2.canSetPropertyValue("@clientRole", this.myEnd1.getRole())) throw new XMIException("xmi.import.error.cannot.set.property2", "@clientRole", this.myEnd1.getRole());
            entity2.setPropertyValue("@clientRole", this.myEnd1.getRole());
        }
        if (this.myEnd2.getRole() != null) {
            if (!entity2.canSetPropertyValue("@supplierRole", this.myEnd2.getRole())) throw new XMIException("xmi.import.error.cannot.set.property2", "@supplierRole", this.myEnd2.getRole());
            entity2.setPropertyValue("@supplierRole", this.myEnd2.getRole());
        }
        if (string.length() != 0 && !bl && entity2.canSetPropertyValue("@stereotype", string)) {
            entity2.setPropertyValue("@stereotype", string);
        }
        XMI11Import.removeStereotype(this.myID);
        XMIMultiplicity.setSupplierCardinality(entity2, this.myEnd2.getMultiplicity());
        XMIMultiplicity.setClientCardinality(entity2, this.myEnd1.getMultiplicity());
        if (this.myEnd1.isAggregate() || this.myEnd2.isAggregate()) {
            if (!entity2.canSetPropertyValue("@link", "aggregation")) throw new XMIException("xmi.import.error.cannot.set.property", "$metaclass");
            entity2.setPropertyValue("@link", "aggregation");
        }
        if (this.myEnd1.isComposite() || this.myEnd2.isComposite()) {
            if (!entity2.canSetPropertyValue("@link", "aggregationByValue")) throw new XMIException("xmi.import.error.cannot.set.property", "aggregationByValue");
            entity2.setPropertyValue("@link", "aggregationByValue");
        }
        if (this.myEnd1.isNavigable()) {
            if (this.myEnd2.isNavigable()) {
                if (!entity2.canSetPropertyValue("@backDirected", "directed")) {
                    throw new XMIException("xmi.import.error.cannot.set.property", "@backDirected");
                }
                entity2.setPropertyValue("@backDirected", "directed");
                if (!entity2.canSetPropertyValue("@directed", "directed")) throw new XMIException("xmi.import.error.cannot.set.property", "@directed");
                entity2.setPropertyValue("@directed", "directed");
            } else {
                if (!entity2.canSetPropertyValue("@backDirected", "directed")) throw new XMIException("xmi.import.error.cannot.set.property", "@backDirected");
                entity2.setPropertyValue("@backDirected", "directed");
            }
        } else if (this.myEnd2.isNavigable()) {
            if (!entity2.canSetPropertyValue("@directed", "directed")) throw new XMIException("xmi.import.error.cannot.set.property", "@directed");
            entity2.setPropertyValue("@directed", "directed");
        }
        Diagnostic.print(entity2.getPropertyValue("$metaclass") + " '" + entity2.getPropertyValue("$name") + "' created successfully");
        this.myElement = entity2;
        return entity2;
    }

    protected void addStereotype() throws Exception {
        if (this.myElement == null) {
            return;
        }
        String string = this.myElement.getPropertyValue("$metaclass");
        String string2 = null;
        if ("Extends Link".equals(string)) {
            string2 = "extend";
        } else if ("Includes Link".equals(string)) {
            string2 = "include";
        }
        if (string2 != null) {
            this.myStereotype = new XMIStereotype(this.myWriter, string2, this.myName, this.myID);
            XMI11Export.addStereotype(this.myStereotype);
        } else {
            super.addStereotype();
        }
    }
}

