/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.xmi.elements;

import com.togethersoft.selena.xmi.elements.XMIElementImpl;
import com.togethersoft.selena.xmi.elements.XMIExpression;
import com.togethersoft.selena.xmi.util.Diagnostic;
import com.togethersoft.selena.xmi.util.XMI11Export;
import com.togethersoft.selena.xmi.util.XMI11Import;
import com.togethersoft.selena.xmi.util.XMIException;
import com.togethersoft.selena.xmi.util.XMLWriter;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;

public class XMIAction
extends XMIElementImpl {
    public static final String ACTION = "Action";
    public static final String UNINTERPRETEDACTION = "UninterpretedAction";
    public static final String CALLACTION = "CallAction";
    public static final String ACTION_RECURRENCE = "Action.recurrence";
    public static final String ACTION_TARGET = "Action.target";
    public static final String ACTION_SCRIPT = "Action.script";
    public static final String IS_ASYNCHRONOUS = "isAsynchronous";
    public static final char NAME_SIGNATURE_DELIMITER = '#';
    protected XMIExpression myRecurrenceExpression;
    protected XMIExpression myTargetExpression;
    protected XMIExpression myScriptExpression;
    private boolean myReferenceAllowed = true;
    private boolean myAsynchronous;
    private String myActionName;
    private String myOperationID;

    public XMIAction() {
        this.myName = ACTION;
        this.myActionName = "";
        this.myReferenceAllowed = true;
        this.myAsynchronous = false;
    }

    public XMIAction(String string) {
        this.myName = string;
        this.myActionName = "";
        this.myReferenceAllowed = true;
        this.myAsynchronous = false;
    }

    public XMIAction(XMLWriter xMLWriter, String string) {
        super(xMLWriter, (Entity)null);
        this.myName = string;
        this.init();
    }

    public XMIAction(XMLWriter xMLWriter, Entity entity) {
        super(xMLWriter, entity);
        if (this.myElement == null) {
            this.myName = UNINTERPRETEDACTION;
        } else if ("Operation".equals(this.myElement.getPropertyValue("$metaclass"))) {
            this.myName = CALLACTION;
            this.myOperationID = XMI11Export.getElementID(this.myElement);
        } else {
            this.myName = ACTION;
        }
        this.init();
    }

    public void writeXMI11Element() throws Exception {
        super.writeXMI11Element();
        String string = this.myElement != null ? (XMI11Export.isInProject(this.myElement) ? this.myElement.getPropertyValue("$name") : this.myElement.getPropertyValue("$fullName") + '#' + this.myElement.getPropertyValue("$memberSignature")) : this.myActionName;
        Diagnostic.print("Writing out " + this.myName + ", name = " + string + ", id = " + this.myID);
        this.myWriter.writeStartTag("UML", this.myName);
        this.myWriter.writeAttribute("xmi.id", this.myID);
        this.myWriter.writeAttribute("name", string, true);
        this.myWriter.writeAttribute("visibility", "public");
        this.myWriter.writeAttribute("isSpecification", "false");
        this.myWriter.writeAttribute(IS_ASYNCHRONOUS, "false", true);
        this.writeStereotype();
        this.myWriter.writeCloseBrasket();
        this.writeXMI11Content();
        this.myWriter.writeEndTag("UML", this.myName);
    }

    public void setName(String string) {
        this.myActionName = string;
    }

    protected void writeXMI11Content() throws Exception {
        this.myWriter.writeStartTag("UML", ACTION_RECURRENCE, true);
        this.myRecurrenceExpression.writeXMI11Element();
        this.myWriter.writeEndTag("UML", ACTION_RECURRENCE);
        this.myWriter.writeStartTag("UML", ACTION_TARGET, true);
        this.myTargetExpression.writeXMI11Element();
        this.myWriter.writeEndTag("UML", ACTION_TARGET);
        this.myWriter.writeStartTag("UML", ACTION_SCRIPT, true);
        this.myScriptExpression.writeXMI11Element();
        this.myWriter.writeEndTag("UML", ACTION_SCRIPT);
        if (this.myOperationID != null && this.myOperationID.length() != 0) {
            this.myWriter.writeStartTag("UML", this.myName + ".operation", true);
            if (XMI11Export.isUnisysExport()) {
                this.myWriter.writeStartTag("Foundation.Core.Operation");
                if (XMI11Export.isInProject(this.myElement)) {
                    this.myWriter.writeAttribute("xmi.idref", this.myOperationID);
                }
                this.myWriter.writeCloseBrasket(true);
            } else {
                this.myWriter.writeStartTag("UML", "Operation");
                if (XMI11Export.isInProject(this.myElement)) {
                    this.myWriter.writeAttribute("xmi.idref", this.myOperationID);
                }
                this.myWriter.writeCloseBrasket(true);
            }
            this.myWriter.writeEndTag("UML", this.myName + ".operation");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Entity setProperty(String string, String string2) throws XMIException {
        Diagnostic.print("Setting action properties " + string + " = '" + string2 + "'");
        if (string == null || string.length() == 0 || string2 == null) {
            throw new XMIException("xmi.import.error.cannot.set.name", string);
        }
        if ("xmi.id".equals(string) && string2.length() != 0) {
            this.myOperationID = this.myID = string2;
            XMI11Import.addAction(this.myID, this);
            return this.myElement;
        } else if ("name".equals(string)) {
            this.myActionName = string2;
            return this.myElement;
        } else if (IS_ASYNCHRONOUS.equals(string)) {
            if ("true".equals(string2)) {
                this.myAsynchronous = true;
                return this.myElement;
            } else {
                if (!"false".equals(string2)) throw new XMIException("xmi.import.error.incorrect.attribute.value.in", string, string2, this.myName);
                this.myAsynchronous = false;
            }
            return this.myElement;
        } else {
            if (!"body".equals(string)) return this.myElement;
            this.setTarget(string2);
        }
        return this.myElement;
    }

    public void allowReference(boolean bl) {
        this.myReferenceAllowed = bl;
    }

    public void setReference(String string) throws XMIException {
        this.myOperationID = string;
    }

    public String getName() {
        return this.myActionName;
    }

    public boolean isAsynchronous() {
        return this.myAsynchronous;
    }

    public Entity getOperation() {
        if (this.myOperationID == null || this.myOperationID.length() == 0) {
            return null;
        }
        Diagnostic.print("getOperation(): " + this.myOperationID);
        Entity entity = null;
        XMIAction xMIAction = XMI11Import.getAction(this.myOperationID);
        entity = xMIAction == null ? XMI11Import.getElement(this.myOperationID) : xMIAction.getRwiElement();
        return entity;
    }

    public String getOperationUniqueName() throws XMIException {
        UniqueName uniqueName;
        Entity entity = this.getOperation();
        if (entity != null && (uniqueName = entity.getUniqueName()) != null) {
            return uniqueName.toString();
        }
        return "";
    }

    public void setRecurrenceExpression(XMIExpression xMIExpression) throws XMIException {
        if (xMIExpression == null) {
            throw new XMIException("xmi.import.error.unknown.in", "UML:" + this.myName, this.myID);
        }
        if (!"IterationExpression".equals(xMIExpression.getType())) {
            throw new XMIException("xmi.import.error.unknown.in", "UML:" + this.myName, this.myID);
        }
        this.myRecurrenceExpression = xMIExpression;
    }

    public void setTargetExpression(XMIExpression xMIExpression) throws XMIException {
        if (xMIExpression == null) {
            throw new XMIException("xmi.import.error.unknown.in", "UML:" + this.myName, this.myID);
        }
        if (!"ObjectSetExpression".equals(xMIExpression.getType())) {
            throw new XMIException("xmi.import.error.unknown.in", "UML:" + this.myName, this.myID);
        }
        this.myTargetExpression = xMIExpression;
    }

    public void setScriptExpression(XMIExpression xMIExpression) throws XMIException {
        if (xMIExpression == null) {
            throw new XMIException("xmi.import.error.unknown.in", "UML:" + this.myName, this.myID);
        }
        if (!"ActionExpression".equals(xMIExpression.getType())) {
            throw new XMIException("xmi.import.error.unknown.in", "UML:" + this.myName, this.myID);
        }
        this.myScriptExpression = xMIExpression;
    }

    public String getTarget() {
        if (this.myTargetExpression != null) {
            return this.myTargetExpression.getBody();
        }
        return null;
    }

    public void setTarget(String string) {
        if (this.myTargetExpression != null) {
            this.myTargetExpression.setBody(string);
        }
    }

    protected void init() {
        this.myID = XMI11Export.getDiagramElementID(this);
        this.myRecurrenceExpression = new XMIExpression(this.myWriter, "IterationExpression", null, null);
        this.myTargetExpression = new XMIExpression(this.myWriter, "ObjectSetExpression", null, null);
        this.myScriptExpression = new XMIExpression(this.myWriter, "ActionExpression", null, null);
        this.writeTaggedValues();
    }
}

