/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.rfc.exceptions;

import com.sap.mw.jco.util.FastStringBuffer;
import com.sap.mw.rfc.engine.Trc;
import com.sap.mw.rfc.exceptions.RfcIoErrorCode;
import com.sap.mw.rfc.exceptions.RfcRc;
import java.io.IOException;

public class RfcIoException
extends IOException
implements RfcIoErrorCode,
RfcRc {
    private int ioRc;
    private int errorGroup;
    private String key;

    public RfcIoException(int iorc, String message) {
        super(message == null ? "no message received" : message);
        this.ioRc = iorc;
        this.set(iorc);
        Trc.criticalTrace(null, this.toString());
    }

    public String toString() {
        FastStringBuffer buf = new FastStringBuffer(300);
        buf.append("\n>RfcIoException:");
        buf.append("\n    message: ");
        buf.append(this.getMessage());
        buf.append("\n    Return code: ");
        buf.append(RfcIoException.getIoRcAsString(this.ioRc));
        buf.append("(");
        buf.append(this.ioRc);
        buf.append(")");
        buf.append("<\n\n");
        return buf.toString();
    }

    public static String getIoRcAsString(int iorc) {
        switch (iorc) {
            case 0: {
                return new String("RFCIO_O_K");
            }
            case 1: {
                return new String("RFCIO_ERROR_TOOLONG");
            }
            case 2: {
                return new String("RFCIO_ERROR_NOMEM");
            }
            case 3: {
                return new String("RFCIO_ERROR_INTERNAL");
            }
            case 4: {
                return new String("RFCIO_ERROR_NOHANDLE");
            }
            case 5: {
                return new String("RFCIO_ERROR_SYSERROR");
            }
            case 6: {
                return new String("RFCIO_ERROR_ALREADY_WAITING");
            }
            case 7: {
                return new String("RFCIO_ERROR_ENDREAD");
            }
            case 8: {
                return new String("RFCIO_ERROR_NO_DATA");
            }
            case 9: {
                return new String("RFCIO_ERROR_ILL_TYPE");
            }
            case 10: {
                return new String("RFCIO_ERROR_DEALLOCATED");
            }
            case 11: {
                return new String("RFCIO_ERROR_NO_WAIT");
            }
            case 12: {
                return new String("RFCIO_ERROR_NO_ABORT");
            }
            case 13: {
                return new String("RFCIO_ERROR_DRV_NAME");
            }
            case 14: {
                return new String("RFCIO_ERROR_DRV");
            }
            case 15: {
                return new String("RFCIO_ERROR_NO_BUFFER");
            }
            case 16: {
                return new String("RFCIO_ERROR_ILLEGAL_NAME");
            }
            case 17: {
                return new String("RFCIO_NO_DATA");
            }
            case 18: {
                return new String("RFCIO_NO_DRIVER");
            }
            case 19: {
                return new String("RFCIO_ERROR_SAPTEMU_TOO_MUCH");
            }
            case 20: {
                return new String("RFCIO_ERROR_SAPTEMU_ILLEGAL");
            }
            case 21: {
                return new String("RFCIO_ERROR_VERSION_MISMATCH");
            }
            case 22: {
                return new String("RFCIO_ERROR_RFCLG_INTERNAL");
            }
            case 23: {
                return new String("RFCIO_ERROR_CANCELLED");
            }
            case 24: {
                return new String("RFCIO_ERROR_BUSY");
            }
            case 25: {
                return new String("RFCIO_ERROR_CONVERSION");
            }
            case 26: {
                return new String("RFCIO_ERROR_CONVERSION_REPL");
            }
            case 27: {
                return new String("RFCIO_ERROR_MESSAGE");
            }
        }
        return new String("Unknown IORC return code");
    }

    public int getIoRc() {
        return this.ioRc;
    }

    public String getKey() {
        return this.key;
    }

    public int getErrorGroup() {
        return this.errorGroup;
    }

    private void set(int rfcio_code) {
        switch (rfcio_code) {
            case 2: {
                this.errorGroup = 106;
                this.key = new String("RFC_ERROR_RESOURCE");
                break;
            }
            case 5: {
                this.errorGroup = 102;
                this.key = new String("RFC_ERROR_COMMUNICATION");
                break;
            }
            case 8: {
                this.errorGroup = 107;
                this.key = new String("RFC_ERROR_PROTOCOL");
                break;
            }
            case 10: {
                this.errorGroup = 104;
                this.key = new String("RFC_ERROR_SYSTEM_FAILURE");
                break;
            }
            case 22: {
                this.errorGroup = 102;
                this.key = new String("RFC_ERROR_COMMUNICATION");
                break;
            }
            case 23: {
                this.errorGroup = 109;
                this.key = new String("RFC_ERROR_CANCELLED");
                break;
            }
            case 24: {
                this.errorGroup = 110;
                this.key = new String("RFC_ERROR_BUSY");
                break;
            }
            default: {
                this.errorGroup = 104;
                this.key = new String("RFC_ERROR_SYSTEM_FAILURE");
            }
        }
    }
}

