/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.rfc.engine;

import com.sap.mw.jco.JCO;
import com.sap.mw.jco.util.FastStringBuffer;
import com.sap.mw.jco.util.SyncDateFormat;
import com.sap.mw.rfc.api.IRfcParameter;
import com.sap.mw.rfc.api.IRfcTable;
import com.sap.mw.rfc.api.RfcApi;
import com.sap.mw.rfc.api.RfcOptions;
import com.sap.mw.rfc.driver.CpicDriver;
import com.sap.mw.rfc.engine.RfcIoControl;
import com.sap.mw.rfc.engine.RfcIoOpenCntl;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;

public abstract class Trc {
    private static String SP = new String("    ");
    private static final String[] type_string = new String[]{"EXT", "TST", "SNA", "INT", "R/3", "TCP", "QUE", "XAB", "GUI", "DIA", "PBK", "ASY", "REG", "GUI", "BCK", "ADO", "SHM", "GUI", "VMC"};
    public static final String[] HEX = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
    private static final String m_errorFileName = "dev_jrfc.trc";
    private static File m_errorFile = null;
    private static final SyncDateFormat fileNameTimestampFormat = new SyncDateFormat("yyyyMMdd_HHmmss");
    private static long MAX_ERROR_FILE_LENGTH;
    private static FileWriter m_errorTraceFile;
    private static Hashtable m_traceFiles;
    private static final String m_timeStampFormat = "EEE MMM dd HH:mm:ss,SSS";
    private static final String m_timeStampFormatShort = "HH:mm:ss,SSS";
    private static final SyncDateFormat m_syncDateFormat;
    private static final SyncDateFormat m_syncDateFormatShort;
    private static final String openFileTimeStampFormat = "yyyyMMdd HHmmss zzzz";
    private static final SyncDateFormat openFileSyncDateFormat;
    static /* synthetic */ Class class$com$sap$mw$rfc$engine$Trc;

    private static final String getTypeString(int type) {
        switch (type) {
            case 0: {
                return "CHAR";
            }
            case 8: {
                return "INT";
            }
            case 6: {
                return "NUM";
            }
            case 2: {
                return "BCD";
            }
            case 1: {
                return "DATE";
            }
            case 3: {
                return "TIME";
            }
            case 7: {
                return "FLOAT";
            }
            case 4: {
                return "BYTE";
            }
            case 29: {
                return "STRING";
            }
            case 30: {
                return "XSTRING";
            }
            case 9: {
                return "INT2";
            }
            case 10: {
                return "INT1";
            }
            case 17: {
                return "STRUCTURE";
            }
            case 99: {
                return "TABLE";
            }
            case 42: {
                return "XMLDATA";
            }
        }
        return "CHAR";
    }

    public static String rfctype(int type) {
        if (type >= type_string.length) {
            return new String("???");
        }
        return type_string[type];
    }

    public static void rfc_hexdump(FileWriter file, int c_offset, byte[] buffer, int blen) {
        byte[] localbuffer = new byte[16];
        int count = 0;
        int ptr = 0;
        if (buffer == null || blen == 0) {
            return;
        }
        count = 0;
        while (blen != 0) {
            int i = 0;
            if (blen < 16) {
                System.arraycopy(buffer, ptr, localbuffer, 0, blen);
                Arrays.fill(localbuffer, blen, localbuffer.length, (byte)0);
                buffer = localbuffer;
                blen = 16;
            } else {
                System.arraycopy(buffer, ptr, localbuffer, 0, 16);
            }
            try {
                StringBuffer str = new StringBuffer(Integer.toHexString(count));
                i = str.length();
                while (i < 6) {
                    str.insert(0, '0');
                    ++i;
                }
                str.append(" |");
                i = 0;
                while (i < 16) {
                    if (i % 4 == 0) {
                        str.append(' ');
                    }
                    str.append(HEX[(byte)(localbuffer[i] >> 4 & 0xF)]);
                    str.append(HEX[(byte)(localbuffer[i] & 0xF)]);
                    ++i;
                }
                str.append(" |");
                i = 0;
                while (i < 16) {
                    byte c = localbuffer[i];
                    if (c > 31 && c < 127) {
                        str.append((char)c);
                    } else {
                        str.append('.');
                    }
                    ++i;
                }
                str.append("\n");
                file.write(str.toString());
                file.flush();
                ptr += 16;
                blen -= 16;
                count += 16;
            }
            catch (Exception ex) {
                return;
            }
        }
    }

    public static void ab_rfctrc(String text) {
        FileWriter traceFile = Trc.opentrace();
        if (traceFile == null) {
            return;
        }
        try {
            traceFile.write(text);
            traceFile.flush();
        }
        catch (Exception ex) {
            return;
        }
    }

    private static void print_handle(long handle) {
        if (handle == 0L) {
            Trc.ab_rfctrc(SP + "handle = 0\n");
        } else {
            Trc.ab_rfctrc(SP + "handle = " + handle + "\n");
        }
    }

    public static void TRfcCall(long handle, String function, IRfcParameter[] exporting, IRfcParameter[] changing, IRfcTable[] tables) {
        if (function == null) {
            Trc.ab_rfctrc("*> RfcCall\n   FUNCTION <null> \n");
        } else {
            Trc.ab_rfctrc("*> RfcCall\n   FUNCTION " + function + "\n");
        }
        Trc.print_handle(handle);
        Trc.print_parameters(exporting);
        Trc.print_parameters(changing);
        Trc.print_tables(tables);
    }

    public static void TRfcReceive(long handle, IRfcParameter[] importing, IRfcParameter[] changing, IRfcTable[] tables) {
        Trc.ab_rfctrc("*> RfcReceive ... \n");
        Trc.print_handle(handle);
        Trc.print_parameters(importing);
        Trc.print_parameters(changing);
        Trc.print_tables(tables);
    }

    public static void TRfcAbort(long rfc_handle, String text) {
        Trc.ab_rfctrc("\n\n>>>> RfcAbort called by external program ...\n");
        Trc.print_handle(rfc_handle);
        if (text == null) {
            text = new String("<null text>");
        }
        Trc.ab_rfctrc(SP + "text = " + text + "\n\n");
    }

    private static void print_parameters(IRfcParameter[] par) {
        int i = 0;
        if (par == null) {
            Trc.ab_rfctrc(SP + "parameter   = <null> \n\n");
            return;
        }
        i = 0;
        while (i < par.length) {
            Trc.ab_rfctrc(SP + "parameter[" + i + "].name = " + par[i].getName() + "\n");
            Trc.ab_rfctrc(SP + "parameter[" + i + "].type = " + Trc.getTypeString(par[i].getType()) + "\n");
            Trc.ab_rfctrc(SP + "parameter[" + i + "].length = " + par[i].getNumBytes() + "\n\n");
            ++i;
        }
    }

    private static void print_tables(IRfcTable[] tables) {
        int i = 0;
        if (tables == null) {
            Trc.ab_rfctrc(SP + "tables = <null> \n\n");
        } else {
            i = 0;
            while (i < tables.length) {
                Trc.ab_rfctrc(SP + "table[" + i + "].name = " + tables[i].getName() + "\n");
                int numRows = tables[i].getNumRows();
                if (numRows > 0) {
                    Trc.ab_rfctrc(SP + "table[" + i + "].rows = " + numRows + "\n");
                }
                Trc.ab_rfctrc(SP + "table[" + i + "].length = " + tables[i].getRowLength() + "\n\n");
                ++i;
            }
        }
    }

    public static void TRfcGetName(long handle, String name) {
        Trc.ab_rfctrc("\n\n*> RfcGetName\n");
        Trc.print_handle(handle);
        Trc.print_rfcf(name);
    }

    private static void print_rfcf(String name) {
        if (name == null) {
            Trc.ab_rfctrc(SP + "functionname  = <null>\n");
        } else {
            Trc.ab_rfctrc(SP + "functionname  = " + name + "\n");
        }
    }

    public static void TRfcGetData(long handle, IRfcParameter[] importing, IRfcParameter[] changing, IRfcTable[] tables) {
        Trc.ab_rfctrc("\n\n*> RfcGetData\n");
        Trc.print_handle(handle);
        Trc.print_parameters(importing);
        Trc.print_parameters(changing);
        Trc.print_tables(tables);
    }

    public static void TRfcSendData(long handle, IRfcParameter[] exporting, IRfcParameter[] changing, IRfcTable[] tables) {
        Trc.ab_rfctrc("\n\n*> RfcSendData\n");
        Trc.print_handle(handle);
        Trc.print_parameters(exporting);
        Trc.print_parameters(changing);
        Trc.print_tables(tables);
    }

    public static void TRfcRaise(long handle, String exception) {
        Trc.ab_rfctrc("*> RfcRaise\n");
        Trc.print_handle(handle);
        if (exception == null) {
            Trc.ab_rfctrc(SP + "exception   = %s <null>\n");
        } else {
            Trc.ab_rfctrc(SP + "exception   = " + exception + "%s\n");
        }
    }

    public static void TRfcOpen(RfcOptions options) {
        Trc.ab_rfctrc("\n\n*> RfcOpen\n    ");
        Trc.ab_rfctrc(options.toString());
        Trc.ab_rfctrc("\n\n");
    }

    public static void TRfcApiEnd(String what, boolean happyEnd) {
        Trc.ab_rfctrc("\n\n<* " + what + " >" + Trc.getTimeStamp() + "<");
        if (happyEnd) {
            Trc.ab_rfctrc("    successful *>");
        } else {
            Trc.ab_rfctrc("    failed *>");
        }
        Trc.ab_rfctrc("\n\n");
    }

    public static void TCpicNativeBegin(String what, long handle, byte[] convid) {
        Trc.ab_rfctrc("   >> CPIC native call ");
        Trc.tCpicNative(what, handle, convid);
    }

    public static void TCpicNativeEnd(String what, long handle, byte[] convid) {
        Trc.ab_rfctrc("   << CPIC native call ");
        Trc.tCpicNative(what, handle, convid);
    }

    private static void tCpicNative(String what, long handle, byte[] convid) {
        StringBuffer text = new StringBuffer(128);
        text.append(what);
        text.append(" [");
        text.append(handle);
        text.append("] convid: ");
        if (convid != null) {
            int i = 0;
            while (i < convid.length) {
                text.append(HEX[(byte)(convid[i] & 0xF)]);
                ++i;
            }
        } else {
            text.append("<null>");
        }
        text.append(" ");
        text.append(Trc.getTimeStampShort());
        text.append("\n");
        Trc.ab_rfctrc(text.toString());
    }

    public static void criticalTrace(long handle, String text) {
        RfcIoOpenCntl act_cntl = RfcIoControl.ab_rfccntl(handle);
        Trc.criticalTrace(act_cntl, text);
    }

    public static synchronized void criticalTrace(String description, Exception ex) {
        Trc.openErrorTrace();
        if (m_errorTraceFile == null) {
            return;
        }
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            pw.flush();
            pw.close();
            FastStringBuffer text = new FastStringBuffer(256);
            text.append("Exception thrown [").append(Trc.getTimeStamp());
            text.append("]:").append(description).append("\n");
            text.append(sw.toString()).append("\n");
            Trc.writeInErrorTrace(text.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized void criticalTrace(String description, Error er) {
        Trc.openErrorTrace();
        if (m_errorTraceFile == null) {
            return;
        }
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            er.printStackTrace(pw);
            pw.flush();
            pw.close();
            FastStringBuffer text = new FastStringBuffer(256);
            text.append("Error thrown [").append(Trc.getTimeStamp());
            text.append("]:").append(description).append("\n");
            text.append(sw.toString()).append("\n");
            Trc.writeInErrorTrace(text.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized void criticalTrace(RfcIoOpenCntl act_cntl, String txt) {
        Trc.openErrorTrace();
        if (m_errorTraceFile == null) {
            return;
        }
        try {
            StringBuffer text = new StringBuffer(128);
            text.append("Error> occured ");
            if (act_cntl != null) {
                text.append("[");
                text.append(act_cntl.hrfc);
                text.append("]");
            }
            text.append(" >");
            text.append(Trc.getTimeStamp());
            text.append("<    ");
            text.append(txt);
            text.append("\n");
            Trc.writeInErrorTrace(text.toString());
            if (act_cntl != null && act_cntl.trace) {
                Trc.ab_rfctrc(text.toString());
            }
        }
        catch (Exception ex) {
            return;
        }
    }

    private static synchronized void openErrorTrace() {
        if (m_errorTraceFile == null) {
            try {
                Date date = new Date();
                StringBuffer fileName = new StringBuffer(256);
                String path = JCO.getProperty("jco.trace_path");
                if (path == null) {
                    path = System.getProperty("jco.trace_path");
                }
                if (path != null) {
                    fileName.append(path);
                    fileName.append(System.getProperty("file.separator"));
                }
                fileName.append(m_errorFileName);
                m_errorFile = new File(fileName.toString());
                m_errorTraceFile = new FileWriter(fileName.toString(), true);
                m_errorTraceFile.write("\n**** Error file opened at " + openFileSyncDateFormat.format(date) + " Rel " + JCO.getVersion() + " [" + RfcApi.RfcgetVersion() + "]\n");
                m_errorTraceFile.flush();
            }
            catch (Exception ex) {
                m_errorTraceFile = null;
                return;
            }
        }
    }

    public static synchronized void closeErrorTrace() {
        try {
            m_errorTraceFile.flush();
            m_errorTraceFile.close();
            m_errorTraceFile = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized void closeTrace() {
        FileWriter traceFile = Trc.opentrace();
        if (traceFile == null) {
            return;
        }
        try {
            traceFile.flush();
        }
        catch (Exception ex) {
            return;
        }
    }

    private static void writeInErrorTrace(String text) {
        if (text == null) {
            return;
        }
        Class clazz = class$com$sap$mw$rfc$engine$Trc == null ? (class$com$sap$mw$rfc$engine$Trc = Trc.class$("com.sap.mw.rfc.engine.Trc")) : class$com$sap$mw$rfc$engine$Trc;
        synchronized (clazz) {
            long length = m_errorFile.length();
            if (length > MAX_ERROR_FILE_LENGTH) {
                Date now = new Date();
                boolean isClosed = false;
                try {
                    if (m_errorTraceFile != null) {
                        m_errorTraceFile.flush();
                        m_errorTraceFile.close();
                        m_errorTraceFile = null;
                        isClosed = true;
                    }
                }
                catch (IOException e) {
                    isClosed = false;
                }
                if (isClosed) {
                    String fullName = m_errorFile.getAbsolutePath();
                    String name = fullName.substring(0, fullName.lastIndexOf("."));
                    String timestamp = fileNameTimestampFormat.format(now);
                    if (m_errorFile.renameTo(new File(name + "." + timestamp + ".trc"))) {
                        try {
                            m_errorFile.delete();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        m_errorFile = null;
                    }
                    Trc.openErrorTrace();
                }
            }
            try {
                if (m_errorTraceFile != null) {
                    m_errorTraceFile.write(text);
                    m_errorTraceFile.flush();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public static FileWriter opentrace() {
        StringBuffer fName = new StringBuffer(256);
        FileWriter traceFile = null;
        if (m_traceFiles == null) {
            return null;
        }
        String path = JCO.getProperty("jco.trace_path");
        if (path == null) {
            path = System.getProperty("jco.trace_path");
        }
        if (path != null && new File(path).isDirectory()) {
            fName.append(path);
            fName.append(System.getProperty("file.separator"));
        }
        fName.append(CpicDriver.getTraceFileName());
        traceFile = (FileWriter)m_traceFiles.get(fName.toString());
        if (traceFile == null) {
            Hashtable hashtable = m_traceFiles;
            synchronized (hashtable) {
                traceFile = (FileWriter)m_traceFiles.get(fName.toString());
                if (traceFile == null) {
                    try {
                        Date date = new Date();
                        traceFile = new FileWriter(fName.toString(), true);
                        traceFile.write("\n**** Trace file opened at " + openFileSyncDateFormat.format(date) + " Rel " + JCO.getVersion() + " [" + RfcApi.RfcgetVersion() + "]\n");
                        traceFile.flush();
                        m_traceFiles.put(fName.toString(), traceFile);
                    }
                    catch (Exception ex) {
                        StringBuffer msg = new StringBuffer(256);
                        msg.append("JRFC Error> Could not create regular trace file\n");
                        msg.append("    exception occured: ");
                        msg.append(ex.getMessage());
                        Trc.criticalTrace(0L, msg.toString());
                        FileWriter fileWriter = null;
                        return fileWriter;
                    }
                }
            }
        }
        return traceFile;
    }

    public static String getTimeStamp() {
        return m_syncDateFormat.format(new Date());
    }

    public static String getTimeStampShort() {
        return m_syncDateFormatShort.format(new Date());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        m_traceFiles = new Hashtable(17);
        m_syncDateFormat = new SyncDateFormat(m_timeStampFormat);
        m_syncDateFormatShort = new SyncDateFormat(m_timeStampFormatShort);
        openFileSyncDateFormat = new SyncDateFormat(openFileTimeStampFormat);
        try {
            MAX_ERROR_FILE_LENGTH = Integer.parseInt(System.getProperty("jrfc.logfile.maxsize", "8")) * 1024 * 1024;
        }
        catch (Exception e) {
            MAX_ERROR_FILE_LENGTH = 0x800000L;
        }
    }
}

