/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.rfc.engine;

import com.sap.mw.jco.util.ConnectionInfo;
import com.sap.mw.rfc.api.RfcOptions;
import com.sap.mw.rfc.engine.ConvIdMap;
import com.sap.mw.rfc.engine.RfcAcceptInfo;
import com.sap.mw.rfc.engine.RfcIoOpenCntl;
import com.sap.mw.rfc.engine.Trc;
import com.sap.mw.rfc.exceptions.RfcException;
import java.util.ArrayList;

public abstract class RfcIoControl {
    private static final int MAX_HANDLE = 10000;
    private static RfcIoOpenCntl[] rfc_gl_open_phkey = new RfcIoOpenCntl[10000];

    public static void main(String[] argv) {
        int i = 1;
        while (i < 2002) {
            try {
                long handle = RfcIoControl.open_new();
                System.out.println("i = " + i + " Handle = " + handle + "\n");
            }
            catch (RfcException ex) {
                System.out.println("Exception occured:" + ex.getMessage() + "\n");
                System.exit(1);
            }
            ++i;
        }
    }

    public static long ab_rfcaccept(int rfctype, RfcAcceptInfo acceptInfo) throws RfcException {
        RfcIoOpenCntl act_cntl = null;
        long handle = 0L;
        int rc = 0;
        handle = RfcIoControl.open_new();
        if (handle == 0L) {
            return 0L;
        }
        act_cntl = RfcIoControl.rfc_gl_cntl(handle);
        act_cntl.name = new String("< accepted >");
        act_cntl.type = rfctype;
        act_cntl.accepted = true;
        act_cntl.input = true;
        act_cntl.rfc_role = (char)83;
        if (act_cntl.open_channel() != 0) {
            RfcIoControl.error_end(handle);
        }
        rc = act_cntl.channel.accept(acceptInfo);
        act_cntl.rfctrace("ACCEPT", null, 0);
        if (rc != 0) {
            RfcIoControl.error_end(handle);
        }
        return handle;
    }

    public static long ab_rfcopen(String key, String destination, int type, RfcOptions options) throws RfcException {
        RfcIoOpenCntl exists_cntl;
        RfcIoOpenCntl act_cntl = null;
        long handle = 0L;
        int rc = 0;
        handle = RfcIoControl.open_new();
        if (handle == 0L) {
            if (act_cntl.trace) {
                Trc.ab_rfctrc("ab_rfcopen :: Error : Handle == 0\n");
            }
            return 0L;
        }
        act_cntl = RfcIoControl.rfc_gl_cntl(handle);
        act_cntl.opened = false;
        if (destination != null) {
            act_cntl.destination = destination;
        }
        if (key != null) {
            act_cntl.name = key;
        }
        act_cntl.type = type;
        act_cntl.rfcio_setopt(options);
        if (act_cntl.open_channel() != 0) {
            RfcIoControl.error_end(handle);
        }
        act_cntl.rfctrace("OPEN", null, 0);
        rc = act_cntl.channel.open(options);
        if (rc != 0) {
            RfcIoControl.error_end(handle);
        } else if (act_cntl.type != 10 && (exists_cntl = (RfcIoOpenCntl)ConvIdMap.put(act_cntl.conv_id, act_cntl)) != null) {
            String errMsg = new StringBuffer(128).append("ab_rfcopen::open returns ").append(ConvIdMap.convIdToString(act_cntl.conv_id)).append(" that is already using in hanlde ").append(exists_cntl.hrfc).append(". Try once more.").toString();
            Trc.criticalTrace(handle, errMsg);
            act_cntl.channel.setMessageTRC(errMsg);
            RfcIoControl.error_end(handle);
        }
        if (act_cntl.m_buffer == null) {
            RfcIoControl.error_end(handle);
        }
        act_cntl.opened = true;
        act_cntl.rfc_role = (char)67;
        return handle;
    }

    public static RfcIoOpenCntl ab_rfccntl(long handle) {
        RfcIoOpenCntl act_cntl = null;
        if (rfc_gl_open_phkey == null) {
            return null;
        }
        act_cntl = RfcIoControl.rfc_gl_cntl(handle);
        if (act_cntl == null || !act_cntl.used) {
            return null;
        }
        return act_cntl;
    }

    private static long open_new() throws RfcException {
        RfcIoOpenCntl act_cntl = null;
        long actslot = 0L;
        RfcIoOpenCntl[] rfcIoOpenCntlArray = rfc_gl_open_phkey;
        synchronized (rfcIoOpenCntlArray) {
            actslot = 1L;
            while (actslot <= 10000L) {
                if (actslot == 10000L) {
                    throw new RfcException(1, "Maximal number of rfc connections reached", 106, "RFC_ERROR_RESOURCE", 0L, true);
                }
                if (rfc_gl_open_phkey[(int)actslot] == null) {
                    RfcIoControl.rfc_gl_open_phkey[(int)actslot] = act_cntl = new RfcIoOpenCntl();
                    break;
                }
                if (!RfcIoControl.rfc_gl_open_phkey[(int)actslot].used) {
                    act_cntl = RfcIoControl.rfc_gl_cntl(actslot);
                    act_cntl.reset();
                    break;
                }
                ++actslot;
            }
            act_cntl.used = true;
            act_cntl.hrfc = actslot;
            act_cntl.pcs = (byte)2;
            act_cntl.ignoreConvErr = 1;
            act_cntl.codepage = new String("4102");
        }
        return actslot;
    }

    private static RfcIoOpenCntl rfc_gl_cntl(long slot) {
        RfcIoOpenCntl act_cntl = null;
        if (slot == 0L || rfc_gl_open_phkey == null || slot >= 10000L) {
            return null;
        }
        act_cntl = rfc_gl_open_phkey[(int)slot];
        return act_cntl;
    }

    public static ConnectionInfo[] getConnectionsInfo() {
        ArrayList<ConnectionInfo> connectionsInfoList = new ArrayList<ConnectionInfo>();
        RfcIoOpenCntl[] rfcIoOpenCntlArray = rfc_gl_open_phkey;
        synchronized (rfcIoOpenCntlArray) {
            int i = 1;
            while (i < 10000 && rfc_gl_open_phkey[i] != null) {
                if (RfcIoControl.rfc_gl_open_phkey[i].used) {
                    byte role;
                    byte by = role = RfcIoControl.rfc_gl_open_phkey[i].rfc_role == 'C' ? (byte)2 : 1;
                    byte state = RfcIoControl.rfc_gl_open_phkey[i].deallocated ? (byte)2 : (RfcIoControl.rfc_gl_open_phkey[i].close_pending ? (byte)3 : (RfcIoControl.rfc_gl_open_phkey[i].closed ? (byte)4 : 1));
                    connectionsInfoList.add(new ConnectionInfo(role, RfcIoControl.rfc_gl_open_phkey[i].allocationType, state, RfcIoControl.rfc_gl_open_phkey[i].userid, RfcIoControl.rfc_gl_open_phkey[i].sysid));
                }
                ++i;
            }
        }
        ConnectionInfo[] connectionsInfo = new ConnectionInfo[connectionsInfoList.size()];
        connectionsInfoList.toArray(connectionsInfo);
        return connectionsInfo;
    }

    private static void error_end(long handle) throws RfcException {
        RfcIoOpenCntl act_cntl = RfcIoControl.ab_rfccntl(handle);
        String msg = new String("no message");
        if (act_cntl != null) {
            if (act_cntl.channel != null) {
                msg = new String(act_cntl.channel.getMessage());
            }
            act_cntl.ab_rfcclose();
            act_cntl.ab_rfcfree();
        }
        throw new RfcException(1, msg, 102, "RFC_ERROR_COMMUNICATION", 0L, true);
    }
}

