/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.rfc.engine;

import com.sap.mw.jco.util.SAPByteToCharConverter;
import com.sap.mw.jco.util.SAPConverters;
import com.sap.mw.rfc.api.IRfcFunction;
import com.sap.mw.rfc.engine.RfcGet;
import com.sap.mw.rfc.engine.RfcGetInfo;
import com.sap.mw.rfc.engine.RfcIoOpenCntl;
import com.sap.mw.rfc.engine.RfcValInfo;
import com.sap.mw.rfc.engine.Trc;
import com.sap.mw.rfc.exceptions.RfcException;
import com.sap.mw.rfc.exceptions.RfcGetException;
import com.sap.mw.rfc.sysfunc.RfcDocu;
import com.sap.mw.rfc.sysfunc.RfcPing;
import com.sap.mw.rfc.sysfunc.RfcSetRegServerProperty;
import com.sap.mw.rfc.sysfunc.RfcSystemInfo;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class RfcGetName {
    private static Hashtable m_installedFunctions = new Hashtable(17);

    public static void installFunction(IRfcFunction function) {
        String name = function.getName();
        Hashtable hashtable = m_installedFunctions;
        synchronized (hashtable) {
            IRfcFunction func = (IRfcFunction)m_installedFunctions.get(name);
            func = (IRfcFunction)m_installedFunctions.get(name);
            if (func != null) {
                m_installedFunctions.remove(name);
            }
            m_installedFunctions.put(name, function);
        }
    }

    public static IRfcFunction[] getInstalledFunctions() {
        Hashtable hashtable = m_installedFunctions;
        synchronized (hashtable) {
            Enumeration functionEnum = m_installedFunctions.elements();
            IRfcFunction[] functions = new IRfcFunction[m_installedFunctions.size()];
            int i = 0;
            while (functionEnum.hasMoreElements()) {
                functions[i] = (IRfcFunction)functionEnum.nextElement();
                ++i;
            }
            IRfcFunction[] iRfcFunctionArray = functions;
            return iRfcFunctionArray;
        }
    }

    public static IRfcFunction search_function(String name) {
        IRfcFunction func = null;
        Hashtable hashtable = m_installedFunctions;
        synchronized (hashtable) {
            func = (IRfcFunction)m_installedFunctions.get(name);
        }
        return func;
    }

    public static String rfcGetName_recall(RfcIoOpenCntl act_cntl) throws RfcException {
        String result = null;
        act_cntl.ab_rfcreset();
        result = RfcGetName.ab_RfcGetName(act_cntl);
        if (act_cntl.trace) {
            Trc.TRfcGetName(act_cntl.hrfc, result);
        }
        return result;
    }

    public static String ab_RfcDispatchLoc(RfcIoOpenCntl act_cntl) throws RfcException {
        String funcName = null;
        IRfcFunction funcPtr = null;
        funcName = RfcGetName.ab_RfcGetName(act_cntl);
        funcPtr = RfcGetName.search_function(funcName);
        if (funcPtr == null) {
            throw new RfcException(13, funcName, 101, "RFC_ERROR_PROGRAM", 0L, false);
        }
        if (act_cntl.trace) {
            String msg = new String(">>>> [" + act_cntl.hrfc + "] Dispatch call to:" + funcName + "\n");
            Trc.ab_rfctrc(msg);
        }
        funcPtr.execute(act_cntl.hrfc);
        return funcName;
    }

    public static void ab_RfcDispatch(RfcIoOpenCntl act_cntl) throws RfcException {
        String result = null;
        result = RfcGetName.ab_RfcDispatchLoc(act_cntl);
    }

    private static char[] ab_rfcxfname(RfcIoOpenCntl act_cntl) throws RfcGetException {
        RfcGetInfo rfcget_info = new RfcGetInfo();
        RfcValInfo val_info = new RfcValInfo();
        int initstate = 0;
        byte[] fname = new byte[64];
        char[] result = null;
        rfcget_info.fbInfo = val_info;
        val_info.RfcSetValInfoScalar(fname, fname.length);
        RfcGet.ab_rfcget(act_cntl, initstate, rfcget_info);
        try {
            SAPByteToCharConverter conv = SAPConverters.getSAPByteToCharConverter(act_cntl.charset);
            result = conv.convert(fname, 0, val_info.imp_leng - 1);
        }
        catch (Exception ex) {
            String msg = new String("  Error> ab_rfcxfname[" + act_cntl.hrfc + "]: " + ex.getMessage());
            throw new RfcGetException(14, msg);
        }
        return result;
    }

    public static String ab_RfcGetName(RfcIoOpenCntl act_cntl) throws RfcException {
        char[] fname = new char[64];
        String result = null;
        int strLen = 0;
        try {
            fname = RfcGetName.ab_rfcxfname(act_cntl);
        }
        catch (RfcGetException getEx) {
            String msg = new String("ab_RfcGetName failed: " + getEx.getMessage());
            switch (getEx.getRc()) {
                case 11: {
                    if (act_cntl.trace) {
                        Trc.ab_rfctrc("   ERROR: ab_rfcGetName [" + act_cntl.hrfc + "]\n");
                        Trc.ab_rfctrc("   closed\n");
                    }
                    throw new RfcException(6, msg, getEx.getErrorGroup(), getEx.getKey(), 0L, false);
                }
                case 19: {
                    if (act_cntl.trace) {
                        Trc.ab_rfctrc("   ERROR: ab_rfcGetName [" + act_cntl.hrfc + "]\n");
                        Trc.ab_rfctrc("   Invalid protocol version detected\n");
                    }
                    throw new RfcException(22, msg, getEx.getErrorGroup(), getEx.getKey(), 0L, false);
                }
                case 14: {
                    if (act_cntl.trace) {
                        Trc.ab_rfctrc("   ERROR: ab_rfcGetName [" + act_cntl.hrfc + "]\n");
                        Trc.ab_rfctrc("   Conversion error occured\n");
                    }
                    throw new RfcException(21, msg, getEx.getErrorGroup(), getEx.getKey(), 0L, false);
                }
            }
            if (act_cntl.trace) {
                Trc.ab_rfctrc("   ERROR: ab_rfcGetName [" + act_cntl.hrfc + "]\n");
                Trc.ab_rfctrc("   an error occured. get_rc: " + getEx.getRc() + "\n");
            }
            throw new RfcException(1, msg, getEx.getErrorGroup(), getEx.getKey(), 0L, false);
        }
        strLen = fname.length - 1;
        while (fname[strLen] == ' ') {
            --strLen;
        }
        result = new String(fname, 0, strLen + 1);
        return result;
    }

    private static synchronized void install_system_functions() {
        RfcPing ping = new RfcPing();
        RfcSystemInfo info = new RfcSystemInfo();
        RfcSetRegServerProperty rs = new RfcSetRegServerProperty();
        RfcDocu docu = new RfcDocu();
        RfcGetName.installFunction(ping);
        RfcGetName.installFunction(info);
        RfcGetName.installFunction(rs);
        RfcGetName.installFunction(docu);
    }

    static {
        try {
            RfcGetName.install_system_functions();
        }
        catch (Exception ex) {
            Trc.criticalTrace("Installation of system functions failed", ex);
        }
        catch (Error e) {
            Trc.criticalTrace("Installation of system functions failed", e);
        }
    }
}

