/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.rfc.engine;

import com.sap.mw.rfc.engine.RfcGetImp;
import com.sap.mw.rfc.engine.RfcGetInfo;
import com.sap.mw.rfc.engine.RfcImp;
import com.sap.mw.rfc.engine.RfcIoOpenCntl;
import com.sap.mw.rfc.engine.RfcUtilities;
import com.sap.mw.rfc.exceptions.RfcGetException;
import com.sap.mw.rfc.exceptions.RfcIoException;

public abstract class RfcGet {
    static final int RFCGET_FUNCTIONNAME = 0;
    static final int RFCGET_DATA = 1;
    static final int RFCGET_FIELDVALUE = 2;
    static final int RFCGET_TABLEINFO = 3;
    static final int RFCGET_TABLECONTENT = 4;
    static final int RFCGET_DELTADATA = 5;
    static final int RFGET_ENDOFDATA = 6;
    static final int RFCGET_INSPECT_MESSAGE = 7;

    public static int ab_rfcget(RfcIoOpenCntl act_cntl, int initstate, RfcGetInfo info_p) throws RfcGetException {
        int code = 0;
        code = RfcGet.rfcget_run(act_cntl, initstate, 0, info_p);
        return code;
    }

    private static int rfcget_run(RfcIoOpenCntl act_cntl, int rfcstate, int upto, RfcGetInfo info_p) throws RfcGetException {
        int rfcleng = 0;
        int rfcid = 0;
        boolean leave_run = false;
        boolean rc = false;
        boolean exit_code = false;
        boolean ec = false;
        boolean scrambled = false;
        boolean brc = false;
        block25: do {
            byte[] header = new byte[2];
            RfcGet.rfcget_gethead(act_cntl, header);
            rfcid = RfcGet.get_RFCPRO_ID(header);
            RfcGet.rfcget_gethead(act_cntl, header);
            rfcleng = RfcGet.get_RFCPRO_LENG(header);
            if (65535 == rfcleng) {
                byte[] leng32 = new byte[4];
                RfcGet.rfcget_gethead(act_cntl, leng32);
                rfcleng = RfcGet.get_RFCPRO_LENG32(leng32);
            }
            switch (rfcid) {
                case 257: {
                    RfcImp.ab_rfchead(act_cntl, rfcleng);
                    break;
                }
                case 259: {
                    RfcGet.rfcget_protocol(act_cntl);
                    break;
                }
                case 1300: {
                    RfcImp.ab_rfccheck_uuid(act_cntl, rfcleng);
                    break;
                }
                case 262: {
                    RfcImp.ab_rfcUnicodeHeader(act_cntl, rfcleng);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 17: 
                case 18: 
                case 19: 
                case 273: 
                case 276: 
                case 277: 
                case 305: {
                    RfcImp.rfcSetRemoteInfo(act_cntl, rfcid, rfcleng);
                    break;
                }
                case 1282: {
                    if (rfcstate == 1 || rfcstate == 7) {
                        RfcGet.rfcget_skip(act_cntl, rfcid, rfcleng);
                        throw new RfcGetException(9, null);
                    }
                }
                case 1280: {
                    if (rfcstate == 7) {
                        leave_run = true;
                    }
                    RfcGet.rfcget_skip(act_cntl, rfcid, rfcleng);
                    continue block25;
                }
                case 1025: {
                    if (1 != rfcstate) {
                        throw new RfcGetException(6, null);
                    }
                    RfcImp.ab_rfcerror(act_cntl, info_p, 1025, rfcleng);
                    break;
                }
                case 258: {
                    if (0 != rfcstate) {
                        throw new RfcGetException(6, null);
                    }
                    RfcImp.ab_rfcFunctionName(act_cntl, info_p, rfcid, rfcleng);
                    leave_run = true;
                    break;
                }
                case 1026: {
                    if (1 != rfcstate) {
                        throw new RfcGetException(6, null);
                    }
                    RfcImp.ab_rfcerror(act_cntl, info_p, rfcid, rfcleng);
                    leave_run = true;
                    break;
                }
                case 1041: 
                case 1042: 
                case 1043: 
                case 1044: 
                case 1045: 
                case 1046: 
                case 1047: {
                    if (1 != rfcstate) {
                        throw new RfcGetException(6, null);
                    }
                    RfcImp.ab_rfcerror(act_cntl, info_p, rfcid, rfcleng);
                    break;
                }
                case 513: {
                    if (1 != rfcstate) {
                        throw new RfcGetException(6, null);
                    }
                    RfcImp.ab_rfcname(act_cntl, info_p, rfcleng, rfcid);
                    rfcstate = 2;
                    break;
                }
                case 515: {
                    if (2 != rfcstate) {
                        throw new RfcGetException(6, null);
                    }
                    RfcGetImp.ab_rfcfvalue(act_cntl, info_p, rfcleng);
                    rfcstate = 1;
                    break;
                }
                case 769: {
                    if (1 != rfcstate) {
                        throw new RfcGetException(6, null);
                    }
                    RfcImp.ab_rfcname(act_cntl, info_p, rfcleng, rfcid);
                    rfcstate = 3;
                    break;
                }
                case 770: {
                    if (3 != rfcstate) {
                        throw new RfcGetException(6, null);
                    }
                    brc = RfcImp.ab_rfctinfo(act_cntl, info_p, rfcleng);
                    if (!brc) {
                        rfcstate = 4;
                        break;
                    }
                    rfcstate = 1;
                    break;
                }
                case 771: {
                    if (4 != rfcstate) {
                        throw new RfcGetException(6, null);
                    }
                    brc = RfcImp.ab_rfctcontent(act_cntl, info_p, rfcleng);
                    if (!brc) {
                        rfcstate = 4;
                        break;
                    }
                    rfcstate = 1;
                    break;
                }
                case 772: {
                    if (4 != rfcstate) {
                        throw new RfcGetException(6, null);
                    }
                    brc = RfcImp.ab_rfctcompr(act_cntl, info_p, rfcleng);
                    if (!brc) {
                        rfcstate = 4;
                        break;
                    }
                    rfcstate = 1;
                    break;
                }
                case 773: {
                    if (4 != rfcstate) {
                        throw new RfcGetException(6, null);
                    }
                    RfcImp.ab_rfctcontLZ(act_cntl, info_p, rfcleng, false);
                    rfcstate = 4;
                    break;
                }
                case 774: {
                    if (4 != rfcstate) {
                        throw new RfcGetException(6, null);
                    }
                    RfcImp.ab_rfctcontLZ(act_cntl, info_p, rfcleng, true);
                    rfcstate = 1;
                    break;
                }
                case 15362: {
                    RfcImp.receiveXMLParameter(act_cntl, info_p);
                    RfcGet.rfcget_skip(act_cntl, rfcid, rfcleng);
                    continue block25;
                }
                case 15365: {
                    if (RfcImp.receiveXMLData(act_cntl, info_p, rfcleng)) break;
                    RfcGet.rfcget_skip(act_cntl, rfcid, rfcleng);
                    continue block25;
                }
                case 1648: 
                case 1649: {
                    if (rfcleng <= 0) break;
                    RfcImp.receiveSso2String(act_cntl, rfcleng);
                    break;
                }
                case 65535: {
                    RfcGet.rfcget_skip(act_cntl, rfcid, rfcleng);
                    leave_run = true;
                    continue block25;
                }
                default: {
                    RfcGet.rfcget_skip(act_cntl, rfcid, rfcleng);
                    continue block25;
                }
            }
            RfcGet.rfcget_endcheck(act_cntl, rfcid);
        } while (!leave_run);
        return 0;
    }

    private static void rfcget_gethead(RfcIoOpenCntl act_cntl, byte[] head) throws RfcGetException {
        try {
            act_cntl.ab_rfcread(head, head.length, 0);
        }
        catch (RfcIoException ioEx) {
            switch (ioEx.getIoRc()) {
                case 10: {
                    throw new RfcGetException(11, ioEx.getMessage());
                }
                case 27: {
                    throw new RfcGetException(7, ioEx.getMessage());
                }
            }
            throw new RfcGetException(3, ioEx.getMessage());
        }
    }

    protected static void rfcget_skip(RfcIoOpenCntl act_cntl, int rid, int rleng) throws RfcGetException {
        boolean code = false;
        if (rid == 0) {
            throw new RfcGetException(2, "Skip Skiping invalid container");
        }
        RfcGet.rfcget_data(act_cntl, null, rleng);
        RfcGet.rfcget_endcheck(act_cntl, rid);
    }

    private static void rfcget_data(RfcIoOpenCntl act_cntl, byte[] buffer, int length) throws RfcGetException {
        try {
            act_cntl.ab_rfcread(buffer, length, 0);
        }
        catch (RfcIoException ioEx) {
            throw new RfcGetException(3, ioEx.getMessage());
        }
    }

    private static void rfcget_endcheck(RfcIoOpenCntl act_cntl, int rfcid) throws RfcGetException {
        byte[] end_buffer = new byte[2];
        int end_rfcid = 0;
        try {
            act_cntl.ab_rfcread(end_buffer, end_buffer.length, 0);
        }
        catch (RfcIoException ioEx) {
            StringBuffer msg = new StringBuffer(100);
            msg.append("EndCheck cannot read end container for: ");
            msg.append(rfcid);
            msg.append("rc: ");
            msg.append(ioEx.getIoRc());
            throw new RfcGetException(3, msg.toString());
        }
        end_rfcid = RfcGet.get_RFCPRO_ID(end_buffer);
        if (end_rfcid != rfcid) {
            StringBuffer msg = new StringBuffer(100);
            msg.append("EndCheck container chain broken for container expected: ");
            msg.append(rfcid);
            msg.append(" received: ");
            msg.append(end_rfcid);
            throw new RfcGetException(4, msg.toString());
        }
    }

    private static void rfcget_protocol(RfcIoOpenCntl act_cntl) throws RfcGetException {
        byte[] buffer = new byte[4];
        try {
            act_cntl.ab_rfcread(buffer, buffer.length, 0);
            int max_version = RfcUtilities.ICM15(buffer);
            act_cntl.protocol = act_cntl.ab_rfcproto(1, max_version);
        }
        catch (RfcIoException ioEx) {
            throw new RfcGetException(3, ioEx.getMessage());
        }
    }

    private static int get_RFCPRO_LENG(byte[] rid) {
        return RfcUtilities.ICM03(rid);
    }

    private static int get_RFCPRO_LENG32(byte[] rid) {
        return RfcUtilities.ICM15(rid);
    }

    private static int get_RFCPRO_ID(byte[] rid) {
        return RfcUtilities.ICM03(rid);
    }
}

