/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.rfc.engine;

import java.util.Hashtable;

public class ConvIdMap {
    private static final boolean checkConvIds;
    private static final char[] HEX;
    private static Hashtable table;

    private ConvIdMap() {
    }

    public static Object put(byte[] convIdBytes, Object newValue) {
        Object oldValue = null;
        if (checkConvIds) {
            ConvId convId = new ConvId(convIdBytes);
            Hashtable hashtable = table;
            synchronized (hashtable) {
                Object v = table.get(convId);
                oldValue = v;
                if (v == null) {
                    table.put(convId, newValue);
                }
            }
        }
        return oldValue;
    }

    public static void remove(byte[] convIdBytes) {
        if (checkConvIds) {
            ConvId convId = new ConvId(convIdBytes);
            Hashtable hashtable = table;
            synchronized (hashtable) {
                try {
                    table.remove(convId);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static String convIdToString(byte[] bytes) {
        StringBuffer buf = new StringBuffer();
        int i = bytes.length - 1;
        while (i >= 0) {
            buf.append(HEX[bytes[i] >>> 4 & 0xF]);
            buf.append(HEX[bytes[i] & 0xF]);
            --i;
        }
        return buf.toString();
    }

    private static byte[] longToBytes(long l) {
        byte[] bytes = new byte[8];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = (byte)(l >>> 8 * i);
            ++i;
        }
        return bytes;
    }

    private static long bytesToLong(byte[] bytes) {
        long l = 0L;
        int i = bytes.length - 1;
        while (i >= 0) {
            l <<= 8;
            l |= (long)bytes[i] & 0xFFL;
            --i;
        }
        return l;
    }

    static {
        String checkConvIds_p = System.getProperty("jrfc.check_convid", "0").trim();
        checkConvIds = !checkConvIds_p.equals("0") && !checkConvIds_p.equals("false");
        HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        table = new Hashtable(211);
    }

    private static class ConvId {
        private long convId = 0L;
        private byte[] bytes;

        protected ConvId(byte[] bytes) {
            if (bytes == null) {
                bytes = new byte[8];
            }
            this.convId = ConvIdMap.bytesToLong(bytes);
            this.bytes = bytes;
        }

        public int hashCode() {
            return (int)(this.convId ^ this.convId >> 32);
        }

        public boolean equals(Object o) {
            try {
                return this.convId == ((ConvId)o).convId;
            }
            catch (ClassCastException ex) {
                return false;
            }
        }

        public String toString() {
            return ConvIdMap.convIdToString(this.bytes);
        }
    }
}

