/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.rfc.driver;

import com.sap.mw.jco.JCO;
import com.sap.mw.rfc.api.RfcOptions;
import com.sap.mw.rfc.data.ARFCSDATA;
import com.sap.mw.rfc.data.ARfcSDataHeader;
import com.sap.mw.rfc.driver.RfcDriver;
import com.sap.mw.rfc.engine.RfcAcceptInfo;
import com.sap.mw.rfc.engine.RfcIoOpenCntl;
import com.sap.mw.rfc.engine.RfcPlaybackInfo;
import com.sap.mw.rfc.engine.Trc;

public class RfcTypePlayback
extends RfcDriver {
    private static final int blocksize = 1785;
    public ARFCSDATA itab_h;
    public ARfcSDataHeader key = new ARfcSDataHeader();
    public boolean pr_mode;
    public int linno;

    public RfcTypePlayback(RfcIoOpenCntl iocntl) {
        super(iocntl);
    }

    public synchronized int open(RfcOptions options) {
        this.pr_mode = true;
        return 0;
    }

    public synchronized int accept(RfcAcceptInfo acceptInfo) {
        RfcPlaybackInfo info = (RfcPlaybackInfo)acceptInfo;
        this.pr_mode = false;
        this.itab_h = info.itab_h;
        this.linno = 0;
        return 0;
    }

    public synchronized int write(byte[] buffer, int buffersize, boolean last) {
        JCO.Table data = this.itab_h.getTable();
        if (!this.pr_mode) {
            return 0;
        }
        data.appendRow();
        data.setValue(this.key.getTID(), 0);
        data.setValue(this.key.getDestination(), 1);
        data.setValue(this.key.getLuwCounter(), 2);
        data.setValue(this.key.getBlockCounter(), 3);
        data.setValue(buffer, 4);
        this.key.incrementBlockCounter();
        return 0;
    }

    public synchronized int read(byte[] buffer, int buffersize, int[] bytes_read) {
        JCO.Table table = this.itab_h.getTable();
        byte[] ptr = null;
        if (this.pr_mode) {
            return 0;
        }
        if (table.getNumRows() <= this.linno) {
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("read(RfcTypePlayback) :: Error : " + Integer.toString(10));
            }
            return 10;
        }
        table.setRow(this.linno);
        ++this.linno;
        ptr = table.getByteArray(4);
        System.arraycopy(ptr, 0, buffer, 0, Math.min(1785, ptr.length));
        bytes_read[0] = 1785;
        return 0;
    }

    public int rflush() {
        return 0;
    }

    public int wflush() {
        return 0;
    }

    public void close() {
    }

    public void abort() {
    }

    public int devbuf() {
        return 1785;
    }

    public int listen(byte[] buffer, int buffersize, int[] bytes_read, int timeout) {
        return 0;
    }

    public void info(byte[] info) {
    }

    public int proto(int set_get, int proto) {
        return 0;
    }

    public void wait(byte[] buffer, int bufsize, int[] bytes_read) {
        bytes_read[0] = 0;
    }
}

