/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.rfc.api;

import com.sap.mw.jco.util.FastStringBuffer;
import com.sap.mw.rfc.engine.RfcAcceptInfo;

public final class RfcRegisterInfo
extends RfcAcceptInfo {
    public String tpname;
    public String gwhost;
    public String gwserv;
    public String saprouter;
    public boolean rfc_trace = false;
    public boolean snc_mode = false;
    public byte snc_qop;
    public String snc_myname;
    public String snc_lib;
    public byte allocationType = (byte)3;
    public static final byte RFC_SNC_QOP_INVALID = 0;
    public static final byte RFC_SNC_QOP_OPEN = 1;
    public static final byte RFC_SNC_QOP_INTEGRITY = 2;
    public static final byte RFC_SNC_QOP_PRIVACY = 3;
    public static final byte RFC_SNC_QOP_DEFAULT = 8;
    public static final byte RFC_SNC_QOP_MAX = 9;
    private static String SP = "    ";

    public String toString() {
        FastStringBuffer buf = new FastStringBuffer();
        buf.append(" -g\"").append(this.gwhost).append("\" -x\"").append(this.gwserv);
        buf.append("\" -a\"").append(this.tpname).append('\"');
        if (this.saprouter != null) {
            buf.append(" -r\"").append(this.saprouter).append('\"');
        }
        if (this.snc_mode) {
            buf.append(" -S\"").append(this.snc_myname).append('\"');
            if (this.snc_lib != null) {
                buf.append(" -L\"").append(this.snc_lib).append('\"');
            }
            if (this.snc_qop != -1) {
                buf.append(" -Q\"").append(Byte.toString(this.snc_qop)).append('\"');
            }
        }
        if (this.rfc_trace) {
            buf.append(" -t");
        }
        return buf.toString();
    }

    public String TrctoString(long handle) {
        FastStringBuffer buffer = new FastStringBuffer();
        buffer.append("*> RfcRegisterProgram ... \n");
        buffer.append(this.tpname == null ? SP + "Server Program ID     = <null>\n" : SP + "Server Program ID     = " + this.tpname + '\n');
        buffer.append(this.gwhost == null ? SP + "Host name of Gateway  = <null> \n" : SP + "Host name of Gateway  = " + this.gwhost + '\n');
        buffer.append(this.gwserv == null ? SP + "Service of Gateway    = <null>\n" : SP + "Service of Gateway    = " + this.gwserv + '\n');
        buffer.append(this.rfc_trace ? SP + "RFC-Trace             = ON\n" : SP + "RFC-Trace             = OFF\n");
        if (this.saprouter != null) {
            buffer.append(SP).append("SAPRouterstring       = ").append(this.saprouter).append("\n");
        }
        buffer.append(this.snc_mode ? SP + "SNC                   = ON\n" : "");
        buffer.append(this.snc_myname != null ? SP + "SNC Own Name          = " + this.snc_myname + '\n' : "");
        buffer.append(this.snc_lib != null ? SP + "SNC Library Name      = " + this.snc_lib + '\n' : "");
        if (handle == 0L) {
            buffer.append("<* Error: RfcRegisterProgram failed !!!\n");
        } else {
            buffer.append(SP + "RFC Handle            = " + handle + "\n");
            buffer.append("<* RfcRegisterProgram ended successfully *>\n");
        }
        return buffer.toString();
    }
}

