/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.jco.util;

public class Utf8ByteToCharConverter {
    int remainingBytes = 0;

    /*
     * Enabled aggressive block sorting
     */
    public int convert(byte[] in, int inBeginIndex, int inEndIndex, char[] out, int outBeginIndex, int outEndIndex) {
        if (in == null) {
            return 0;
        }
        if (inBeginIndex < 0) {
            return 0;
        }
        if (inBeginIndex >= in.length) {
            return 0;
        }
        if (inEndIndex >= in.length) {
            inEndIndex = in.length - 1;
        }
        if (inBeginIndex > inEndIndex) {
            return 0;
        }
        if (out == null) {
            return 0;
        }
        if (outBeginIndex < 0) {
            return 0;
        }
        if (outBeginIndex >= out.length) {
            return 0;
        }
        if (outEndIndex >= out.length) {
            outEndIndex = out.length - 1;
        }
        if (outBeginIndex > outEndIndex) {
            return 0;
        }
        int inIndex = inBeginIndex;
        int outIndex = outBeginIndex;
        this.remainingBytes = 0;
        block5: while (inIndex <= inEndIndex && outIndex <= outEndIndex) {
            if (in[inIndex] >= 0) {
                out[outIndex++] = (char)in[inIndex++];
                continue;
            }
            switch (in[inIndex] & 0xF0) {
                case 192: 
                case 208: {
                    if (inIndex + 1 > inEndIndex) {
                        inIndex = inEndIndex;
                        this.remainingBytes = 1;
                        break;
                    }
                    if ((in[inIndex + 1] & 0xC0) != 128) break;
                    out[outIndex++] = (char)((in[inIndex] & 0x1F) << 6 | in[inIndex + 1] & 0x3F);
                    inIndex += 2;
                    continue block5;
                }
                case 224: {
                    if (inIndex + 2 > inEndIndex) {
                        this.remainingBytes = inEndIndex - inIndex + 1;
                        inIndex = inEndIndex;
                        break;
                    }
                    if ((in[inIndex + 1] & 0xC0) != 128 || (in[inIndex + 2] & 0xC0) != 128) break;
                    out[outIndex++] = (char)(((in[inIndex] & 0xF) << 6 | in[inIndex + 1] & 0x3F) << 6 | in[inIndex + 2] & 0x3F);
                    inIndex += 3;
                    continue block5;
                }
                case 240: {
                    int charid;
                    if ((in[inIndex] & 8) == 0) {
                        if (inIndex + 3 > inEndIndex) {
                            this.remainingBytes = inEndIndex - inIndex + 1;
                            inIndex = inEndIndex;
                            break;
                        }
                        if ((in[inIndex + 1] & 0xC0) != 128 || (in[inIndex + 2] & 0xC0) != 128 || (in[inIndex + 3] & 0xC0) != 128) break;
                        charid = (((in[inIndex] & 7) << 6 | in[inIndex + 1] & 0x3F) << 6 | in[inIndex + 2] & 0x3F) << 6 | in[inIndex + 3] & 0x3F;
                        inIndex += 4;
                    } else if ((in[inIndex] & 4) == 0) {
                        if (inIndex + 4 > inEndIndex) {
                            this.remainingBytes = inEndIndex - inIndex + 1;
                            inIndex = inEndIndex;
                            break;
                        }
                        if ((in[inIndex + 1] & 0xC0) != 128 || (in[inIndex + 2] & 0xC0) != 128 || (in[inIndex + 3] & 0xC0) != 128 || (in[inIndex + 4] & 0xC0) != 128) break;
                        charid = ((((in[inIndex] & 3) << 6 | in[inIndex + 1] & 0x3F) << 6 | in[inIndex + 2] & 0x3F) << 6 | in[inIndex + 3] & 0x3F) << 6 | in[inIndex + 4] & 0x3F;
                        inIndex += 5;
                    } else {
                        if ((in[inIndex] & 2) != 0) break;
                        if (inIndex + 5 > inEndIndex) {
                            this.remainingBytes = inEndIndex - inIndex + 1;
                            inIndex = inEndIndex;
                            break;
                        }
                        if ((in[inIndex + 1] & 0xC0) != 128 || (in[inIndex + 2] & 0xC0) != 128 || (in[inIndex + 3] & 0xC0) != 128 || (in[inIndex + 4] & 0xC0) != 128 || (in[inIndex + 5] & 0xC0) != 128) break;
                        charid = (((((in[inIndex] & 1) << 6 | in[inIndex + 1] & 0x3F) << 6 | in[inIndex + 2] & 0x3F) << 6 | in[inIndex + 3] & 0x3F) << 6 | in[inIndex + 4] & 0x3F) << 6 | in[inIndex + 5] & 0x3F;
                        inIndex += 6;
                    }
                    if (charid < 65536) {
                        out[outIndex++] = (char)charid;
                        continue block5;
                    }
                    if (charid < 69632) {
                        if (outIndex == outEndIndex) {
                            inIndex = inEndIndex + 1;
                            continue block5;
                        }
                        out[outIndex++] = (char)((charid -= 65536) >> 10 & 0x3FF | 0xD800);
                        out[outIndex++] = (char)(charid & 0x3FF | 0xDC00);
                        continue block5;
                    }
                    out[outIndex++] = 35;
                    continue block5;
                }
            }
            if (inIndex < inEndIndex) {
                out[outIndex++] = 35;
            }
            ++inIndex;
            while (inIndex <= inEndIndex && (in[inIndex] & 0xC0) == 128) {
                ++inIndex;
            }
        }
        if (inIndex <= inEndIndex) {
            this.remainingBytes = inEndIndex - inIndex + 1;
        }
        return outIndex - outBeginIndex;
    }

    public int getRemainingByteCount() {
        return this.remainingBytes;
    }
}

