/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.jco.support;

import com.sap.mw.jco.About;
import com.sap.mw.jco.IFunctionTemplate;
import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.JCO;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class SapInfo {
    String[] connAttrList;
    Properties connAttr;
    static IRepository myRepos;
    static IRepository myUnicodeRepos;
    static String REPOS_NAME;
    static PrintStream out;

    public SapInfo(String[] connAttrs) {
        this.connAttrList = connAttrs;
        this.loadProperties();
    }

    protected void displayInfo() {
        if (((Hashtable)this.connAttr).containsKey("-v")) {
            String[] args = new String[]{"-stdout"};
            new About().show(args);
        }
        if (!((Hashtable)this.connAttr).containsKey("-v") && ((Hashtable)this.connAttr).size() < 2) {
            SapInfo.displayHelp();
        } else {
            ((Hashtable)this.connAttr).remove("-v");
            if (((Hashtable)this.connAttr).size() > 1) {
                this.getSystemInfo();
            }
        }
    }

    private void getSystemInfo() {
        JCO.Client client = null;
        JCO.Function function = null;
        try {
            client = JCO.createClient(this.connAttr);
        }
        catch (Throwable thr) {
            out.println("Cannot create client, error message: \n" + thr);
            return;
        }
        this.turnOnTracingAndDebugging(client);
        try {
            client.connect();
        }
        catch (Throwable thr) {
            out.println("Cannot open connection, error message: \n" + thr);
            if (client != null) {
                client.disconnect();
            }
            return;
        }
        try {
            String cp = client.getAttributes().getPartnerCodepage();
            IFunctionTemplate ftemplate = cp.charAt(0) == '4' ? myUnicodeRepos.getFunctionTemplate("RFC_SYSTEM_INFO") : myRepos.getFunctionTemplate("RFC_SYSTEM_INFO");
            function = new JCO.Function(ftemplate);
            client.execute(function);
        }
        catch (Throwable thr) {
            out.println("Cannot call RFC_SYSTEM_INFO, error message: \n" + thr);
            if (client != null) {
                client.disconnect();
            }
            return;
        }
        this.displaySystemInfo(function.getExportParameterList().getStructure("RFCSI_EXPORT"));
        try {
            client.disconnect();
        }
        catch (Throwable thr) {
            out.println("Cannot disconnect client, error message: \n" + thr);
            return;
        }
    }

    private void turnOnTracingAndDebugging(JCO.Client client) {
        int traceLevel = 0;
        if (((Hashtable)this.connAttr).containsKey("jco_trace_level")) {
            try {
                traceLevel = Integer.parseInt(this.connAttr.getProperty("jco_trace_level"));
            }
            catch (NumberFormatException ex) {
                out.println("JCo trace level must be a number.");
                System.exit(1);
            }
        }
        JCO.setTraceLevel(traceLevel);
        if (((Hashtable)this.connAttr).containsKey("jco_trace_path")) {
            JCO.setTracePath(this.connAttr.getProperty("jco_trace_path"));
        } else if (traceLevel > 0) {
            JCO.setTracePath(".");
        }
        if (((Hashtable)this.connAttr).containsKey("rfc_trace_level")) {
            try {
                client.setTrace(Integer.parseInt(this.connAttr.getProperty("rfc_trace_level")) > 0);
            }
            catch (NumberFormatException ex) {
                out.println("Rfc trace level must be a number.");
                System.exit(1);
            }
        }
        if (((Hashtable)this.connAttr).containsKey("abap_debug")) {
            try {
                client.setAbapDebug(Integer.parseInt(this.connAttr.getProperty("abap_debug")) > 0);
            }
            catch (NumberFormatException ex) {
                out.println("Abap debug option must be a number.");
                System.exit(1);
            }
        }
        if (((Hashtable)this.connAttr).containsKey("use_sapgui")) {
            try {
                client.setSapGui(Integer.parseInt(this.connAttr.getProperty("use_sapgui")));
            }
            catch (NumberFormatException ex) {
                out.println("Sapgui option must be a number.");
                System.exit(1);
            }
        }
    }

    private void displaySystemInfo(JCO.Structure sysInfo) {
        String systemInfo = "\nSAP System Information:\n-----------------------------------------------------\n";
        systemInfo = systemInfo + "Destination       \t" + sysInfo.getField("RFCDEST").getValue() + "\n\n";
        systemInfo = systemInfo + "Host              \t" + sysInfo.getField("RFCHOST").getValue() + "\n";
        systemInfo = systemInfo + "System ID         \t" + sysInfo.getField("RFCSYSID").getValue() + "\n";
        systemInfo = systemInfo + "Database          \t" + sysInfo.getField("RFCDATABS").getValue() + "\n";
        systemInfo = systemInfo + "DB Host           \t" + sysInfo.getField("RFCDBHOST").getValue() + "\n";
        systemInfo = systemInfo + "DB System         \t" + sysInfo.getField("RFCDBSYS").getValue() + "\n\n";
        systemInfo = systemInfo + "SAP Release       \t" + sysInfo.getField("RFCSAPRL").getValue() + "\n";
        systemInfo = systemInfo + "SAP Kernel Release\t" + sysInfo.getField("RFCKERNRL").getValue() + "\n\n";
        systemInfo = systemInfo + "RFC Protocol      \t" + sysInfo.getField("RFCPROTO").getValue() + "\n";
        systemInfo = systemInfo + "Characters        \t" + sysInfo.getField("RFCCHARTYP").getValue() + "\n";
        systemInfo = systemInfo + "Integers          \t" + sysInfo.getField("RFCINTTYP").getValue() + "\n";
        systemInfo = systemInfo + "Floating P.       \t" + sysInfo.getField("RFCFLOTYP").getValue() + "\n";
        systemInfo = systemInfo + "SAP Computer Id   \t" + sysInfo.getField("RFCMACH").getValue() + "\n\n";
        systemInfo = systemInfo + "Timezone          \t" + sysInfo.getField("RFCTZONE").getValue() + "\n";
        out.println(systemInfo);
    }

    private static void displayHelp() {
        String help = "Syntax:   sapinfo -v        displays JCo versions\n         or\n          sapinfo <options>\n\nOptions must have the following structure:\n      ID=value ID=value ... ID=value \nSome of them are directly used as RFC connection parameters.\nValues are case-sensitive but ID's are not. Values which include blanks \nmust be set between quotation marks. Following options are possible:\n\n ID's FOR SAP LOGON:\n   client=... user=... passwd=... lang=...\n\n SPECIAL ID's\n   jco_trace_level=[0,1,..,10] jco_trace_path=<directory> \n   rfc_trace_level=[0,1] abap_debug=[0,1] sap_gui=[0,1,2]\n\n CONNECT TO R/3\n   + LOAD BALANCING \n      sapinfo r3name=BIN mshost=hs0311 [group=...]\n     or\n      sapinfo r3name=BIN mshost=/H/sapgate1/S/3297/H/hs0311\n\n   + SPECIFIC APPLICATION SERVER\n      sapinfo ashost=pcintel sysnr=53\n     or\n      sapinfo ashost=/H/sapgate1/S/3297/H/pcintel sysnr=53\n\n   + CONNECT VIA FASTRFC\n     sapinfo type=F profile_name=C:\\\\profile\\\\B6Q_D25_PWDF0633\n\n CONNECT TO R/2\n   sapinfo type=2 dest=K50 gwhost=... gwserv=...\n\n CONNECT TO EXTERNAL PROGRAM\n   + RFC SERVER IS ALREADY REGISTERED AT SAP GATEWAY\n     sapinfo type=E gwhost=... gwserv=... tpname=...\n\n   + RFC SERVER WILL BE STARTED BY SAP GATEWAY\n     sapinfo type=E gwhost=... gwserv=... tpname=... tphost=...\n";
        out.println(help);
    }

    protected void loadProperties() {
        Properties connAttrTmp = new Properties();
        int i = 0;
        while (i < this.connAttrList.length) {
            try {
                connAttrTmp.load(new ByteArrayInputStream(this.connAttrList[i].getBytes()));
            }
            catch (IOException ex) {
                out.println("Call has incorrect syntax: " + ex + "\nHave a look at the help:");
                SapInfo.displayHelp();
            }
            ++i;
        }
        this.connAttr = new Properties();
        Enumeration<?> propKeys = connAttrTmp.propertyNames();
        while (propKeys.hasMoreElements()) {
            String key = (String)propKeys.nextElement();
            ((Hashtable)this.connAttr).put(key.toLowerCase(), connAttrTmp.getProperty(key));
        }
    }

    public static void main(String[] argv) {
        SapInfo SapInfo2 = new SapInfo(argv);
        SapInfo2.displayInfo();
    }

    static {
        REPOS_NAME = "SYSTEM_INFO_REPOS";
        out = System.out;
        myRepos = new MyRepository("REPOS_NAME");
        myUnicodeRepos = new MyRepository("UNICODE_REPOSITORY");
        JCO.MetaData mdRFCSI = new JCO.MetaData("RFCSI");
        mdRFCSI.addInfo("RFCPROTO", 0, 3, 0, 0, null, "RFC log version", 0, null, null);
        mdRFCSI.addInfo("RFCCHARTYP", 0, 4, 3, 0, null, "Character set (SAP name)", 0, null, null);
        mdRFCSI.addInfo("RFCINTTYP", 0, 3, 7, 0, null, "Integer format (1 / 2 = little / big endian)", 0, null, null);
        mdRFCSI.addInfo("RFCFLOTYP", 0, 3, 10, 0, null, "Floating point format (1=IEEE, 2=IBM/370 format)", 0, null, null);
        mdRFCSI.addInfo("RFCDEST", 0, 32, 13, 0, null, "Logical destination (specified in function call)", 0, null, null);
        mdRFCSI.addInfo("RFCHOST", 0, 8, 45, 0, null, "Character field of length 8", 0, null, null);
        mdRFCSI.addInfo("RFCSYSID", 0, 8, 53, 0, null, "R/3 System, name of R/3 System", 0, null, null);
        mdRFCSI.addInfo("RFCDATABS", 0, 8, 61, 0, null, "R/3 System, name of R/3 System", 0, null, null);
        mdRFCSI.addInfo("RFCDBHOST", 0, 32, 69, 0, null, "Database host name", 0, null, null);
        mdRFCSI.addInfo("RFCDBSYS", 0, 10, 101, 0, null, "R/3 System, name of central database system", 0, null, null);
        mdRFCSI.addInfo("RFCSAPRL", 0, 4, 111, 0, null, "R/3 System, system release", 0, null, null);
        mdRFCSI.addInfo("RFCMACH", 0, 5, 115, 0, null, "RFC: SAP machine ID", 0, null, null);
        mdRFCSI.addInfo("RFCOPSYS", 0, 10, 120, 0, null, "R/3 System, operating system of application server", 0, null, null);
        mdRFCSI.addInfo("RFCTZONE", 0, 6, 130, 0, null, "Time zone (difference from UTC in seconds)", 0, null, null);
        mdRFCSI.addInfo("RFCDAYST", 0, 1, 136, 0, null, "Date and time, Daylight savings time flag", 0, null, null);
        mdRFCSI.addInfo("RFCIPADDR", 0, 15, 137, 0, null, "IP address", 0, null, null);
        mdRFCSI.addInfo("RFCKERNRL", 0, 4, 152, 0, null, "Kernel Release", 0, null, null);
        mdRFCSI.addInfo("RFCHOST2", 0, 32, 156, 0, null, "R/3 System, Name of application server", 0, null, null);
        mdRFCSI.addInfo("RFCSI_RESV", 0, 12, 188, 0, null, "Reserve field in RFCSI", 0, null, null);
        mdRFCSI.setTabLength(200);
        myRepos.addStructureDefinitionToCache(mdRFCSI);
        JCO.MetaData mdRFC_SYSTEM_INFO = new JCO.MetaData("RFC_SYSTEM_INFO");
        mdRFC_SYSTEM_INFO.addInfo("CURRENT_RESOURCES", 8, 4, 0, 0, null, "See structure RFCSI", 2, null, null);
        mdRFC_SYSTEM_INFO.addInfo("MAXIMAL_RESOURCES", 8, 4, 4, 0, null, "See structure RFCSI", 2, null, null);
        mdRFC_SYSTEM_INFO.addInfo("RECOMMENDED_DELAY", 8, 4, 8, 0, null, "See structure RFCSI", 2, null, null);
        mdRFC_SYSTEM_INFO.addInfo("RFCSI_EXPORT", 17, 12, 12, 0, null, "See structure RFCSI", 2, "RFCSI", null);
        myRepos.addFunctionInterfaceToCache(mdRFC_SYSTEM_INFO);
        JCO.MetaData mdRFCSI_UC = new JCO.MetaData("RFCSI");
        mdRFCSI_UC.addInfo("RFCPROTO", 0, 3, 6, 0, 0, null, "RFC log version", 0, null, null);
        mdRFCSI_UC.addInfo("RFCCHARTYP", 0, 4, 8, 6, 0, null, "Character set (SAP name)", 0, null, null);
        mdRFCSI_UC.addInfo("RFCINTTYP", 0, 3, 6, 14, 0, null, "Integer format (1 / 2 = little / big endian)", 0, null, null);
        mdRFCSI_UC.addInfo("RFCFLOTYP", 0, 3, 6, 20, 0, null, "Floating point format (1=IEEE, 2=IBM/370 format)", 0, null, null);
        mdRFCSI_UC.addInfo("RFCDEST", 0, 32, 64, 26, 0, null, "Logical destination (specified in function call)", 0, null, null);
        mdRFCSI_UC.addInfo("RFCHOST", 0, 8, 16, 90, 0, null, "Character field of length 8", 0, null, null);
        mdRFCSI_UC.addInfo("RFCSYSID", 0, 8, 16, 106, 0, null, "R/3 System, name of R/3 System", 0, null, null);
        mdRFCSI_UC.addInfo("RFCDATABS", 0, 8, 16, 122, 0, null, "R/3 System, name of R/3 System", 0, null, null);
        mdRFCSI_UC.addInfo("RFCDBHOST", 0, 32, 64, 138, 0, null, "Database host name", 0, null, null);
        mdRFCSI_UC.addInfo("RFCDBSYS", 0, 10, 20, 202, 0, null, "R/3 System, name of central database system", 0, null, null);
        mdRFCSI_UC.addInfo("RFCSAPRL", 0, 4, 8, 222, 0, null, "R/3 System, system release", 0, null, null);
        mdRFCSI_UC.addInfo("RFCMACH", 0, 5, 10, 230, 0, null, "RFC: SAP machine ID", 0, null, null);
        mdRFCSI_UC.addInfo("RFCOPSYS", 0, 10, 20, 240, 0, null, "R/3 System, operating system of application server", 0, null, null);
        mdRFCSI_UC.addInfo("RFCTZONE", 0, 6, 12, 260, 0, null, "Time zone (difference from UTC in seconds)", 0, null, null);
        mdRFCSI_UC.addInfo("RFCDAYST", 0, 1, 2, 272, 0, null, "Date and time, Daylight savings time flag", 0, null, null);
        mdRFCSI_UC.addInfo("RFCIPADDR", 0, 15, 30, 274, 0, null, "IP address", 0, null, null);
        mdRFCSI_UC.addInfo("RFCKERNRL", 0, 4, 8, 304, 0, null, "Kernel Release", 0, null, null);
        mdRFCSI_UC.addInfo("RFCHOST2", 0, 32, 64, 312, 0, null, "R/3 System, Name of application server", 0, null, null);
        mdRFCSI_UC.addInfo("RFCSI_RESV", 0, 12, 24, 376, 0, null, "Reserve field in RFCSI", 0, null, null);
        mdRFCSI_UC.setTabLength(400);
        myUnicodeRepos.addStructureDefinitionToCache(mdRFCSI_UC);
        JCO.MetaData mdRFC_SYSTEM_INFO_UC = new JCO.MetaData("RFC_SYSTEM_INFO");
        mdRFC_SYSTEM_INFO_UC.addInfo("CURRENT_RESOURCES", 8, 4, 0, 0, null, "See structure RFCSI", 2, null, null);
        mdRFC_SYSTEM_INFO_UC.addInfo("MAXIMAL_RESOURCES", 8, 4, 4, 0, null, "See structure RFCSI", 2, null, null);
        mdRFC_SYSTEM_INFO_UC.addInfo("RECOMMENDED_DELAY", 8, 4, 8, 0, null, "See structure RFCSI", 2, null, null);
        mdRFC_SYSTEM_INFO_UC.addInfo("RFCSI_EXPORT", 17, 24, 12, 0, null, "See structure RFCSI", 2, "RFCSI", null);
        myUnicodeRepos.addFunctionInterfaceToCache(mdRFC_SYSTEM_INFO_UC);
    }

    public static class MyRepository
    extends JCO.BasicRepository
    implements IRepository {
        public MyRepository(String name) {
            super(name);
        }
    }
}

