/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.jco;

import com.sap.mw.jco.Converter;
import com.sap.mw.jco.JCO;
import com.sap.mw.rfc.api.IRfcTable;

public class TableParameter
implements IRfcTable {
    JCO.Table table;
    Converter converter;
    String name;
    boolean active;
    int index;

    protected TableParameter(JCO.Table table, String name) {
        this(table, name, null);
    }

    protected TableParameter(JCO.Table table, String name, Converter converter) {
        this.table = table;
        this.name = name;
        this.converter = converter;
        this.active = false;
        this.index = 0;
    }

    protected TableParameter(JCO.Table table, String name, Converter converter, int index) {
        this.table = table;
        this.name = name;
        this.converter = converter;
        this.active = false;
        this.index = index;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getBytes(int row) {
        if (row >= this.table.num_rows || row < 0) {
            throw new ArrayIndexOutOfBoundsException("No such row " + row + "; possible: [0-" + (this.table.num_rows - 1) + ']');
        }
        this.table.row = row;
        byte[] ret = new byte[this.getRowLength()];
        int i = 0;
        while (i < this.table.num_fields) {
            switch (this.table.type[i]) {
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    this.converter.decodeNumber(this.table, ret, i, this.table.offset[i], this.table.length[i]);
                    break;
                }
                case 2: 
                case 4: {
                    this.converter.decodeBinary(this.table, ret, i, this.table.offset[i], this.table.length[i]);
                    break;
                }
                case 0: 
                case 1: 
                case 3: 
                case 6: {
                    this.converter.decodeChar(this.table, ret, i, this.table.offset[i], this.table.length[i]);
                    break;
                }
            }
            ++i;
        }
        return ret;
    }

    public void setBytes(int row, byte[] rfcBytes) {
        if (row >= this.table.num_rows || row < 0) {
            throw new ArrayIndexOutOfBoundsException("No such row " + row + "; possible: [0-" + (this.table.num_rows - 1) + ']');
        }
        this.table.row = row;
        int i = 0;
        while (i < this.table.num_fields && this.table.offset[i] < rfcBytes.length) {
            switch (this.table.type[i]) {
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    this.converter.encodeNumber(this.table, rfcBytes, i, this.table.offset[i], this.table.length[i]);
                    break;
                }
                case 2: 
                case 4: {
                    this.converter.encodeBinary(this.table, rfcBytes, i, this.table.offset[i], this.table.length[i]);
                    break;
                }
                case 0: 
                case 1: 
                case 3: 
                case 6: {
                    this.converter.encodeChar(this.table, rfcBytes, i, this.table.offset[i], this.table.length[i]);
                    break;
                }
            }
            ++i;
        }
    }

    public void appendRow(byte[] rfcBytes) {
        int index = this.table.num_rows;
        this.table.appendRow();
        this.setBytes(index, rfcBytes);
    }

    public void appendRows(int numRows) {
        this.table.appendRows(numRows);
    }

    public void clear() {
        this.active = true;
        this.table.clear();
    }

    public int getNumRows() {
        return this.table.num_rows;
    }

    public int getRowLength() {
        int table_length = 0;
        if (this.table.num_fields > 0) {
            int min_table_length = this.table.offset[this.table.num_fields - 1] + this.table.length[this.table.num_fields - 1];
            table_length = this.table.tab_length < min_table_length ? min_table_length : this.table.tab_length;
        }
        return table_length;
    }

    public JCO.Table getTable() {
        return this.table;
    }

    public boolean isActive() {
        return this.active;
    }

    public int getIndex() {
        return this.index;
    }

    public void ensureBufferCapacity(int numRows) {
        this.table.ensureBufferCapacity(numRows);
    }

    void setTable(JCO.Table table) {
        this.table = table;
    }
}

